% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegen.R
\name{pal_functions}
\alias{pal_functions}
\title{Output a character vector containing code for a \code{ggplot2} scale}
\usage{
pal_functions(
  palette,
  which = NULL,
  type = c("discrete", "continuous"),
  reverse = FALSE
)
}
\arguments{
\item{palette}{a \verb{[wacolors]} palette or palette name.}

\item{which}{if not \code{NULL}, the indices or names of a subset of colors to use.}

\item{type}{Either \code{continuous}, \code{discrete}, or \code{binned}. Use \code{continuous} if
you want to automatically interpolate between colors. Custom scale midpoints
are not supported (see \code{\link[=scale_fill_wa_c]{scale_fill_wa_c()}}).}

\item{reverse}{\code{TRUE} if the colors should be reversed.}
}
\value{
The generated code, invisibly, as a character vector.
}
\description{
Call this function to get the code for the \verb{scale_*} functions for a palette.
If using RStudio, the code will be loaded at the console prompt;
otherwise, it will be printed at the terminal. Assumes that \code{ggplot2} has
been loaded into the namespace, or will be by the time the scales are used.
}
\examples{
pal_functions("rainier")

}
