% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watson.R
\name{diam_clus}
\alias{diam_clus}
\title{Diametrical clustering}
\usage{
diam_clus(x, k, niter = 100)
}
\arguments{
\item{x}{a numeric data matrix, with rows corresponding to observations. Can be a dense matrix,
or any of the supported sparse matrices from \code{\link[Matrix]{Matrix}} package by \code{\link[Rcpp]{Rcpp}}.}

\item{k}{an integer giving the number of mixture components.}

\item{niter}{integer indicating the number of iterations of the diametrical clustering algorithm, default: 100.}
}
\value{
a matrix with the concentration directions with an attribute "id" defining the classified categories.
}
\description{
\code{diam_clus} clusters axial data on sphere using  the algorithm proposed in Dhillon et al. (2003).
}
\examples{
## Generate a sample 
a <- rmwat(n = 200, weights = c(0.5,0.5), kappa = c(20, 20),
                        mu = matrix(c(1,1,-1,1),nrow = 2))
## Fit basic model
q <- diam_clus(a, 2)
}
\references{
Inderjit S Dhillon, Edward M Marcotte, and Usman Roshan. Diametrical clustering 
for identifying anti-correlated gene clusters. Bioinformatics, 19(13):1612-1619, 2003.
}
