% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climate_by_stage.R
\name{climate_by_stages}
\alias{climate_by_stages}
\title{Summarise the climate variable by growth stages}
\usage{
climate_by_stages(
  climates,
  sowing,
  emergence,
  heading = NULL,
  flowering = NULL,
  maturity,
  latitude
)
}
\arguments{
\item{climates}{a data.frame for climate records}

\item{sowing}{date. an vector of sowing date}

\item{emergence}{numeric (days after sowing). an vector of emergence date}

\item{heading}{numeric (days after sowing). an vector of heading date (optional. see details)}

\item{flowering}{numeric (days after sowing). an vector of flowering time (optional. see details)}

\item{maturity}{numeric (days after sowing). an vector of maturity time}

\item{latitude}{latitude}
}
\value{
a data.frame for summarised climate variable by stages. See details for more information.
}
\description{
Summarise the climate variable by growth stages
}
\details{
Define of growth stages

\itemize{
   \item{S0: From start of year to emergence}
   \item{S1: From emergence to flowering time - 300Cd}
   \item{S2: From flowering time - 300Cd to flowering time + 100Cd}
   \item{S3: From flowering time + 100 Cd to flowering time + 600Cd}
   \item{S4: From flowering + 600Cd to maturity}
}

Climate variables
\itemize{
   \item{stage: defination of stages}
   \item{n: Number of days in each stage}
   \item{avgt: average temperature (C)}
   \item{sum.tt: total thermal time (Cd) with base temperature 0C}
   \item{avg.mint: average minimum temperature}
   \item{avg.maxt: average maximum temperature}
   \item{sum.rain: total rainfall}
   \item{avg.evap: average evapration}
   \item{avg.radn average radiation}
   \item{hot.days: number of hot days (daily maximum temperature is more than 30C)}
   \item{very.hot.days: number of very hot days (daily maximum temperature is more than 35C)}
   \item{frost.days: number of frost days (daily minimum temperature is less than 0C)}
   \item{hot.sum: total thermal time above 30C of hot days (daily maximum temperature is more than 30C)}
   \item{very.hot.sum: total thermal time above 35C of very hot days (daily maximum temperature is more than 35C)}
   \item{frost.sum: total thermal time below 0C of frost days (daily minimum temperature is less than 0C)}
   \item{vpd: vapour-pressure deficit }
   \item{te: transpiration efficiency}
   \item{bio.radn: bio.radn}
   \item{bio.water: bio.water}
   \item{bio.tt: bio.tt}
   \item{ptq: photothermal quotient}
   \item{avt.diffuse.radn: average diffuse radiation}
}
}
\examples{
if (FALSE) {
   sowing <- rep(as.Date("1981-05-01"), 10)
   emergence <- rep(10, 10)
   heading <- NULL
   flowering <- runif(10) * 20 + 50
   maturity <- runif(10) * 20 + 100
   latitude <- -27
   res <- climate_by_stages(climates = climates, 
                            sowing = sowing,
                            emergence = emergence, 
                            heading = heading,
                            flowering = flowering,
                            maturity = maturity,
                            latitude = latitude)
}
}
