% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confint_betabinom.default}
\alias{confint_betabinom.default}
\title{Beta Binomial Confidence Bounds for Quantiles and Probabilities}
\usage{
\method{confint_betabinom}{default}(
  x,
  status,
  dist_params,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  b_lives = c(0.01, 0.1, 0.5),
  bounds = c("two_sided", "lower", "upper"),
  conf_level = 0.95,
  direction = c("y", "x"),
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{A vector of binary data (0 or 1) indicating whether a unit is
a right censored observation (= 0) or a failure (= 1).}

\item{dist_params}{The parameters (\code{coefficients}) returned by \link{rank_regression}.}

\item{distribution}{Supposed distribution of the random variable. Has to be in
line with the specification made in \link{rank_regression}.}

\item{b_lives}{A numeric vector indicating the probabilities \eqn{p} of the
\eqn{B_p}-lives (quantiles) to be considered.}

\item{bounds}{A character string specifying the bound(s) to be computed.}

\item{conf_level}{Confidence level of the interval.}

\item{direction}{A character string specifying the direction of the confidence
interval. \code{"y"} for failure probabilities or \code{"x"} for quantiles.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A tibble with class \code{wt_confint} containing the following columns:
\itemize{
\item \code{x} : An ordered sequence of the lifetime characteristic regarding the
failed units, starting at \code{min(x)} and ending up at \code{max(x)}. With
\code{b_lives = c(0.01, 0.1, 0.5)} the 1\%, 10\% and 50\% quantiles are additionally
included in \code{x}, but only if the specified probabilities are in the range of
the estimated probabilities.
\item \code{rank} : Interpolated ranks as a function of probabilities, computed with
the converted approximation formula of \emph{Benard}.
\item \code{prob} : An ordered sequence of probabilities with specified \code{b_lives}
included.
\item \code{lower_bound} : Provided, if \code{bounds} is one of \code{"two_sided"} or \code{"lower"}.
Lower confidence limits with respect to \code{direction}, i.e. limits for
quantiles or probabilities.
\item \code{upper_bound} : Provided, if \code{bounds} is one of \code{"two_sided"} or \code{"upper"}.
Upper confidence limits with respect to \code{direction}, i.e. limits for
quantiles or probabilities.
\item \code{cdf_estimation_method} : A character that is always \code{NA_character}. Only needed for internal use.
}

Further information is stored in the attributes of this tibble:
\itemize{
\item \code{distribution} : Distribution which was specified in \link{rank_regression}.
\item \code{bounds} : Specified bound(s).
\item \code{direction} : Specified direction.
}
}
\description{
This function computes the non-parametric beta binomial confidence bounds (BB)
for quantiles and failure probabilities.
}
\details{
The procedure is similar to the \emph{Median Ranks} method but with the
difference that instead of finding the probability for the \emph{j}-th rank at the
50\% level the probability (probabilities) has (have) to be found at the given
confidence level.
}
\examples{
# Vectors:
obs <- seq(10000, 100000, 10000)
status_1 <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

cycles <- alloy$cycles
status_2 <- alloy$status

# Probability estimation:
prob_tbl <- estimate_cdf(
  x = obs,
  status = status_1,
  method = "johnson"
)

prob_tbl_2 <- estimate_cdf(
  x = cycles,
  status = status_2,
  method = "johnson"
)

# Model estimation with rank_regression():
rr <- rank_regression(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  distribution = "weibull",
  conf_level = 0.9
)

rr_2 <- rank_regression(
  x = prob_tbl_2$x,
  y = prob_tbl_2$prob,
  status = prob_tbl_2$status,
  distribution = "lognormal3"
)

# Example 1 - Two-sided 95\% confidence interval for probabilities ('y'):
conf_betabin_1 <- confint_betabinom(
  x = prob_tbl$x,
  status = prob_tbl$status,
  dist_params = rr$coefficients,
  distribution = "weibull",
  bounds = "two_sided",
  conf_level = 0.95,
  direction = "y"
)

# Example 2 - One-sided lower/upper 90\% confidence interval for quantiles ('x'):
conf_betabin_2_1 <- confint_betabinom(
  x = prob_tbl$x,
  status = prob_tbl$status,
  dist_params = rr$coefficients,
  distribution = "weibull",
  bounds = "lower",
  conf_level = 0.9,
  direction = "x"
)

conf_betabin_2_2 <- confint_betabinom(
  x = prob_tbl$x,
  status = prob_tbl$status,
  dist_params = rr$coefficients,
  distribution = "weibull",
  bounds = "upper",
  conf_level = 0.9,
  direction = "x"
)

# Example 3 - Two-sided 90\% confidence intervals for both directions using
# a three-parametric model:

conf_betabin_3_1 <- confint_betabinom(
  x = prob_tbl_2$x,
  status = prob_tbl_2$status,
  dist_params = rr_2$coefficients,
  distribution = "lognormal3",
  bounds = "two_sided",
  conf_level = 0.9,
  direction = "y"
)

conf_betabin_3_2 <- confint_betabinom(
  x = prob_tbl_2$x,
  status = prob_tbl_2$status,
  dist_params = rr_2$coefficients,
  distribution = "lognormal3",
  bounds = "two_sided",
  conf_level = 0.9,
  direction = "x"
)

}
\seealso{
\link{confint_betabinom}
}
