% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.R
\name{BottomRightOf}
\alias{BottomRightOf}
\title{Bottom right of}
\usage{
BottomRightOf(x = NULL, just = c("left", "bottom"), v.pad = 0, h.pad = 0)
}
\arguments{
\item{x}{target object, either a name, a object or NULL which refers to the last plotting object}

\item{just}{the part from the new object that should be attached to}

\item{v.pad}{vertical translational padding [0.0]}

\item{h.pad}{horizontal translational padding [0.0]}
}
\value{
a WDimGenerator
}
\description{
Place a new object to the bottom right corner of another.
}
\examples{
WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WHeatmap(matrix(c(rnorm(100)+1,rnorm(100)), nrow=10),
    cmp=CMPar(brewer.name = 'RdGy'), BottomRightOf(just=c('left','top')))

WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WHeatmap(matrix(c(rnorm(100)+1,rnorm(100)), nrow=10),
    cmp=CMPar(brewer.name = 'RdGy'), BottomRightOf(just=c('left','bottom')))

WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WHeatmap(matrix(c(rnorm(100)+1,rnorm(100)), nrow=10),
    cmp=CMPar(brewer.name = 'RdGy'), BottomRightOf(just=c('right','bottom')))
}
