% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex2raw.R
\name{hex2raw}
\alias{hex2raw}
\title{Convert String Hex Representation to Raw Vector}
\usage{
hex2raw(hex)
}
\arguments{
\item{hex}{character string or character vector containing a hexadecimal
representation.}
}
\value{
A \code{\link[base]{raw}} vector.

  The return value is a \code{list} of \code{raw} vectors when the argument
  \code{hex} contains more than one hexadecimal representation.
}
\description{
Converts a string hexadecimal representation to a \code{raw} vector.
}
\details{
Non-hexadecimal characters are removed.
}
\examples{
# create a character string containing a hexadecimal representation
hex <- "0101000000000000000000f03f0000000000000840"

# convert to raw vector
wkb <- hex2raw(hex)


# create a character vector containing a hexadecimal representation
hex <- c("01", "01", "00", "00", "00", "00", "00", "00", "00", "00", "00",
         "f0", "3f", "00", "00", "00", "00", "00", "00", "08", "40")

# convert to raw vector
wkb <- hex2raw(hex)


# create vector of two character strings each containing a hex representation
hex <- c("0101000000000000000000f03f0000000000000840",
         "010100000000000000000000400000000000000040")

# convert to list of two raw vectors
wkb <- hex2raw(hex)
}
\seealso{
\code{raw2hex} in package
  \href{https://cran.r-project.org/package=PKI}{\pkg{PKI}}, \code{\link{readWKB}}
}
