% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWKB.R
\name{readWKB}
\alias{readWKB}
\title{Convert \acronym{WKB} to Spatial Objects}
\usage{
readWKB(wkb, id = NULL, proj4string = CRS(as.character(NA)))
}
\arguments{
\item{wkb}{\code{list} in which each element is a \code{\link[base]{raw}}
vector consisting of a \acronym{WKB} geometry representation.}

\item{id}{character vector of unique identifiers of geometries. The length of
\code{id} must be the same as the length of the \code{wkb} list.}

\item{proj4string}{projection string of class
\code{\link[sp:CRS-class]{CRS}}.}
}
\value{
An object inheriting class \code{\link[sp:Spatial-class]{Spatial}}.

  The return value may be an object of class
  \code{\link[sp:SpatialPoints-class]{SpatialPoints}},
  \code{\link[sp:SpatialLines-class]{SpatialLines}},
  \code{\link[sp:SpatialPolygons-class]{SpatialPolygons}}, or a \code{list}
  in which each element is an object of class
  \code{\link[sp:SpatialPoints-class]{SpatialPoints}}. The class of the
  return value depends on the \acronym{WKB} geometry type as shown in the
  table below.

  \tabular{ll}{
  \strong{Type of \acronym{WKB} geometry} \tab \strong{Class of return value}\cr
  Point \tab \code{SpatialPoints}\cr
  LineString \tab \code{SpatialLines}\cr
  Polygon \tab \code{SpatialPolygons}\cr
  MultiPoint \tab \code{list} of \code{SpatialPoints}\cr
  MultiLineString \tab \code{SpatialLines}\cr
  MultiPolygon \tab \code{SpatialPolygons}\cr
  }
}
\description{
Converts well-known binary (\acronym{WKB}) geometry representations to
\code{Spatial} objects.
}
\details{
Supported \acronym{WKB} geometry types are Point, LineString,
  Polygon, MultiPoint, MultiLineString, and MultiPolygon. All elements in the
  \code{list} must have the same \acronym{WKB} geometry type. The
  \acronym{WKB} geometry representations may use little-endian or big-endian
  byte order.

  The argument \code{wkb} may also be a \code{\link[base]{raw}} vector
  consisting of one \acronym{WKB} geometry representation. In that case, the
  argument \code{id} must have length one.
}
\examples{
# create a list of WKB geometry representations of type Point
wkb <- list(
  as.raw(c(0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40)),
  as.raw(c(0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40))
)

# convert to object of class SpatialPoints
obj <- readWKB(wkb)


# create a list of WKB geometry representations of type MultiPoint
wkb <- list(
  as.raw(c(0x01, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40)),
  as.raw(c(0x01, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40)))

# convert to list of objects of class SpatialPoints
obj <- readWKB(wkb)


# create a list of WKB geometry representations of type MultiLineString
wkb <- list(
  as.raw(c(0x01, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02,
           0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
           0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x40)),
  as.raw(c(0x01, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02,
           0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
           0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f)))

# convert to object of class SpatialLines
obj <- readWKB(wkb)


# create a list of WKB geometry representations of type Polygon
wkb <- list(
  as.raw(c(0x01, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00,
           0x00, 0x00, 0x34, 0x03, 0xf0, 0xac, 0xce, 0x66, 0x5d, 0xc0, 0x8f,
           0x27, 0x95, 0x21, 0xab, 0xa6, 0x44, 0x40, 0xa0, 0x32, 0x81, 0x18,
           0x78, 0x83, 0x5d, 0xc0, 0xc8, 0xd2, 0xa0, 0xee, 0x23, 0x0b, 0x41,
           0x40, 0x80, 0xec, 0x72, 0x54, 0xde, 0xb1, 0x5f, 0xc0, 0xc8, 0xd2,
           0xa0, 0xee, 0x23, 0x0b, 0x41, 0x40, 0xec, 0x1b, 0x04, 0xc0, 0x87,
           0xce, 0x5f, 0xc0, 0x8f, 0x27, 0x95, 0x21, 0xab, 0xa6, 0x44, 0x40,
           0x34, 0x03, 0xf0, 0xac, 0xce, 0x66, 0x5d, 0xc0, 0x8f, 0x27, 0x95,
           0x21, 0xab, 0xa6, 0x44, 0x40)),
  as.raw(c(0x01, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00,
           0x00, 0x00, 0x08, 0x36, 0xdc, 0x8b, 0x9f, 0x3d, 0x51, 0xc0, 0x0f,
           0xb3, 0x2a, 0x6a, 0x3f, 0x1c, 0x46, 0x40, 0x47, 0xcb, 0x54, 0xe7,
           0xcb, 0x5e, 0x51, 0xc0, 0x45, 0x81, 0x50, 0x31, 0xfa, 0x80, 0x42,
           0x40, 0xa9, 0xba, 0x74, 0x6d, 0xf5, 0xa1, 0x53, 0xc0, 0x45, 0x81,
           0x50, 0x31, 0xfa, 0x80, 0x42, 0x40, 0xe8, 0x4f, 0xed, 0xc8, 0x21,
           0xc3, 0x53, 0xc0, 0x0f, 0xb3, 0x2a, 0x6a, 0x3f, 0x1c, 0x46, 0x40,
           0x08, 0x36, 0xdc, 0x8b, 0x9f, 0x3d, 0x51, 0xc0, 0x0f, 0xb3, 0x2a,
           0x6a, 0x3f, 0x1c, 0x46, 0x40)))

# convert to object of class SpatialPolygons
obj <- readWKB(wkb)


# specify id and proj4string
obj <- readWKB(
  wkb,
  id = c("San Francisco", "New York"),
  proj4string = sp::CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
)
}
\seealso{
\code{\link{writeWKB}}, \code{\link{hex2raw}}
}
\keyword{wkb}
