% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmwpowd.R
\name{wmwpowd}
\alias{wmwpowd}
\title{Precise and Accurate Monte Carlo Power Calculation by Inputting Distributions F and G (wmwpowd)}
\usage{
wmwpowd(n, m, distn, distm, sides, alpha = 0.05, nsims = 10000)
}
\arguments{
\item{n}{Sample size for the first distribution (numeric)}

\item{m}{Sample size for the second distribution (numeric)}

\item{alpha}{Type I error rate or significance level (numeric)}

\item{distn}{Base R’s name for the first distribution and any required parameters 
("norm", "beta", "cauchy", "f", "gamma", "lnorm", "unif", "weibull","exp", "chisq", "t", "doublex")}

\item{distm}{Base R’s name for the second distribution and any required parameters 
("norm", "beta", "cauchy", "f", "gamma", "lnorm", "unif", "weibull","exp", "chisq", "t", "doublex")}

\item{sides}{Options are “two.sided”, “less”, or “greater”. “less” means the
alternative hypothesis is that distn is less than distm (string)}

\item{nsims}{Number of simulated datasets for calculating power; 10,000 is the default.
For exact power to the hundredths place (e.g., 0.90 or 90\%) around 100,000 simulated
datasets is recommended (numeric)}
}
\description{
\emph{wmwpowd} has two purposes:

1. Calculate the power for a one-sided or two-sided Wilcoxon-Mann-Whitney test
with an empirical p-value given two user specified distributions.

2. Calculate p, the P(X<Y), where X represents random draws from one continuous
probability distribution and Y represents random draws from another distribution;
p is useful for quantifying the effect size that the Wilcoxon-Mann-Whitney test is
assessing.

Both 1. and 2. are calculated empirically using simulated data and output automatically.
}
\note{
Example of distn, distm: “norm(1,2)” or “exp(1)”

In addition to all continuous distributions supported in Base R, \emph{wmwpowd} also supports the 
double exponential distribution from the smoothmest package

The output WMWOdds is p expressed as odds p/(1-p)

Use $ notation to select specific output parameters

The function has been optimized to run through simulations quickly; long wait times are unlikely 
for n and m of 50 or fewer
}
\references{
Mollan K.R., Trumble I.M., Reifeis S.A., Ferrer O., Bay C.P., Baldoni P.L.,
Hudgens M.G. Exact Power of the Rank-Sum Test for a Continuous Variable, 
arXiv:1901.04597 [stat.ME], Jan. 2019.
}
