% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_rename.R
\name{wflow_rename}
\alias{wflow_rename}
\title{Rename files and directories}
\usage{
wflow_rename(
  files,
  to,
  message = NULL,
  git = TRUE,
  dry_run = FALSE,
  project = "."
)
}
\arguments{
\item{files}{character. Files to be renamed. Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.}

\item{to}{character. New names for the files. Must be the same length as
\code{files}.}

\item{message}{character (default: NULL). A commit message.}

\item{git}{logical (default: TRUE). Commit the changes (only applicable if
Git repository is present).}

\item{dry_run}{logical (default: FALSE). Preview the files to be renamed but
do not actually rename them.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
An object of class \code{wflow_rename}, which is a list with the
  following elements:

  \itemize{

  \item \bold{files}: The relative path(s) to the renamed file(s).

  \item \bold{to}: The new relative path(s) to rename the file(s).

  \item \bold{message}: The message describing the commit (if applicable).

  \item \bold{git}: The input argument \code{git}.

  \item \bold{dry_run}: The input argument \code{dry_run}.

  \item \bold{commit}:The object returned by
  \link[git2r]{git2r}::\code{\link[git2r]{commit}} (only included if \code{dry_run
  == FALSE}).

  \item \bold{files_git}: The relative path(s) to the file(s) renamed from
  the Git repository.

  }
}
\description{
\code{wflow_rename} renames files and directories. If the file to be renamed
is an R Markdown file, the corresponding HTML and other related files are
also renamed. If the workflowr project uses Git, \code{wflow_rename} commits
the changes.
}
\examples{
\dontrun{

# rename a single file
wflow_rename("analysis/file.Rmd", "analysis/new.Rmd", "rename old analysis.")
# rename multiple files
wflow_rename(c("analysis/file.Rmd", "output/small-data.txt"),
             c("analysis/new.Rmd", "output/new-data.txt"),
             "rename old analysis and its associated data.")
}

}
\seealso{
\code{\link{wflow_git_commit}}
}
