#' @details
#' Functions for the import, transformation, and analysis of muscle physiology
#' experiments. Currently supported experiment types: work loop, simple twitch,
#' and tetanus.
#'
#' Data that are stored in .ddf format (e.g. generated by Aurora Scientific's
#' Dynamic Muscle Control and Analysis Software) are easily imported via
#' \code{read_ddf()}, \code{read_analyze_wl()}, or \code{read_analyze_wl_dir()}.
#' Doing so generates objects of class \code{muscle_stim}, which are formatted
#' to work nicely with workloopR's core functions. Data that are read from other
#'  file formats can be constructed into \code{muscle_stim} objects via
#'  \code{as_muscle_stim()}.
#'
#' Prior to analyses, data can be transformed or corrected. Transformational
#' functions include gear ratio correction (\code{fix_GR()}), position inversion
#' (\code{invert_position()}), and subsetting of particular cycles within a work
#' loop experiment (\code{select_cycles()}).
#'
#' Core data analytical functions include \code{analyze_workloop()} for work
#' loop files and \code{isometric_timing()} for twitches.
#' \code{analyze_workloop()} computes instantaneous velocity, net work,
#' instantaneous power, and net power for work loop experiments on a per-cycle
#' basis. \code{isometric_timing()} provides summarization of twitch kinetics.
#'
#' Some functions are readily available for batch processing of files. The
#' \code{read_analyze_wl_dir()} function allows for the batch import, cycle
#' selection, gear ratio correction, and ultimately work & power computation for
#' all work loop experiment files within a specified directory. The
#' \code{get_wl_metadata()} and \code{summarize_wl_trials()} functions organize
#' scanned files by recency (according to their time of last modification:
#' 'mtime') and then report work and power output in the order that trials were
#' run. This ultimately allows for the \code{time_correct()} function to correct
#'  for degradation of the muscle (according to power & work) over time,
#'  assuming that the first and final trials are identical in experimental
#'  parameters.
#'
#' Please feel free to contact either Vikram or Shree with suggestions or code
#' development requests (see contact info below). We are especially interested
#' in expanding our data import functions to accommodate file types other than
#' .ddf in future versions of workloopR.
#'
#' @keywords internal
"_PACKAGE"
#> [1] "_PACKAGE"
