% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_analysis_functions.R
\name{read_analyze_wl_dir}
\alias{read_analyze_wl_dir}
\title{Read and analyze work loop files from a directory}
\usage{
read_analyze_wl_dir(file_path, pattern = "*.ddf", sort_by = "mtime", ...)
}
\arguments{
\item{file_path}{Directory in which files are located}

\item{pattern}{Regular expression used to specify files of interest. Defaults
to all .ddf files within file_path}

\item{sort_by}{Metadata by which files should be sorted to be in the correct
run order. Defaults to \code{mtime}, which is time of last modification of
files.}

\item{...}{Additional arguments to be passed to \code{read_analyze_wl()},
\code{analyze_workloop()}, \code{select_cycles()}, or \code{read_ddf()}.}
}
\value{
A list containing \code{analyzed_workloop} objects, one for each file that is
imported and subsequently analyzed. The list is sorted according to the
\code{sort_by} parameter, which by default uses the time of last modification
of each file's contents (mtime).
}
\description{
All-in-one function to import multiple workloop .ddf files from a directory,
sort them by mtime, analyze them, and store the resulting objects in an
ordered list.
}
\details{
Work loop data files will be imported and then arranged in the order
in which they were run (assuming run order is reflected in \code{mtime}).
Chiefly used in conjunction with \code{summarize_wl_trials()} and
\code{time_correct()} if time correction is desired.
}
\section{Warning}{

Most systems we have encountered record Position data in millimeters
and Force in millinewtons, and therefore this function assumes data are
recorded in those units. Through a series of internal conversions, this
function computes velocity in meters/sec, work in Joules, and power in
Watts. If your raw data do not originate in millimeters and millinewtons,
please transform your data accordingly and ignore what you see in the
attribute \code{units}.
}

\examples{

library(workloopR)

# batch read and analyze files included with workloopR
analyzed_wls <- read_analyze_wl_dir(system.file("extdata/wl_duration_trials",
                                                package = 'workloopR'),
                                    phase_from_peak = TRUE,
                                    cycle_def = "p2p", keep_cycles = 2:4)

}
\references{
Josephson RK. 1985. Mechanical Power output from Striated Muscle
 during Cyclic Contraction. Journal of Experimental Biology 114: 493-512.
}
\seealso{
\code{\link{read_analyze_wl}},
\code{\link{get_wl_metadata}},
\code{\link{summarize_wl_trials}},
\code{\link{time_correct}}

Other data analyses: 
\code{\link{analyze_workloop}()},
\code{\link{isometric_timing}()},
\code{\link{read_analyze_wl}()}

Other data import functions: 
\code{\link{as_muscle_stim}()},
\code{\link{get_wl_metadata}()},
\code{\link{read_analyze_wl}()},
\code{\link{read_ddf_dir}()},
\code{\link{read_ddf}()}

Other workloop functions: 
\code{\link{analyze_workloop}()},
\code{\link{fix_GR}()},
\code{\link{get_wl_metadata}()},
\code{\link{invert_position}()},
\code{\link{read_analyze_wl}()},
\code{\link{select_cycles}()},
\code{\link{summarize_wl_trials}()},
\code{\link{time_correct}()}

Other batch analyses: 
\code{\link{get_wl_metadata}()},
\code{\link{summarize_wl_trials}()},
\code{\link{time_correct}()}
}
\author{
Shreeram Senthivasan
}
\concept{batch analyses}
\concept{data analyses}
\concept{data import functions}
\concept{workloop functions}
