% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sampledata.R
\name{check_sampledata}
\alias{check_sampledata}
\title{Check and prepare genetic sample metadata}
\usage{
check_sampledata(
  Sample,
  Date,
  AnimalRef,
  GeneticSex,
  lat,
  lng,
  SType,
  extraCols = NULL
)
}
\arguments{
\item{Sample}{A vector of sample unique identifier codes.}

\item{Date}{A vector of sample collection dates in 'YYYY-MM-DD' format.}

\item{AnimalRef}{A vector of identifier codes of the particular individual
that the sample belongs to.}

\item{GeneticSex}{A vector of genetic sex information
('F' for female, 'M' for male, NA for unknown).}

\item{lat}{A vector of latitude coordinates in the WGS84 coordinate system
(EPSG: 4326).}

\item{lng}{A vector of longitude coordinates in the WGS84 coordinate system
(EPSG: 4326).}

\item{SType}{A vector of sample types eg.: scat, hair, tissue.}

\item{extraCols}{A vector of extra column names that the user wants to include
in sampledata data frame (see Details).}
}
\value{
A data frame with at least 7 columns and a number of rows equal to the length
of the input vector. Each column corresponds to one of the input parameters.
If the function executes without warnings or errors, the result from
\code{check_sampledata()} can be used as an input parameter for other functions
within this package: \code{\link[=get_colony]{get_colony()}}, \code{\link[=get_ped]{get_ped()}}, \code{\link[=org_fams]{org_fams()}}
and \code{\link[=plot_table]{plot_table()}}.
}
\description{
Verifies the consistency of columns in the genetic sample metadata and
prepares it for use with other functions in the \code{wpeR} package. The function
ensures that the provided data is properly formatted and conforms to the standards
of functions that make up the \code{wpeR} package.
}
\details{
By specifying the \code{extraCols} parameter additional information can be included
in the sampledata dataframe. Such additional information is not required for
the functioning of the \code{wpeR} package functions, but can be useful to the user
when interpreting results. When including additional columns the function
inputs (Sample, Date, AnimalRef...) have to be defined as a vector extracted from
data frame column (eg. Sample = dataframe$column) and the \code{extraCols} parameter is defined,
as a vector of column names form the same data frame (eg. extraCols = c(column1, column2,
column3)).
}
\examples{
sampledata <- check_sampledata(
  Sample = wolf_samples$Sample,
  Date = wolf_samples$Date,
  AnimalRef = wolf_samples$AnimalRef,
  GeneticSex = wolf_samples$GeneticSex,
  lat = wolf_samples$lat,
  lng = wolf_samples$lng,
  SType = wolf_samples$SType
)

}
