% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_temp_wd.R
\name{set_temp_wd}
\alias{set_temp_wd}
\title{Sets a temporary working directory within the function scope}
\usage{
set_temp_wd(
  temp_cwd,
  func,
  ...,
  err_msg = "An error has occured in the function set_temp_wd"
)
}
\arguments{
\item{temp_cwd}{character.  Folder path to temporarily set the working directory}

\item{func}{function.  A function that used a directory path}

\item{...}{Additional arguments to be passed to the param func.}

\item{err_msg}{character.  Message sent to stop function if an error occurs.}
}
\value{
Unknown.  The return type from the param func.
}
\description{
Sets a temporary working directory within the function scope
}
\examples{
\dontrun{

temp_wd <- "example/folder/address/to/change"

get_data <- set_temp_wd(temp_wd, read.csv, file = "file.csv")

}
}
