test_that("census_geo_api_names() for 2020", {
  # TODO: Verify against table names here: https://api.census.gov/data/2020/dec/dhc/variables.html
  
  expect_equal(
    census_geo_api_names("2020"),
    list(
      r_whi = "P12I_001N",
      r_bla = "P12J_001N",
      r_his = "P12H_001N",
      r_asi = c("P12L_001N", "P12M_001N"),
      r_oth = c("P12K_001N", "P12N_001N", "P12O_001N")
    )
  )
  
  expect_equal(
    census_geo_api_names("2020", age = FALSE, sex = TRUE),
    c(
      census_geo_api_names("2020", age = FALSE, sex = FALSE),
      list(
        r_mal_whi = "P12I_002N",
        r_mal_bla = "P12J_002N",
        r_mal_his = "P12H_002N",
        r_mal_asi = c("P12L_002N", "P12M_002N"),
        r_mal_oth = c("P12K_002N", "P12N_002N", "P12O_002N"),
        r_fem_whi = "P12I_026N",
        r_fem_bla = "P12J_026N",
        r_fem_his = "P12H_026N",
        r_fem_asi = c("P12L_026N", "P12M_026N"),
        r_fem_oth = c("P12K_026N", "P12N_026N", "P12O_026N")
      )
    )
  )
  
  expect_equal(
    census_geo_api_names("2020", age = TRUE, sex = FALSE),
    c(
      census_geo_api_names("2020", age = FALSE, sex = FALSE),
      list(
        r_1_whi = c("P12I_003N", "P12I_027N"),
        r_1_bla = c("P12J_003N", "P12J_027N"),
        r_1_his = c("P12H_003N", "P12H_027N"),
        r_1_asi = c("P12L_003N", "P12M_003N", "P12L_027N", "P12M_027N"),
        r_1_oth = c("P12K_003N", "P12N_003N", "P12O_003N", "P12K_027N", "P12N_027N", "P12O_027N"),
        r_2_whi = c("P12I_004N", "P12I_028N"),
        r_2_bla = c("P12J_004N", "P12J_028N"),
        r_2_his = c("P12H_004N", "P12H_028N"),
        r_2_asi = c("P12L_004N", "P12M_004N", "P12L_028N", "P12M_028N"),
        r_2_oth = c("P12K_004N", "P12N_004N", "P12O_004N", "P12K_028N", "P12N_028N", "P12O_028N"),
        r_3_whi = c("P12I_005N", "P12I_029N"),
        r_3_bla = c("P12J_005N", "P12J_029N"),
        r_3_his = c("P12H_005N", "P12H_029N"),
        r_3_asi = c("P12L_005N", "P12M_005N", "P12L_029N", "P12M_029N"),
        r_3_oth = c("P12K_005N", "P12N_005N", "P12O_005N", "P12K_029N", "P12N_029N", "P12O_029N"),
        r_4_whi = c("P12I_006N", "P12I_030N"),
        r_4_bla = c("P12J_006N", "P12J_030N"),
        r_4_his = c("P12H_006N", "P12H_030N"),
        r_4_asi = c("P12L_006N", "P12M_006N", "P12L_030N", "P12M_030N"),
        r_4_oth = c("P12K_006N", "P12N_006N", "P12O_006N", "P12K_030N", "P12N_030N", "P12O_030N"),
        r_5_whi = c("P12I_007N", "P12I_031N"),
        r_5_bla = c("P12J_007N", "P12J_031N"),
        r_5_his = c("P12H_007N", "P12H_031N"),
        r_5_asi = c("P12L_007N", "P12M_007N", "P12L_031N", "P12M_031N"),
        r_5_oth = c("P12K_007N", "P12N_007N", "P12O_007N", "P12K_031N", "P12N_031N", "P12O_031N"),
        r_6_whi = c("P12I_008N", "P12I_032N"),
        r_6_bla = c("P12J_008N", "P12J_032N"),
        r_6_his = c("P12H_008N", "P12H_032N"),
        r_6_asi = c("P12L_008N", "P12M_008N", "P12L_032N", "P12M_032N"),
        r_6_oth = c("P12K_008N", "P12N_008N", "P12O_008N", "P12K_032N", "P12N_032N", "P12O_032N"),
        r_7_whi = c("P12I_009N", "P12I_033N"),
        r_7_bla = c("P12J_009N", "P12J_033N"),
        r_7_his = c("P12H_009N", "P12H_033N"),
        r_7_asi = c("P12L_009N", "P12M_009N", "P12L_033N", "P12M_033N"),
        r_7_oth = c("P12K_009N", "P12N_009N", "P12O_009N", "P12K_033N", "P12N_033N", "P12O_033N"),
        r_8_whi = c("P12I_010N", "P12I_034N"),
        r_8_bla = c("P12J_010N", "P12J_034N"),
        r_8_his = c("P12H_010N", "P12H_034N"),
        r_8_asi = c("P12L_010N", "P12M_010N", "P12L_034N", "P12M_034N"),
        r_8_oth = c("P12K_010N", "P12N_010N", "P12O_010N", "P12K_034N", "P12N_034N", "P12O_034N"),
        r_9_whi = c("P12I_011N", "P12I_035N"),
        r_9_bla = c("P12J_011N", "P12J_035N"),
        r_9_his = c("P12H_011N", "P12H_035N"),
        r_9_asi = c("P12L_011N", "P12M_011N", "P12L_035N", "P12M_035N"),
        r_9_oth = c("P12K_011N", "P12N_011N", "P12O_011N", "P12K_035N", "P12N_035N", "P12O_035N"),
        r_10_whi = c("P12I_012N", "P12I_036N"),
        r_10_bla = c("P12J_012N", "P12J_036N"),
        r_10_his = c("P12H_012N", "P12H_036N"),
        r_10_asi = c("P12L_012N", "P12M_012N", "P12L_036N", "P12M_036N"),
        r_10_oth = c("P12K_012N", "P12N_012N", "P12O_012N", "P12K_036N", "P12N_036N", "P12O_036N"),
        r_11_whi = c("P12I_013N", "P12I_037N"),
        r_11_bla = c("P12J_013N", "P12J_037N"),
        r_11_his = c("P12H_013N", "P12H_037N"),
        r_11_asi = c("P12L_013N", "P12M_013N", "P12L_037N", "P12M_037N"),
        r_11_oth = c("P12K_013N", "P12N_013N", "P12O_013N", "P12K_037N", "P12N_037N", "P12O_037N"),
        r_12_whi = c("P12I_014N", "P12I_038N"),
        r_12_bla = c("P12J_014N", "P12J_038N"),
        r_12_his = c("P12H_014N", "P12H_038N"),
        r_12_asi = c("P12L_014N", "P12M_014N", "P12L_038N", "P12M_038N"),
        r_12_oth = c("P12K_014N", "P12N_014N", "P12O_014N", "P12K_038N", "P12N_038N", "P12O_038N"),
        r_13_whi = c("P12I_015N", "P12I_039N"),
        r_13_bla = c("P12J_015N", "P12J_039N"),
        r_13_his = c("P12H_015N", "P12H_039N"),
        r_13_asi = c("P12L_015N", "P12M_015N", "P12L_039N", "P12M_039N"),
        r_13_oth = c("P12K_015N", "P12N_015N", "P12O_015N", "P12K_039N", "P12N_039N", "P12O_039N"),
        r_14_whi = c("P12I_016N", "P12I_040N"),
        r_14_bla = c("P12J_016N", "P12J_040N"),
        r_14_his = c("P12H_016N", "P12H_040N"),
        r_14_asi = c("P12L_016N", "P12M_016N", "P12L_040N", "P12M_040N"),
        r_14_oth = c("P12K_016N", "P12N_016N", "P12O_016N", "P12K_040N", "P12N_040N", "P12O_040N"),
        r_15_whi = c("P12I_017N", "P12I_041N"),
        r_15_bla = c("P12J_017N", "P12J_041N"),
        r_15_his = c("P12H_017N", "P12H_041N"),
        r_15_asi = c("P12L_017N", "P12M_017N", "P12L_041N", "P12M_041N"),
        r_15_oth = c("P12K_017N", "P12N_017N", "P12O_017N", "P12K_041N", "P12N_041N", "P12O_041N"),
        r_16_whi = c("P12I_018N", "P12I_042N"),
        r_16_bla = c("P12J_018N", "P12J_042N"),
        r_16_his = c("P12H_018N", "P12H_042N"),
        r_16_asi = c("P12L_018N", "P12M_018N", "P12L_042N", "P12M_042N"),
        r_16_oth = c("P12K_018N", "P12N_018N", "P12O_018N", "P12K_042N", "P12N_042N", "P12O_042N"),
        r_17_whi = c("P12I_019N", "P12I_043N"),
        r_17_bla = c("P12J_019N", "P12J_043N"),
        r_17_his = c("P12H_019N", "P12H_043N"),
        r_17_asi = c("P12L_019N", "P12M_019N", "P12L_043N", "P12M_043N"),
        r_17_oth = c("P12K_019N", "P12N_019N", "P12O_019N", "P12K_043N", "P12N_043N", "P12O_043N"),
        r_18_whi = c("P12I_020N", "P12I_044N"),
        r_18_bla = c("P12J_020N", "P12J_044N"),
        r_18_his = c("P12H_020N", "P12H_044N"),
        r_18_asi = c("P12L_020N", "P12M_020N", "P12L_044N", "P12M_044N"),
        r_18_oth = c("P12K_020N", "P12N_020N", "P12O_020N", "P12K_044N", "P12N_044N", "P12O_044N"),
        r_19_whi = c("P12I_021N", "P12I_045N"),
        r_19_bla = c("P12J_021N", "P12J_045N"),
        r_19_his = c("P12H_021N", "P12H_045N"),
        r_19_asi = c("P12L_021N", "P12M_021N", "P12L_045N", "P12M_045N"),
        r_19_oth = c("P12K_021N", "P12N_021N", "P12O_021N", "P12K_045N", "P12N_045N", "P12O_045N"),
        r_20_whi = c("P12I_022N", "P12I_046N"),
        r_20_bla = c("P12J_022N", "P12J_046N"),
        r_20_his = c("P12H_022N", "P12H_046N"),
        r_20_asi = c("P12L_022N", "P12M_022N", "P12L_046N", "P12M_046N"),
        r_20_oth = c("P12K_022N", "P12N_022N", "P12O_022N", "P12K_046N", "P12N_046N", "P12O_046N"),
        r_21_whi = c("P12I_023N", "P12I_047N"),
        r_21_bla = c("P12J_023N", "P12J_047N"),
        r_21_his = c("P12H_023N", "P12H_047N"),
        r_21_asi = c("P12L_023N", "P12M_023N", "P12L_047N", "P12M_047N"),
        r_21_oth = c("P12K_023N", "P12N_023N", "P12O_023N", "P12K_047N", "P12N_047N", "P12O_047N"),
        r_22_whi = c("P12I_024N", "P12I_048N"),
        r_22_bla = c("P12J_024N", "P12J_048N"),
        r_22_his = c("P12H_024N", "P12H_048N"),
        r_22_asi = c("P12L_024N", "P12M_024N", "P12L_048N", "P12M_048N"),
        r_22_oth = c("P12K_024N", "P12N_024N", "P12O_024N", "P12K_048N", "P12N_048N", "P12O_048N"),
        r_23_whi = c("P12I_025N", "P12I_049N"),
        r_23_bla = c("P12J_025N", "P12J_049N"),
        r_23_his = c("P12H_025N", "P12H_049N"),
        r_23_asi = c("P12L_025N", "P12M_025N", "P12L_049N", "P12M_049N"),
        r_23_oth = c("P12K_025N", "P12N_025N", "P12O_025N", "P12K_049N", "P12N_049N", "P12O_049N")
      )
    )
  )
  
  expect_equal(
    census_geo_api_names("2020", age = TRUE, sex = TRUE),
    c(
      census_geo_api_names("2020", age = FALSE, sex = FALSE),
      list(
        r_mal_1_whi = "P12I_003N",
        r_mal_1_bla = "P12J_003N",
        r_mal_1_his = "P12H_003N",
        r_mal_1_asi = c("P12L_003N", "P12M_003N"),
        r_mal_1_oth = c("P12K_003N", "P12N_003N", "P12O_003N"),
        r_mal_2_whi = "P12I_004N",
        r_mal_2_bla = "P12J_004N",
        r_mal_2_his = "P12H_004N",
        r_mal_2_asi = c("P12L_004N", "P12M_004N"),
        r_mal_2_oth = c("P12K_004N", "P12N_004N", "P12O_004N"),
        r_mal_3_whi = "P12I_005N",
        r_mal_3_bla = "P12J_005N",
        r_mal_3_his = "P12H_005N",
        r_mal_3_asi = c("P12L_005N", "P12M_005N"),
        r_mal_3_oth = c("P12K_005N", "P12N_005N", "P12O_005N"),
        r_mal_4_whi = "P12I_006N",
        r_mal_4_bla = "P12J_006N",
        r_mal_4_his = "P12H_006N",
        r_mal_4_asi = c("P12L_006N", "P12M_006N"),
        r_mal_4_oth = c("P12K_006N", "P12N_006N", "P12O_006N"),
        r_mal_5_whi = "P12I_007N",
        r_mal_5_bla = "P12J_007N",
        r_mal_5_his = "P12H_007N",
        r_mal_5_asi = c("P12L_007N", "P12M_007N"),
        r_mal_5_oth = c("P12K_007N", "P12N_007N", "P12O_007N"),
        r_mal_6_whi = "P12I_008N",
        r_mal_6_bla = "P12J_008N",
        r_mal_6_his = "P12H_008N",
        r_mal_6_asi = c("P12L_008N", "P12M_008N"),
        r_mal_6_oth = c("P12K_008N", "P12N_008N", "P12O_008N"),
        r_mal_7_whi = "P12I_009N",
        r_mal_7_bla = "P12J_009N",
        r_mal_7_his = "P12H_009N",
        r_mal_7_asi = c("P12L_009N", "P12M_009N"),
        r_mal_7_oth = c("P12K_009N", "P12N_009N", "P12O_009N"),
        r_mal_8_whi = "P12I_010N",
        r_mal_8_bla = "P12J_010N",
        r_mal_8_his = "P12H_010N",
        r_mal_8_asi = c("P12L_010N", "P12M_010N"),
        r_mal_8_oth = c("P12K_010N", "P12N_010N", "P12O_010N"),
        r_mal_9_whi = "P12I_011N",
        r_mal_9_bla = "P12J_011N",
        r_mal_9_his = "P12H_011N",
        r_mal_9_asi = c("P12L_011N", "P12M_011N"),
        r_mal_9_oth = c("P12K_011N", "P12N_011N", "P12O_011N"),
        r_mal_10_whi = "P12I_012N",
        r_mal_10_bla = "P12J_012N",
        r_mal_10_his = "P12H_012N",
        r_mal_10_asi = c("P12L_012N", "P12M_012N"),
        r_mal_10_oth = c("P12K_012N", "P12N_012N", "P12O_012N"),
        r_mal_11_whi = "P12I_013N",
        r_mal_11_bla = "P12J_013N",
        r_mal_11_his = "P12H_013N",
        r_mal_11_asi = c("P12L_013N", "P12M_013N"),
        r_mal_11_oth = c("P12K_013N", "P12N_013N", "P12O_013N"),
        r_mal_12_whi = "P12I_014N",
        r_mal_12_bla = "P12J_014N",
        r_mal_12_his = "P12H_014N",
        r_mal_12_asi = c("P12L_014N", "P12M_014N"),
        r_mal_12_oth = c("P12K_014N", "P12N_014N", "P12O_014N"),
        r_mal_13_whi = "P12I_015N",
        r_mal_13_bla = "P12J_015N",
        r_mal_13_his = "P12H_015N",
        r_mal_13_asi = c("P12L_015N", "P12M_015N"),
        r_mal_13_oth = c("P12K_015N", "P12N_015N", "P12O_015N"),
        r_mal_14_whi = "P12I_016N",
        r_mal_14_bla = "P12J_016N",
        r_mal_14_his = "P12H_016N",
        r_mal_14_asi = c("P12L_016N", "P12M_016N"),
        r_mal_14_oth = c("P12K_016N", "P12N_016N", "P12O_016N"),
        r_mal_15_whi = "P12I_017N",
        r_mal_15_bla = "P12J_017N",
        r_mal_15_his = "P12H_017N",
        r_mal_15_asi = c("P12L_017N", "P12M_017N"),
        r_mal_15_oth = c("P12K_017N", "P12N_017N", "P12O_017N"),
        r_mal_16_whi = "P12I_018N",
        r_mal_16_bla = "P12J_018N",
        r_mal_16_his = "P12H_018N",
        r_mal_16_asi = c("P12L_018N", "P12M_018N"),
        r_mal_16_oth = c("P12K_018N", "P12N_018N", "P12O_018N"),
        r_mal_17_whi = "P12I_019N",
        r_mal_17_bla = "P12J_019N",
        r_mal_17_his = "P12H_019N",
        r_mal_17_asi = c("P12L_019N", "P12M_019N"),
        r_mal_17_oth = c("P12K_019N", "P12N_019N", "P12O_019N"),
        r_mal_18_whi = "P12I_020N",
        r_mal_18_bla = "P12J_020N",
        r_mal_18_his = "P12H_020N",
        r_mal_18_asi = c("P12L_020N", "P12M_020N"),
        r_mal_18_oth = c("P12K_020N", "P12N_020N", "P12O_020N"),
        r_mal_19_whi = "P12I_021N",
        r_mal_19_bla = "P12J_021N",
        r_mal_19_his = "P12H_021N",
        r_mal_19_asi = c("P12L_021N", "P12M_021N"),
        r_mal_19_oth = c("P12K_021N", "P12N_021N", "P12O_021N"),
        r_mal_20_whi = "P12I_022N",
        r_mal_20_bla = "P12J_022N",
        r_mal_20_his = "P12H_022N",
        r_mal_20_asi = c("P12L_022N", "P12M_022N"),
        r_mal_20_oth = c("P12K_022N", "P12N_022N", "P12O_022N"),
        r_mal_21_whi = "P12I_023N",
        r_mal_21_bla = "P12J_023N",
        r_mal_21_his = "P12H_023N",
        r_mal_21_asi = c("P12L_023N", "P12M_023N"),
        r_mal_21_oth = c("P12K_023N", "P12N_023N", "P12O_023N"),
        r_mal_22_whi = "P12I_024N",
        r_mal_22_bla = "P12J_024N",
        r_mal_22_his = "P12H_024N",
        r_mal_22_asi = c("P12L_024N", "P12M_024N"),
        r_mal_22_oth = c("P12K_024N", "P12N_024N", "P12O_024N"),
        r_mal_23_whi = "P12I_025N",
        r_mal_23_bla = "P12J_025N",
        r_mal_23_his = "P12H_025N",
        r_mal_23_asi = c("P12L_025N", "P12M_025N"),
        r_mal_23_oth = c("P12K_025N", "P12N_025N", "P12O_025N"),
        r_fem_1_whi = "P12I_027N",
        r_fem_1_bla = "P12J_027N",
        r_fem_1_his = "P12H_027N",
        r_fem_1_asi = c("P12L_027N", "P12M_027N"),
        r_fem_1_oth = c("P12K_027N", "P12N_027N", "P12O_027N"),
        r_fem_2_whi = "P12I_028N",
        r_fem_2_bla = "P12J_028N",
        r_fem_2_his = "P12H_028N",
        r_fem_2_asi = c("P12L_028N", "P12M_028N"),
        r_fem_2_oth = c("P12K_028N", "P12N_028N", "P12O_028N"),
        r_fem_3_whi = "P12I_029N",
        r_fem_3_bla = "P12J_029N",
        r_fem_3_his = "P12H_029N",
        r_fem_3_asi = c("P12L_029N", "P12M_029N"),
        r_fem_3_oth = c("P12K_029N", "P12N_029N", "P12O_029N"),
        r_fem_4_whi = "P12I_030N",
        r_fem_4_bla = "P12J_030N",
        r_fem_4_his = "P12H_030N",
        r_fem_4_asi = c("P12L_030N", "P12M_030N"),
        r_fem_4_oth = c("P12K_030N", "P12N_030N", "P12O_030N"),
        r_fem_5_whi = "P12I_031N",
        r_fem_5_bla = "P12J_031N",
        r_fem_5_his = "P12H_031N",
        r_fem_5_asi = c("P12L_031N", "P12M_031N"),
        r_fem_5_oth = c("P12K_031N", "P12N_031N", "P12O_031N"),
        r_fem_6_whi = "P12I_032N",
        r_fem_6_bla = "P12J_032N",
        r_fem_6_his = "P12H_032N",
        r_fem_6_asi = c("P12L_032N", "P12M_032N"),
        r_fem_6_oth = c("P12K_032N", "P12N_032N", "P12O_032N"),
        r_fem_7_whi = "P12I_033N",
        r_fem_7_bla = "P12J_033N",
        r_fem_7_his = "P12H_033N",
        r_fem_7_asi = c("P12L_033N", "P12M_033N"),
        r_fem_7_oth = c("P12K_033N", "P12N_033N", "P12O_033N"),
        r_fem_8_whi = "P12I_034N",
        r_fem_8_bla = "P12J_034N",
        r_fem_8_his = "P12H_034N",
        r_fem_8_asi = c("P12L_034N", "P12M_034N"),
        r_fem_8_oth = c("P12K_034N", "P12N_034N", "P12O_034N"),
        r_fem_9_whi = "P12I_035N",
        r_fem_9_bla = "P12J_035N",
        r_fem_9_his = "P12H_035N",
        r_fem_9_asi = c("P12L_035N", "P12M_035N"),
        r_fem_9_oth = c("P12K_035N", "P12N_035N", "P12O_035N"),
        r_fem_10_whi = "P12I_036N",
        r_fem_10_bla = "P12J_036N",
        r_fem_10_his = "P12H_036N",
        r_fem_10_asi = c("P12L_036N", "P12M_036N"),
        r_fem_10_oth = c("P12K_036N", "P12N_036N", "P12O_036N"),
        r_fem_11_whi = "P12I_037N",
        r_fem_11_bla = "P12J_037N",
        r_fem_11_his = "P12H_037N",
        r_fem_11_asi = c("P12L_037N", "P12M_037N"),
        r_fem_11_oth = c("P12K_037N", "P12N_037N", "P12O_037N"),
        r_fem_12_whi = "P12I_038N",
        r_fem_12_bla = "P12J_038N",
        r_fem_12_his = "P12H_038N",
        r_fem_12_asi = c("P12L_038N", "P12M_038N"),
        r_fem_12_oth = c("P12K_038N", "P12N_038N", "P12O_038N"),
        r_fem_13_whi = "P12I_039N",
        r_fem_13_bla = "P12J_039N",
        r_fem_13_his = "P12H_039N",
        r_fem_13_asi = c("P12L_039N", "P12M_039N"),
        r_fem_13_oth = c("P12K_039N", "P12N_039N", "P12O_039N"),
        r_fem_14_whi = "P12I_040N",
        r_fem_14_bla = "P12J_040N",
        r_fem_14_his = "P12H_040N",
        r_fem_14_asi = c("P12L_040N", "P12M_040N"),
        r_fem_14_oth = c("P12K_040N", "P12N_040N", "P12O_040N"),
        r_fem_15_whi = "P12I_041N",
        r_fem_15_bla = "P12J_041N",
        r_fem_15_his = "P12H_041N",
        r_fem_15_asi = c("P12L_041N", "P12M_041N"),
        r_fem_15_oth = c("P12K_041N", "P12N_041N", "P12O_041N"),
        r_fem_16_whi = "P12I_042N",
        r_fem_16_bla = "P12J_042N",
        r_fem_16_his = "P12H_042N",
        r_fem_16_asi = c("P12L_042N", "P12M_042N"),
        r_fem_16_oth = c("P12K_042N", "P12N_042N", "P12O_042N"),
        r_fem_17_whi = "P12I_043N",
        r_fem_17_bla = "P12J_043N",
        r_fem_17_his = "P12H_043N",
        r_fem_17_asi = c("P12L_043N", "P12M_043N"),
        r_fem_17_oth = c("P12K_043N", "P12N_043N", "P12O_043N"),
        r_fem_18_whi = "P12I_044N",
        r_fem_18_bla = "P12J_044N",
        r_fem_18_his = "P12H_044N",
        r_fem_18_asi = c("P12L_044N", "P12M_044N"),
        r_fem_18_oth = c("P12K_044N", "P12N_044N", "P12O_044N"),
        r_fem_19_whi = "P12I_045N",
        r_fem_19_bla = "P12J_045N",
        r_fem_19_his = "P12H_045N",
        r_fem_19_asi = c("P12L_045N", "P12M_045N"),
        r_fem_19_oth = c("P12K_045N", "P12N_045N", "P12O_045N"),
        r_fem_20_whi = "P12I_046N",
        r_fem_20_bla = "P12J_046N",
        r_fem_20_his = "P12H_046N",
        r_fem_20_asi = c("P12L_046N", "P12M_046N"),
        r_fem_20_oth = c("P12K_046N", "P12N_046N", "P12O_046N"),
        r_fem_21_whi = "P12I_047N",
        r_fem_21_bla = "P12J_047N",
        r_fem_21_his = "P12H_047N",
        r_fem_21_asi = c("P12L_047N", "P12M_047N"),
        r_fem_21_oth = c("P12K_047N", "P12N_047N", "P12O_047N"),
        r_fem_22_whi = "P12I_048N",
        r_fem_22_bla = "P12J_048N",
        r_fem_22_his = "P12H_048N",
        r_fem_22_asi = c("P12L_048N", "P12M_048N"),
        r_fem_22_oth = c("P12K_048N", "P12N_048N", "P12O_048N"),
        r_fem_23_whi = "P12I_049N",
        r_fem_23_bla = "P12J_049N",
        r_fem_23_his = "P12H_049N",
        r_fem_23_asi = c("P12L_049N", "P12M_049N"),
        r_fem_23_oth = c("P12K_049N", "P12N_049N", "P12O_049N")
      )
    )
  )
})

test_that("census_geo_api_url()", {
  expect_equal(
    census_geo_api_url("2020"),
    "https://api.census.gov/data/2020/dec/dhc?"
  )
  expect_equal(
    census_geo_api_url("2010"),
    "https://api.census.gov/data/2010/dec/sf1?"
  )
  expect_equal(
    census_geo_api_url("2000"),
    "https://api.census.gov/data/2000/dec/sf1?"
  )
  expect_error(census_geo_api_url("2023"))
})
