% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunMCMIAnalysis.R
\name{RunMCMIAnalysis}
\alias{RunMCMIAnalysis}
\title{Monte Carlo SEM with Multiple Imputation (WsMed Workflow)}
\usage{
RunMCMIAnalysis(
  data_missing,
  m = 5,
  method_num = "pmm",
  seed = 123,
  M_C1,
  M_C2,
  Y_C1,
  Y_C2,
  C_C1 = NULL,
  C_C2 = NULL,
  C = NULL,
  C_type = NULL,
  W = NULL,
  W_type = NULL,
  keep_W_raw = TRUE,
  keep_C_raw = TRUE,
  sem_model,
  Na = "MI",
  R = 20000L,
  alpha = c(0.001, 0.01, 0.05),
  decomposition = "eigen",
  pd = TRUE,
  tol = 1e-06
)
}
\arguments{
\item{data_missing}{Data frame with missing values.}

\item{m}{Integer, number of imputations. Default \code{5}.}

\item{method_num}{Character, imputation method for numeric variables
(e.g., \code{"pmm"}, \code{"norm"}). Default \code{"pmm"}.}

\item{seed}{Integer random seed (passed to \code{mice} and \code{MCMI2}).}

\item{M_C1, M_C2}{Character vectors: mediator names at condition 1 & 2
(same length).}

\item{Y_C1, Y_C2}{Character scalars: outcome names at condition 1 & 2.}

\item{C_C1, C_C2}{Optional character vectors: within-subject controls.}

\item{C}{Optional character vector: between-subject controls.}

\item{C_type}{Optional vector (length = \code{C});
each element \code{"continuous"}, \code{"categorical"}, or
\code{"auto"} (default).}

\item{W}{Optional character vector: moderator name(s).}

\item{W_type}{Optional vector (length = \code{W});
same coding as \code{C_type}.}

\item{keep_W_raw, keep_C_raw}{Logical; keep raw W / C columns in the
processed data? Defaults \code{TRUE}.}

\item{sem_model}{Character string, lavaan syntax of the SEM to be fitted.}

\item{Na}{Character, missing-data strategy. Currently only
\code{"MI"} is implemented.}

\item{R}{Integer, number of Monte Carlo samples (default \code{20000L}).}

\item{alpha}{Numeric vector, significance levels for two-sided CIs
(default \code{c(0.001, 0.01, 0.05)}).}

\item{decomposition}{Decomposition used by \code{MCMI2()}
(\code{"eigen"} | \code{"chol"} | \code{"svd"}). Default \code{"eigen"}.}

\item{pd}{Logical, enforce positive-definite covariance (default \code{TRUE}).}

\item{tol}{Numeric tolerance for PD checks. Default \code{1e-6}.}
}
\value{
A list with three elements:
\describe{
\item{\code{mc_result}}{A \code{semmcci} object returned by
\code{MCMI2()}.}
\item{\code{first_imputed_data}}{The first processed data frame
(useful for inspection or plotting).}
\item{\code{imputation_summary}}{Diagnostics from
\code{PrepareMissingData()}.}
}
}
\description{
\code{RunMCMIAnalysis()} is a helper that:
\enumerate{
\item imputes missing data via \code{\link{PrepareMissingData}};
\item generates all WsMed variables in each completed data set;
\item fits the user-supplied SEM model to each replicate; and
\item pools the results via \code{MCMI2()}, producing Monte Carlo
confidence intervals (MCCI) for all model parameters.
}
}
\details{
Internally the function calls:
\itemize{
\item \code{PrepareMissingData()} – performs multiple imputation
(\strong{logreg} / \strong{polyreg} for categorical variables,
and \code{method_num} for numeric) and applies
\code{\link{PrepareData}} to each imputed set;
\item \code{MCMI2()} – pools parameter estimates across the
\code{m} imputations and draws \code{R} Monte Carlo samples.
}

Only the missing-data strategy \code{Na = "MI"} is supported.
}
\seealso{
\code{\link{PrepareMissingData}}, \code{\link{PrepareData}}, \code{MCMI2},
\code{wsMed}
}
\keyword{internal}
