% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmap.R
\name{plotmap}
\alias{plotmap}
\title{Map clusters from a \code{clust} object}
\usage{
plotmap(
  inclust,
  spltlvl = length(inclust$clusters),
  nodesize = c(1, 3),
  filename = NA
)
}
\arguments{
\item{inclust}{A \code{clust} object, as created with \code{wsyn::clust}}

\item{spltlvl}{The split level in the clustering to use. This is the index of inclust$clusters.
Default the final split.}

\item{nodesize}{A length = 2 vector giving the minimum and maximum node size for plotting. Defaults to c(1,3).}

\item{filename}{a filename, possibly including path info, but without a file extension. If present,
exports the plot as a .pdf using the specified filename. Default \code{NA} uses the default plotting
device.}
}
\value{
\code{plotmap} produces a map.
}
\description{
Produces a map of the locations of sampling for a \code{clust} object, with colors indicating 
module (cluster) identity.
The sizes of nodes (locations) are scaled according to the strength of membership in its module.
}
\examples{
Tmax<-500
tim<-1:Tmax
ts1<-sin(2*pi*tim/5)
ts1s<-sin(2*pi*tim/5+pi/2)
ts2<-sin(2*pi*tim/12)
ts2s<-sin(2*pi*tim/12+pi/2)
gp1A<-1:2
gp1B<-3:4
gp2A<-5:6
gp2B<-7:8
d<-matrix(NA,Tmax,8)
d[,c(gp1A,gp1B)]<-ts1
d[,c(gp2A,gp2B)]<-ts1s
d[,c(gp1A,gp2A)]<-d[,c(gp1A,gp2A)]+matrix(ts2,Tmax,4)
d[,c(gp1B,gp2B)]<-d[,c(gp1B,gp2B)]+matrix(ts2s,Tmax,4)
d<-d+matrix(rnorm(Tmax*8,0,2),Tmax,8)
d<-t(d)
d<-cleandat(d,1:Tmax,1)$cdat
coords<-data.frame(X=c(rep(1,4),rep(2,4)),Y=rep(c(1:2,4:5),times=2))
cl5<-clust(dat=d,times=1:Tmax,coords=coords,method="ReXWT",tsrange=c(4,6))
plotmap(cl5)
cl12<-clust(dat=d,times=1:Tmax,coords=coords,method="ReXWT",tsrange=c(11,13))
plotmap(cl12)

}
\references{
Walter, J. A., et al. (2017) The geography of spatial synchrony. Ecology Letters. 
doi: 10.1111/ele.12782
}
\seealso{
\code{\link{clust}}, \code{browseVignettes("wsyn")}
}
\author{
Jonathan Walter, \email{jaw3es@virginia.edu}
}
