% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{mLCMG}
\alias{mLCMG}
\title{Compute the mLCM of the vector of the number of production rules
in a production table.}
\usage{
mLCMG(LHS)
}
\arguments{
\item{LHS}{Vector of integers. The left-hand side of a grammar object \code{G}.}
}
\value{
Integer. The least common multiple of the vector of the available 
        rules for each non-terminal.
}
\description{
Compute the least common multiple of the prime factors 
of the vector of the number of rules applicable for each 
non-terminal symbol.
}
\details{
For removing the bias of the modulo rule in 
         grammatical evolution, see Keijzer, M., O'Neill, M., 
         Ryan, C. and Cattolico, M. (2002). 
         This version works for integer genes coded in the 
         domain \code{1:mlCM} without bias in choosing a rule.
         See Keijzer et al. (2002).
         However, if the mLCM and \code{2^k} are relative prime, it is impossible 
         to find an unbiased binary coding.
         The choice bias is considerably lower than for \code{MinCodonPrecision()}.
}
\examples{
library(xegaBNF)
g<-compileBNF(booleanGrammar())
mLCMG(g$PT$LHS)
}
\references{
Keijzer, M., O'Neill, M., Ryan, C. and Cattolico, M. (2002)
         Grammatical Evolution Rules: The Mod and the Bucket Rule,
         pp. 123-130. 
         In: Foster, J. A., Lutton, E., Miller, J., Ryan, C. and 
             Tettamanzi, A. (Eds.): Genetic Programming.
         Lecture Notes in Computer Science, Vol.2278, 
             Springer, Heidelberg. 
         <doi:10.1007/3-540-45984-7_12>
}
\seealso{
Other Utility: 
\code{\link{ChoiceVector}()}
}
\concept{Utility}
