% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.xtvfreg}
\alias{coef.xtvfreg}
\title{Coefficient extraction method for xtvfreg objects}
\usage{
\method{coef}{xtvfreg}(object, equation = "mean", group = NULL, ...)
}
\arguments{
\item{object}{An object of class "xtvfreg"}

\item{equation}{Character; "mean" or "variance"}

\item{group}{Optional; specific group to extract. If NULL, returns all groups}

\item{...}{Additional arguments (currently unused)}
}
\value{
Named vector or list of coefficient vectors
}
\description{
Coefficient extraction method for xtvfreg objects
}
\examples{
set.seed(456)
n_id <- 30
n_time <- 4
panel_data <- data.frame(
id = factor(rep(1:n_id, each = n_time)),  # Convert to factor here
group = rep(c("A", "B"), length.out = n_id * n_time),
x = rnorm(n_id * n_time)
)
panel_data$m_x <- ave(panel_data$x, panel_data$id, FUN = mean)
panel_data$d_x <- panel_data$x - panel_data$m_x
panel_data$y <- 1 + panel_data$m_x + rnorm(n_id * n_time)

result <- xtvfreg(
  formula = y ~ 1,
  data = panel_data,
  group = "group",
  panel_id = "id",
  mean_vars = c("m_x", "d_x"),
  var_vars = "m_x",
  verbose = FALSE
)

# Extract coefficients
coef(result, equation = "mean")
coef(result, equation = "mean", group = "A")
}
