% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_xpm_facet}
\alias{plot_xpm_facet}
\title{generate faceted plots from xpm data}
\usage{
plot_xpm_facet(xpm_data, plot_type = "scatter")
}
\arguments{
\item{xpm_data}{a xpm object (from \code{\link[=read_xpm]{read_xpm()}}) or list containing parsed objects.}

\item{plot_type}{visualization type: "scatter" (default) or "area".}
}
\value{
a ggplot2 object with:
\itemize{
\item Dual facets showing x/y axis relationships
\item Automatic data transformation for visualization
\item NULL if invalid plot_type specified
}
}
\description{
creates dual-panel visualizations of xpm data with scatter or area plots.
}
\examples{
\donttest{
library(xvm)
xpm_file_path <- system.file("extdata/gibbs.xpm", package = "xvm")
xpm_data <- read_xpm(xpm_file_path)
plot_xpm_facet(xpm_data) # plot pseudo-3D from xpm file
}
}
