% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers_balance_sheet}
\alias{get_tickers_balance_sheet}
\title{Get balance sheet for multiple tickers}
\usage{
get_tickers_balance_sheet(
  tickers_obj,
  freq = c("annual", "quarterly"),
  start = NULL,
  end = NULL,
  balance_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{tickers_obj}{A tickers object created with get_tickers()}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{balance_keys}{Vector of specific balance sheet keys to include (default all)
See \code{valid_balance_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
A list of tibbles with balance sheet data for each ticker
}
\description{
Retrieves balance sheet data from Yahoo Finance for multiple specified ticker symbols.
Balance sheets show a company's assets, liabilities, and shareholders' equity
at a specific point in time.
}
\details{
See \code{get_balance_sheet} for more details on the balance sheet.
}
\examples{
\dontrun{
tech_tickers <- get_tickers(c("AAPL", "MSFT", "GOOG"))
tech_balance <- get_tickers_balance_sheet(tech_tickers)
}
}
