% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R, R/model.R
\name{bma}
\alias{bma}
\alias{model_bma_predictive}
\alias{model_bma_marginal}
\title{Posterior Weights and Model Averaging Setup}
\usage{
bma(..., seed = sample(.Machine$integer.max, 1))

model_bma_predictive(
  log_post_pred,
  adjustment = 0,
  w_prior = 1,
  mcmc = NULL,
  fun = NULL
)

model_bma_marginal(log_marginal, w_prior = 1, mcmc = NULL, fun = NULL)
}
\arguments{
\item{...}{Named calls to the \code{bma_model()} function.}

\item{seed}{an integer which is used to specify the seed when sampling
from the different models (e.g. in \code{posterior()}).}

\item{log_post_pred}{a matrix containing the log likelihood for each
observation on each iteration of the MCMC.  The matrix should have
dimensions (number-of-MCMC-iteration) by (number of observations).}

\item{adjustment}{an adjustment to be applied to the posterior log-predictive
likelihood.  A simple bias correction in Ando & Tsay (2010) is: - (number
of parameters in the model) / 2.}

\item{w_prior}{the prior weight for the model.}

\item{mcmc}{a named list (or dataframe) of MCMC samples of model parameters.}

\item{fun}{a function which takes the MCMC samples and returns a value of
interest.}

\item{log_marginal}{The log marginal likelihood of the model.}
}
\value{
bma: A list containing the prior and posterior weights for each
model, the sampled model (\code{model_index}) at each MCMC iteration and
the arguments supplied to each \code{bma_model()} call.

model_bma: A named list of the arguments, with a
"yodel_bma_candidate" class attached.

model_bma: A named list of the arguments, with a
"yodel_bma_candidate" class attached.
}
\description{
Calculate posterior weights of each model and optionally
supply MCMC samples and functions (through the \code{bma_model()} function) to
calculate a quantity of interest from each model using the \code{posterior()}
function.
}
\details{
It is required that if MCMC samples are supplied, that each
MCMC run must have the same number of collected samples.
}
\examples{
# Minimal example
fit <- bma(
  linear = model_bma_predictive(
    # mcmc = data.frame(b1 = 1:5, b2 = 11:15, sigma = seq(.1, .5, .1)),
    log_post_pred = matrix(log(1:100), 5, 20),
    adjustment = - 3 / 2,
    w_prior = .5
  ),
  quad = model_bma_predictive(
    # mcmc = data.frame(b1 = 1:5 / 2, b2 = 11:15 / 2, b3 = 5:1, sigma = seq(.1, .5, .1)),
    log_post_pred = matrix(log(2:101), 5, 20),
    adjustment = - 4 / 2,
    w_prior = .5
  )
)

fit$w_prior
fit$w_post
}
\references{
Ando, T., & Tsay, R. (2010). Predictive likelihood for Bayesian
model selection and averaging. International Journal of Forecasting, 26(4),
744-763.
}
