% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit_glm.R
\name{zglm}
\alias{zglm}
\alias{zlogit}
\alias{zprobit}
\alias{zpoisson}
\title{Run a glm model in a pipe}
\usage{
zglm(
  data,
  formula,
  family = gaussian,
  weights,
  subset,
  na.action,
  start = NULL,
  etastart,
  mustart,
  offset,
  control = list(...),
  model = TRUE,
  method = "glm.fit",
  x = FALSE,
  y = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  ...
)

zlogit(data, formula, ...)

zprobit(data, formula, ...)

zpoisson(data, formula, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the model data.}

\item{formula}{The \code{formula} to be fitted.}

\item{family}{See the \code{glm} function.}

\item{weights}{See the \code{glm} function.}

\item{subset}{See the \code{glm} function.}

\item{na.action}{See the \code{glm} function.}

\item{start}{See the \code{glm} function.}

\item{etastart}{See the \code{glm} function.}

\item{mustart}{See the \code{glm} function.}

\item{offset}{See the \code{glm} function.}

\item{control}{See the \code{glm} function.}

\item{model}{See the \code{glm} function.}

\item{method}{See the \code{glm} function.}

\item{x}{See the \code{glm} function.}

\item{y}{See the \code{glm} function.}

\item{singular.ok}{See the \code{glm} function.}

\item{contrasts}{See the \code{glm} function.}

\item{...}{Other arguments to be passed to the \code{glm} function.}
}
\value{
A fitted model.
}
\description{
These functions are wrappers for the \link{glm} function. The \code{zglm} function can
be used to estimate any generalized linear model in a pipe. The \code{zlogit},
\code{zprobit}, and \code{zpoisson} functions can be used to estimate specific models.
All of these functions rely on the \code{glm} function for the actual estimation,
they simply pass the corresponding values to the \code{family} parameter of the
\code{glm} function.

Usage of these functions is very similar to the \link{zlm} function (a wrapper
for lm), for detailed examples, check out the entry for that function.

The \code{zlogit} function calls \code{zglm}, specifying \code{family=binomial(link="logit")}.

The \code{zprobit} function calls \code{zglm}, specifying \code{family=binomial(link="probit")}.

The \code{zpoisson} function calls \code{zglm}, specifying \code{family="poisson"}.
}
\seealso{
\itemize{
\item \link{zlm} is the wrapper for \link{lm}, probably the most common fitting
function. The help file for \link{zlm} function includes several usage examples.
}
}
