/*
 * Copyright (c) 1992, Bruno Grossniklaus, grossnik@iam.unibe.ch
 * 
 * I added new features for special use at the IAM and fixed some bugs.
 * 
 */

/*
 * Copyright (c) 1990, William C. Ogden, ogden@nmsu.edu
 * 
 * Permission is granted to copy and distribute this file in modified or
 * unmodified form, for noncommercial use, provided (a) this copyright notice
 * is preserved, (b) no attempt is made to restrict redistribution of this
 * file, and (c) this file is not distributed as part of any collection whose
 * redistribution is restricted by a compilation copyright.
 */



#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>

#include <stdlib.h>

#include "bc_base.h"

/* local globals */
int             month_id, location_id;

static void
init_field_ptr()
{
	int             i;

	/* the same sequence as for text_fields in bc_globals.c */
	i = 0;
	citekey_id = i;
	field_ptr[i++] = Bc_base_window->base_window_citekey;
	author_id = i;
	field_ptr[i++] = Bc_base_window->base_window_author;
	field_ptr[i++] = Bc_base_window->base_window_address;
	field_ptr[i++] = Bc_base_window->base_window_booktitle;
	field_ptr[i++] = Bc_base_window->base_window_chapter;
	field_ptr[i++] = Bc_base_window->base_window_edition;
	editor_id = i;
	field_ptr[i++] = Bc_base_window->base_window_editor;
	field_ptr[i++] = Bc_base_window->base_window_howpublished;
	field_ptr[i++] = Bc_base_window->base_window_institution;
	field_ptr[i++] = Bc_base_window->base_window_journal;
	key_id = i;
	field_ptr[i++] = Bc_base_window->base_window_key;
	month_id = i;
	field_ptr[i++] = Bc_base_window->base_window_month;
	field_ptr[i++] = Bc_base_window->base_window_note;
	field_ptr[i++] = Bc_base_window->base_window_number;
	field_ptr[i++] = Bc_base_window->base_window_organization;
	field_ptr[i++] = Bc_base_window->base_window_pages;
	field_ptr[i++] = Bc_base_window->base_window_publisher;
	field_ptr[i++] = Bc_base_window->base_window_school;
	field_ptr[i++] = Bc_base_window->base_window_series;
	field_ptr[i++] = Bc_base_window->base_window_title;
	field_ptr[i++] = Bc_base_window->base_window_type;
	field_ptr[i++] = Bc_base_window->base_window_volume;
	year_id = i;
	field_ptr[i++] = Bc_base_window->base_window_year;

#ifdef CRINDEX_FIELD
	field_ptr[i++] = Bc_base_window->base_window_crindex;
#endif

#ifdef CROSS_REF_KEY_FIELD
	field_ptr[i++] = Bc_base_window->base_window_crossref;
#endif

#ifdef DATE_FIELD
	field_ptr[i++] = Bc_base_window->base_window_date;
#endif

#ifdef KEYWORDS_FIELD
	field_ptr[i++] = Bc_base_window->base_window_keywords;
#endif

#ifdef LOCATION_FIELD
	location_id = i;
	field_ptr[i++] = Bc_base_window->base_window_location;
#endif


#ifdef SIGNATURE_FIELD
	field_ptr[i++] = Bc_base_window->base_window_signature;
#endif

#ifdef ISBN_FIELD
	field_ptr[i++] = Bc_base_window->base_window_isbn;
#endif

	num_of_fields = i;

	if (num_of_fields != NUM_OF_FIELDS) {
		fprintf(PRINT_TO, "bibcard: num_of_fields(%d) != NUM_OF_FIELDS(%d) ERROR in bc_base.c\n", num_of_fields, NUM_OF_FIELDS);
		fprintf(PRINT_TO, "bibcard: Set the right NUM_OF_FIELDS in the Makefile!\n");
		fprintf(PRINT_TO, "bibcard: (%d + additional fields\n", STD_NUM_OF_FIELDS);
		exit(ERROR);
	}
}



static void
set_settings()
{
	int             i;
	char          **avlist;

	/*
	 * Set the find and sort setting lists
	 */
	avlist = (char **) malloc((num_of_fields + 7) * sizeof(char *));
	avlist[0] = (char *) PANEL_CHOICE_STRINGS;
	for (i = 0; i < num_of_fields; i++) {
		if (i == month_id)
			avlist[i + 1] = (char *) text_fields[month_id][1];
		else
#ifdef LOCATION_FIELD
		if (i == location_id)
			avlist[i + 1] = (char *) text_fields[location_id][1];
		else
#endif
			avlist[i + 1] = (char *)
				xv_get(field_ptr[i], PANEL_LABEL_STRING);
	}

	avlist[++i] = (char *) "Annotation:";
	avlist[++i] = (char *) "All fields";
	avlist[++i] = (char *) "NONE";

	avlist[++i] = (char *) NULL;	/* NULL-terminate strings */
	avlist[++i] = (char *) NULL;	/* NULL-terminate avlist */

	xv_set(Bc_find_popup->find_popup_find_field_setting1, ATTR_LIST, avlist, NULL);
	xv_set(Bc_find_popup->find_popup_find_field_setting2, ATTR_LIST, avlist, NULL);
	xv_set(Bc_find_popup->find_popup_find_field_setting3, ATTR_LIST, avlist, NULL);
	xv_set(Bc_find_popup->find_popup_find_field_setting4, ATTR_LIST, avlist, NULL);
	xv_set(Bc_find_popup->find_popup_find_field_setting5, ATTR_LIST, avlist, NULL);

	xv_set(Bc_properties_popup->properties_popup_find_field1, ATTR_LIST, avlist, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field2, ATTR_LIST, avlist, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field3, ATTR_LIST, avlist, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field4, ATTR_LIST, avlist, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field5, ATTR_LIST, avlist, NULL);

	/* remove NONE, all fields, annotation field for sorting list */
	avlist[i - 2] = (char *) NULL;
	avlist[i - 3] = (char *) NULL;
	avlist[i - 4] = (char *) NULL;

	xv_set(Bc_sort_popup->sort_popup_sort_field_setting, ATTR_LIST, avlist, NULL);
	xv_set(Bc_properties_popup->properties_popup_sort_field, ATTR_LIST, avlist, NULL);

	free((char *) avlist);


	/*
	 * Set the ref types
	 */
	avlist = (char **) malloc((NUM_OF_REF_TYPES + 5) * sizeof(char *));
	avlist[0] = (char *) PANEL_CHOICE_STRINGS;
	for (i = 0; i < NUM_OF_REF_TYPES; i++) {
		avlist[i + 1] = ref_types_show_fct[i].ref_type_label;
	}

	avlist[++i] = (char *) "All types";

	avlist[++i] = (char *) NULL;	/* NULL-terminate strings */
	avlist[++i] = (char *) NULL;	/* NULL-terminate avlist */

	xv_set(Bc_find_popup->find_popup_ref_type, ATTR_LIST, avlist, NULL);
	xv_set(Bc_find_popup->find_popup_ref_type, PANEL_VALUE, default_find_ref_type, NULL);

	/* remove "All types" for base window */
	avlist[i - 2] = (char *) NULL;

	xv_set(Bc_base_window->base_window_ref_type, ATTR_LIST, avlist, NULL);
	xv_set(Bc_base_window->base_window_ref_type, PANEL_VALUE, default_ref_type, NULL);

	xv_set(Bc_properties_popup->properties_popup_ref_type, ATTR_LIST, avlist, NULL);

	free((char *) avlist);

}




/* scan for duplicate cite keys */

extern int
duplicate_cite_key(key)
	char           *key;
{
	Ref             ref;

	ref = first_item;
	while (ref != NULL) {
		if (ref->field[citekey_id])
			if (strcasecmp(key, ref->field[citekey_id]) == NULL)
				return (TRUE);
		ref = ref->next;
	}
	return (FALSE);
}




/* reads the path from the environment or from the working directory */

extern void
get_path(pathname)
	char            pathname[];
{
	char           *envpathname;
	char           *char_pointer;

	if (envpathname = getenv(BIBPATHVAR)) {

		if ((*envpathname == '.') && (*(envpathname + 1) == ':'))
			getwd(envpathname);
		if ((*envpathname == '~') && (*(envpathname + 1) == ':'))
			envpathname = getenv(HOMEVAR);

		char_pointer = strchr(envpathname, ':');
		if (char_pointer != NULL) {
			sprintf(char_pointer, "");
		}
		if (envpathname == NULL)
			sprintf(envpathname, "/");

		strncpy(pathname, envpathname, MAXPATHLEN - 1);
		pathname[MAXPATHLEN - 1] = '\0';


	} else
		getwd(pathname);
}




extern void
expand(event)
	Event          *event;
{
	int             x, y, width, i;
	char            title[BUFSIZ];

	if (event_is_down(event) && event_action(event) == ACTION_SELECT)
		for (i = 0; i < last_field; i++) {
			width = (int) xv_get(nxt_fld[i], PANEL_LABEL_WIDTH);
			x = (int) xv_get(nxt_fld[i], PANEL_LABEL_X);
			y = (int) xv_get(nxt_fld[i], PANEL_LABEL_Y);
			if (event_x(event) > x && event_x(event) < x + width &&
			    event_y(event) > y && event_y(event) < y + EXPAND_RANGE_Y) {
#if defined STRIP_ALL_SPACES
				char            value[BUFSIZ];
				strcpy(value, (char *) strip_space((char *) xv_get(nxt_fld[i], PANEL_VALUE)));
				xv_set(nxt_fld[i], PANEL_VALUE, value, NULL);
#endif
				sprintf(title, "Expanded field: %s", (char *) xv_get(nxt_fld[i], PANEL_LABEL_STRING));
				xv_set(Bc_expand_popup->expand_popup, FRAME_LABEL, title, NULL);
				xv_set(Bc_expand_popup->expand_popup, FRAME_CMD_PUSHPIN_IN, EXPAND_POPUP_PUSHPIN, XV_SHOW, TRUE, NULL);
				textsw_delete(Bc_expand_popup->expand_popup_textplane, NULL, TEXTSW_INFINITY);
				textsw_reset(Bc_expand_popup->expand_popup_textplane, NULL, NULL);
				textsw_insert(Bc_expand_popup->expand_popup_textplane,
				   (char *) xv_get(nxt_fld[i], PANEL_VALUE),
					      strlen((char *) xv_get(nxt_fld[i], PANEL_VALUE)));
				xv_set(Bc_expand_popup->expand_popup_textplane, TEXTSW_FIRST, NULL, NULL);
				expand_item = nxt_fld[i];
			}
		}
}



extern void
enter_expanded_text()
{
	char            value[BUFSIZ];
	int             n;
	char            errormsg[BUFSIZ];

	n = (int) xv_get(Bc_expand_popup->expand_popup_textplane, TEXTSW_CONTENTS, NULL,
			 value, BUFSIZ - 1);

	if (n >= BUFSIZ - 1) {
		value[BUFSIZ - 2] = '\0';
		sprintf(errormsg, "Warning: Maximum Field Size (%d)!", (int) BUFSIZ);
		notice_prompt(Bc_base_window->base_window_controls, NULL,
			      NOTICE_FOCUS_XY, 318, 7,
			      NOTICE_MESSAGE_STRINGS,
			      errormsg,
			      "Text being truncated", NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      NULL);
	}
	xv_set(expand_item, PANEL_VALUE, strip_space((char *) value), NULL);


}




extern int
update_item()
{
	int             i, n, nextn;
	char            value[BUFSIZ];


#if defined SHOW_TOTAL_SELECTED_IN_FOOTER
	if (update_flag == UPDATE_ON)
		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);
#endif

	for (i = 1; i < num_of_fields; i++) {

		strcpy(value, (char *) strip_space((char *) xv_get(field_ptr[i], PANEL_VALUE)));
		xv_set(field_ptr[i], PANEL_VALUE, value, NULL);

		if ((current_item->field[i] == NULL) && (strlen(value) > 0)) {
			SET_STR(current_item->field[i], value);
			mod_flag = TRUE;

		} else if (current_item->field[i]) {
			if (strcmp(current_item->field[i], value) != NULL) {
				SET_STR(current_item->field[i], value);
				mod_flag = TRUE;
			}
		}
	}


	/* Do annote update based on edit count; */
	if (annote_edit_count < (int) xv_get(Bc_annotation_popup->annotation_popup_textplane, TEXTSW_EDIT_COUNT)) {

		annote_edit_count = (int) xv_get(Bc_annotation_popup->annotation_popup_textplane, TEXTSW_EDIT_COUNT);
		mod_flag = TRUE;
		nextn = 0;
		n = (int) xv_get(Bc_annotation_popup->annotation_popup_textplane, TEXTSW_CONTENTS, 0,
				 value, BUFSIZ - 1);
		if (n > 0) {
			if (n == (BUFSIZ - 1))
				value[BUFSIZ - 1] = '\0';
			SET_STR(current_item->annote, value);

			while (((n - nextn) > 0) || (n == (BUFSIZ - 1))) {
				nextn = n;
				n = (int) xv_get(Bc_annotation_popup->annotation_popup_textplane, TEXTSW_CONTENTS, nextn,
						 value, BUFSIZ - 1);
				if ((n - nextn) == (BUFSIZ - 1))
					value[BUFSIZ - 1] = '\0';
				ADD_TO(current_item->annote, value);
			}
		}
	}
	/* Do non-standard field update based on edit count */
	if (ns_edit_count < (int) xv_get(Bc_ns_popup->ns_popup_textplane, TEXTSW_EDIT_COUNT)) {

		ns_edit_count = (int) xv_get(Bc_ns_popup->ns_popup_textplane, TEXTSW_EDIT_COUNT);
		mod_flag = TRUE;
		nextn = 0;
		n = (int) xv_get(Bc_ns_popup->ns_popup_textplane, TEXTSW_CONTENTS, 0,
				 value, BUFSIZ - 1);
		if (n > 0) {
			if (n == (BUFSIZ - 1))
				value[BUFSIZ - 1] = '\0';
			SET_STR(current_item->nsfield, value);

			while (((n - nextn) > 0) || (n == (BUFSIZ - 1))) {
				nextn = n;
				n = (int) xv_get(Bc_ns_popup->ns_popup_textplane, TEXTSW_CONTENTS, nextn,
						 value, BUFSIZ - 1);
				ADD_TO(current_item->nsfield, value);
			}
		}
	}
	/* set ref type */
	n = (int) xv_get(Bc_base_window->base_window_ref_type, PANEL_VALUE);

	if (strcmp(current_item->ref_type, ref_types_show_fct[n].ref_type_token) != NULL) {
		strcpy(current_item->ref_type, ref_types_show_fct[n].ref_type_token);
		mod_flag = TRUE;
	}
	/* set not empty cite key */
	strcpy(value, (char *) xv_get(Bc_base_window->base_window_citekey, PANEL_VALUE));
	if (strlen(value) < 1) {
		notice_prompt(Bc_base_window->base_window_controls, NULL,
			      NOTICE_FOCUS_XY, 318, 7,
			      NOTICE_MESSAGE_STRINGS,
			      "Empty Cite Key", NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      NULL);
#if defined SHOW_TOTAL_SELECTED_IN_FOOTER
		if (update_flag == UPDATE_ON)
			xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
#endif

		return (ERROR);
	}
	/* test for duplicate cite key */
	if (!(current_item->field[citekey_id]) ? TRUE : strcmp(current_item->field[citekey_id], value) != NULL) {
		mod_flag = TRUE;
		mod_for_find_flag = TRUE;

		if (!(current_item->field[citekey_id]) ? TRUE : strcasecmp(current_item->field[citekey_id], value) != NULL) {
			/* don't check if it is a case change */

			if (duplicate_cite_key(value)) {
				notice_prompt(Bc_base_window->base_window_controls, NULL,
					      NOTICE_FOCUS_XY, 318, 7,
					      NOTICE_MESSAGE_STRINGS,
					      "Duplicate Cite Key", NULL,
					      NOTICE_BUTTON_YES, "Continue",
					      NULL);
#if defined SHOW_TOTAL_SELECTED_IN_FOOTER
				if (update_flag == UPDATE_ON)
					xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
#endif

				return (ERROR);
			}
		}
		SET_STR(current_item->field[citekey_id], value);

		if (update_flag == UPDATE_ON)
			update_cite_list();
	}
	/* check strings for modifications */
	if (edit_count < (int) xv_get(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_EDIT_COUNT)) {

		edit_count = (int) xv_get(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_EDIT_COUNT);
		mod_flag = TRUE;
	}
	do_title();

#if defined SHOW_TOTAL_SELECTED_IN_FOOTER
	if (update_flag == UPDATE_ON)
		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
#endif
	return (OK);
}



extern void
next_field(item, offset)
	Panel_item      item;
	int             offset;
{
	int             i;

	/* cursor down */
	if (offset > 0) {
		if (item == nxt_fld[last_field]) {
			xv_set(Bc_base_window->base_window_controls,
			       PANEL_CARET_ITEM, nxt_fld[0], NULL);
			return;
		}
	}
	/* cursor up */
	if (offset < 0) {
		if (item == nxt_fld[0]) {
			xv_set(Bc_base_window->base_window_controls,
			       PANEL_CARET_ITEM, nxt_fld[last_field], NULL);
			return;
		}
	}
	for (i = 0; i <= last_field; i++)
		if (item == nxt_fld[i]) {
			xv_set(Bc_base_window->base_window_controls,
			       PANEL_CARET_ITEM, nxt_fld[i + offset], NULL);
			break;
		}
}



extern void
init_bc(argc, argv)
	int             argc;
	char          **argv;
{
	int             i;
	char            tmp_label[BUFSIZ];
	char           *tmp_nam;

	init_field_ptr();
	hide_all();
#ifdef LOCATION_FIELD
	set_location_menu();
#endif
	get_path(pathname);
	set_settings();

	if ((tmp_nam = tempnam(TEMP_DIR, CLIPFILE_TEMP_PFX)) == NULL) {
		fprintf(PRINT_TO, "bibcard: ERROR in tmpnam. \n");
		exit(ERROR);
	}
	clipfile_name = strcat(tmp_nam, BIB_EXTENSION);

	max_total_for_list = DEFAULT_MAX_TOTAL_FOR_LIST;
	xv_set(Bc_properties_popup->properties_popup_max_total_for_list, PANEL_VALUE, DEFAULT_MAX_TOTAL_FOR_LIST, NULL);

	default_find_ref_type = DEFAULT_FIND_REF_TYPE;

	default_find_field1 = num_of_fields + 2;
	default_find_field2 = num_of_fields + 2;
	default_find_field3 = num_of_fields + 2;
	default_find_field4 = num_of_fields + 1;
	default_find_field5 = num_of_fields + 2;

	for (i = 0; i < num_of_fields; i++) {
		if (strcasecmp(text_fields[i][0], DEFAULT_FIND_FIELD1) == NULL) {
			default_find_field1 = i;
		}
		if (strcasecmp(text_fields[i][0], DEFAULT_FIND_FIELD2) == NULL) {
			default_find_field2 = i;
		}
		if (strcasecmp(text_fields[i][0], DEFAULT_FIND_FIELD3) == NULL) {
			default_find_field3 = i;
		}
		if (strcasecmp(text_fields[i][0], DEFAULT_FIND_FIELD4) == NULL) {
			default_find_field4 = i;
		}
		if (strcasecmp(text_fields[i][0], DEFAULT_FIND_FIELD5) == NULL) {
			default_find_field5 = i;
		}
	}

	xv_set(Bc_properties_popup->properties_popup_find_field1, PANEL_VALUE, default_find_field1, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field2, PANEL_VALUE, default_find_field2, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field3, PANEL_VALUE, default_find_field3, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field4, PANEL_VALUE, default_find_field4, NULL);
	xv_set(Bc_properties_popup->properties_popup_find_field5, PANEL_VALUE, default_find_field5, NULL);


	default_find_connect = DEFAULT_FIND_CONNECT;
	xv_set(Bc_properties_popup->properties_popup_connect, PANEL_VALUE, default_find_connect, NULL);
	default_find_findmethod = DEFAULT_FIND_FINDMETHOD;
	xv_set(Bc_properties_popup->properties_popup_findmethod, PANEL_VALUE, default_find_findmethod, NULL);
	default_find_ignore_case = DEFAULT_FIND_IGNORE_CASE;
	xv_set(Bc_properties_popup->properties_popup_ignore_case, PANEL_VALUE, default_find_ignore_case, NULL);
	default_find_fuzzy_distance = DEFAULT_FIND_FUZZY_DISTANCE;
	default_find_select_in_list = DEFAULT_FIND_SELECT_IN_LIST;
	xv_set(Bc_properties_popup->properties_popup_select_in_list, PANEL_VALUE, default_find_select_in_list, NULL);

	update_flag = DEFAULT_UPDATE;
	xv_set(Bc_list_popup->list_popup_updating, PANEL_VALUE, DEFAULT_UPDATE, NULL);

	/* Cursor movement */
	nxt_fld[0] = Bc_base_window->base_window_citekey;
	nxt_fld[1] = Bc_base_window->base_window_key;

	if (argc > 1) {
		if ((char) argv[1][0] != '/')	/* test for explicit path
						 * added by Paul King */
			sprintf(filename, "%s/%s", pathname, argv[1]);
		else
			sprintf(filename, "%s", argv[1]);
		if (loadFile(filename) == ERROR)
			new_bib();
	} else
		new_bib();

	mod_for_find_flag = TRUE;


	xv_set(Bc_clip_buffer_popup->clip_buffer_popup_textplane,
	       TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
	       NULL);
	xv_set(Bc_annotation_popup->annotation_popup_textplane,
	       TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
	       NULL);
	xv_set(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
	       NULL);
	xv_set(Bc_ns_popup->ns_popup_textplane,
	       TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
	       NULL);
	xv_set(Bc_expand_popup->expand_popup_textplane,
	       TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
	       NULL);
	xv_set(Bc_properties_popup->properties_popup_textplane,
	       TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
	       NULL);

	xv_set(Bc_sort_popup->sort_popup_gauge, PANEL_PAINT, PANEL_NO_CLEAR, NULL);
	xv_set(Bc_find_popup->find_popup_gauge, PANEL_PAINT, PANEL_NO_CLEAR, NULL);

	for (i = 0; i < num_of_fields; i++)
		xv_set(field_ptr[i], PANEL_NOTIFY_LEVEL, PANEL_NON_PRINTABLE, NULL);


	sprintf(tmp_label, "%s V%s: %s", BIBCARD_NAME, VERSION_NO, "Load Merge");
	Gfm_Merge = gfm_initialize(NULL, Bc_base_window->base_window, tmp_label);

	sprintf(tmp_label, "%s V%s: %s", BIBCARD_NAME, VERSION_NO, "Load Replace");
	Gfm_Replace = gfm_initialize(NULL, Bc_base_window->base_window, tmp_label);

	sprintf(tmp_label, "%s V%s: %s", BIBCARD_NAME, VERSION_NO, "Save as");
	Gfm_Save_as = gfm_initialize(NULL, Bc_base_window->base_window, tmp_label);

	sprintf(tmp_label, "%s V%s: %s", BIBCARD_NAME, VERSION_NO, "Save Selection (with abbrev) as");
	Gfm_Save_Selection_with_abbrev = gfm_initialize(NULL, Bc_base_window->base_window, tmp_label);

	sprintf(tmp_label, "%s V%s: %s", BIBCARD_NAME, VERSION_NO, "Save Selection (no abbrev) as");
	Gfm_Save_Selection_no_abbrev = gfm_initialize(NULL, Bc_base_window->base_window, tmp_label);

	xv_set(Bc_properties_popup->properties_popup_offset_xv_y, PANEL_VALUE, DEFAULT_OFFSET_XV_Y, NULL);
	xv_set(Bc_properties_popup->properties_popup_file_offset_token, PANEL_VALUE, FILE_OFFSET_TOKEN, NULL);
	xv_set(Bc_properties_popup->properties_popup_file_offset_field, PANEL_VALUE, FILE_OFFSET_FIELD, NULL);

	sprintf(gfm_filter, "%s", (char *) xv_get(Bc_properties_popup->properties_popup_gfm_filter, PANEL_CHOICE_STRING, NULL));
	set_header();

	sprintf(tmp_label, "%s V%s Properties", BIBCARD_NAME, VERSION_NO);
	xv_set(Bc_properties_popup->properties_popup, FRAME_LABEL, tmp_label, NULL);

}



extern void
do_title()
{
	char            mod[12], title[BUFSIZ], name[BUFSIZ], pathname_loc[BUFSIZ];
	char           *tmp;
	Icon            base_window_frame_icon;

#if defined SHOW_TOTAL_IN_FOOTER || SHOW_SELECTED_IN_FOOTER
	char            message[BUFSIZ];
	int             i, total_selected;

	get_total();
	sprintf(message, "Total: %d", total);
	xv_set(Bc_base_window->base_window, FRAME_LEFT_FOOTER, message, NULL);

#if defined SHOW_TOTAL_SELECTED_IN_FOOTER
	if (update_flag == UPDATE_OFF) {
		xv_set(Bc_base_window->base_window, FRAME_RIGHT_FOOTER, "", NULL);
	} else {
		total_selected = 0;

		if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == TRUE) {

			for (i = 0; i < total; i++) {
				if ((int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_SELECTED, i)) {
					total_selected++;
				}
			}
			sprintf(message, "Selected (in List): %d", total_selected);

		} else if ((xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == FALSE) && (mod_for_find_flag == FALSE)) {

			for (i = 0; i < total; i++) {
				if (found_flag[i])
					total_selected++;
			}

			sprintf(message, "Selected (in Find): %d", total_selected);
		} else {
			sprintf(message, "No Selections available");
		}



		xv_set(Bc_base_window->base_window, FRAME_RIGHT_FOOTER, message, NULL);
	}
#endif
#endif

	if (mod_flag) {
		strcpy(mod, " (changed)");
		xv_set(Bc_base_window->base_window, FRAME_NO_CONFIRM, FALSE, NULL);
	} else {
		strcpy(mod, "");
		xv_set(Bc_base_window->base_window, FRAME_NO_CONFIRM, TRUE, NULL);
	}

	if (mod_flag)
		sprintf(name, ">%s", strrchr(filename, '/') + 1);
	else
		sprintf(name, "%s", strrchr(filename, '/') + 1);

	base_window_frame_icon = (Icon) xv_get(Bc_base_window->base_window, FRAME_ICON);
	xv_set(base_window_frame_icon,
	       ICON_LABEL, name,
	       NULL);

	sprintf(name, "%s", strrchr(filename, '/') + 1);

	strcpy(pathname_loc, filename);

	tmp = (char *) strrchr(pathname_loc, '/');
	if (tmp == NULL)
		getwd(pathname_loc);

	sprintf(title, "%s V%s - %s%s, dir; %s", BIBCARD_NAME, VERSION_NO, name, mod, pathname_loc);
	xv_set(Bc_base_window->base_window, FRAME_LABEL, title, NULL);
}




extern          SLIST
make_select_list()
{
	int             i;
	int             nItems = (int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_NROWS);
	SLIST           select_list, prev, new;

	select_list = 0;
	for (i = 0; i < nItems; i++) {
		if ((int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_SELECTED, i)) {

			if ((new = (SLIST) malloc(sizeof(SL))) == NULL) {
				fprintf(PRINT_TO, "bibcard: out of memory\n");
				exit(ERROR);
			}
			new->selection = (char *) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_STRING, i);
			new->next = NULL;

			if (select_list == NULL) {
				select_list = new;
				prev = new;

			} else {
				prev->next = new;
				prev = new;
			}
		}
	}

	return select_list;
}



extern void
set_header()
{
	int             offset_xv_y = (int) xv_get(Bc_properties_popup->properties_popup_offset_xv_y, PANEL_VALUE, NULL);

	if (num_of_fields == STD_NUM_OF_FIELDS) {
		/* no user fields message */
		xv_set(Bc_base_window->base_window, XV_HEIGHT, (MAX_STD_LINES * offset_xv_y + LINE_1_XV_Y), NULL);
	} else {
		xv_set(Bc_base_window->base_window, XV_HEIGHT, (MAX_STD_LINES * offset_xv_y + LINE_1_XV_Y + offset_xv_y * (num_of_fields - STD_NUM_OF_FIELDS + 1)), NULL);
	}
	xv_set(field_ptr[citekey_id], XV_X, CITEKEY_XV_X, XV_Y, LINE_1_XV_Y, XV_SHOW, TRUE, NULL);
	xv_set(field_ptr[key_id], XV_X, KEY_XV_X, XV_Y, LINE_1_XV_Y + 1 * offset_xv_y, XV_SHOW, TRUE, NULL);
	xv_set(Bc_base_window->base_window_ref_type, XV_X, REF_TYPE_XV_X, XV_Y, LINE_1_XV_Y + 1 * offset_xv_y, XV_SHOW, TRUE, NULL);
	xv_set(Bc_base_window->base_window_message_required, XV_X, MESSAGE_REQUIRED_XV_X, XV_Y, LINE_1_XV_Y + 2 * offset_xv_y, XV_SHOW, TRUE, NULL);

}
