#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "dvi.h"

static int term_chars = 0;
static const int term_len = 72;

void vprint(char *format, va_list l)
{
    char string[256];

    vsprintf(string,format,l);
    if (term_chars>0)
    {
	if (log_file!=NULL) putc('\n',log_file);
	out_newline();
	term_chars = 0;
    }
    if (log_file!=NULL)
    {
	fputs(string,log_file);
	putc('\n',log_file);
    }
    out_string(string);
    out_newline();
}

void print(char *format, ...)
{
    va_list l;

    va_start(l,format);
    vprint(format,l);
    va_end(l);
}

void printnnl(char *format, ...)
{
    char string[256];
    va_list l;

    va_start(l,format);
    vsprintf(string,format,l);
    if (term_chars>0)
    {
	if (log_file!=NULL) putc('\n',log_file);
	out_newline();
	term_chars = 0;
    }
    if (log_file!=NULL) fputs(string,log_file);
    out_string(string);
    term_chars = (int)strlen(string);
    va_end(l);
}

void xprint(int extra, char *format, ...)
{
    char string[256], *s;
    va_list l;
    int len;

    va_start(l,format);

    if (extra>=0)
    {
	string[0] = ' ';
	vsprintf(string+1,format,l);
    }
    else vsprintf(string,format,l);

    len = (int)strlen(string);

    if (term_chars>0 && term_chars+extra+len>=term_len)
    {
	if (log_file) putc('\n',log_file);
	out_newline();
	term_chars = 0;
    }

    s = extra<0 ? string : term_chars ? string:string+1;

    if (log_file!=NULL) fputs(s,log_file);
    out_string(s);
    term_chars += (int)strlen(s);
}

void term_clean(void)
{
    term_chars = 0;
}

