/* This file is part of dvi2bitmap; see README for copyrights and licence */

#ifndef DVIFILEPOSITION_HEADER_READ
#define DVIFILEPOSITION_HEADER_READ 1

#include "DviFile.h"
#include "verbosity.h"

/**
 * Represents a location within the DviFile.  Coordinates
 * <code>x</code> and <code>y</code> are relative to the top-left
 * corner of the `page', with the pixel in the top-left corner
 * having coordinates (0,0).  Note that this is different from DVI
 * coordinates, which have their origin at a point one inch in and one
 * inch down from the top-left of the `paper'.
 *
 */
class DviFilePosition {
 private:
    int x, y;                   /* position in scaled points */
    DviFile* dvif;
    static enum verbosities verbosity_;
 public:
    DviFilePosition(DviFile*, double x, double y, DviFile::DviUnits);
    DviFilePosition(DviFilePosition*, double x, double y, DviFile::DviUnits);
    double getX(const DviFile::DviUnits u);
    double getY(const DviFile::DviUnits u);
    void shift(double dx, double dy, DviFile::DviUnits u);
    void scale(double factor);
    //void scale(double factor, DviFilePosition& fixed_point);
    // make a static copy
    DviFilePosition* copy();
    static verbosities verbosity(const verbosities level) {
        enum verbosities oldv = verbosity_;
        verbosity_ = level;
        return oldv;
    }
};

#endif /* DVIFILEPOSITION_HEADER_READ */
