#ifndef __UTILS_H
#  define __UTILS_H
/*
*  utils.h:  String and other utility functions header file.
*
*
*  Copyright (c) 2000 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



/*
*  $Id: utils.h 0.03 2000/06/06 00:00:03 tom Exp $"
*/



/*
*  GLOBAL functions prototypes.
*/
__BEGIN_DECLARATIONS
/*
************************************************** Defined in `utils.c'.
*/
#if !HAVE_STRDUP
EXPORT char *
my_strdup __P_((const char *string));
#endif
#if !HAVE_STRSTR
EXPORT char *
my_strstr __P_((const char *text,
                const char *pattern));

#endif
EXPORT char *
my_strrev __P_((const char *string));
EXPORT int
asc_sort __P_((const char **a,
               const char **b));
EXPORT VOID_PTR
my_malloc __P_((const int   amount,
                const int   exit_status,
                const char *module_name,
                const long  module_line));
EXPORT VOID_PTR
my_realloc __P_((      VOID_PTR  ptr_memblock,
                 const int       amount,
                 const int       exit_status,
                 const char     *module_name,
                 const long      module_line));
EXPORT int
my_error __P_((      FILE *stream,
               const int   error,
               const char *module_name,
               const long  module_line));
__END_DECLARATIONS
#endif /* __UTILS_H */
