/*  <- declarations */
/*
 * These routines will decode MSP files produced by Microsoft Paint. The
 * initial version of the MSP reading code was written by Maurice Castro
 * and Russell Lang.
 *
 * Adapted by Hippocrates Sendoukas, Los Angeles, September 1993
 */
#define	FILTNAME	"msp"
#include "common1.c"

struct wpnt_1
{
  Uns8	id[4];
  Uns16	width;
  Uns16	height;
  Uns16	x_asp;
  Uns16	y_asp;
  Uns16	x_asp_prn;
  Uns16	y_asp_prn;
  Uns16	width_prn;
  Uns16	high_prn;
  Uns32	chk_sum;
  Uns16	chk_head;
};
#define	WPAINT_1	1
#define	WPAINT_2	2
#define	MSPBITOFFSET	32

/*  -> declarations */
/*  <- msp_read_line               ok */

/*
 * an undocumented format - based on a type of run length encoding
 * the format is made up of a list of line lengths, followed by a set
 * of lines. Each line is made up of 2 types of entries:
 * 	1) A 3 term entry (0 a b): the byte b is repeated a times
 *	2) A variable length entry (a xxxx....xxxx): a bytes are read
 *	   from the file.
 * These entries are combined to build up a line
 */
static int PASCAL NEAR
msp_read_line(FILE *f,Uns8 *buf,unsigned bufsz,unsigned linelen)
{
  int c;

  while (linelen)
    {
      c = getc(f);
      if (c == 0)
        {
          c = getc(f);
          if ((unsigned)c>bufsz)  return 0;
          memset(buf,getc(f),c);
          linelen -= 3;
        }
      else
        {
          if ((unsigned)c>bufsz) return 0;
          fread(buf,1,c,f);
          linelen -= c+1;
        }
      buf	+= c;
      bufsz	-= c;
    }
  if (bufsz) memset(buf,0xff,bufsz);
  return !feof(f);
}

/*  -> msp_read_line               ok */
/*  <- get_chunk                   ok */

static int PASCAL NEAR
get_chunk(FILE *f,Uns8 *dibbits,unsigned wpl,
          unsigned nx,unsigned ny,unsigned *linelen,int fmt)
{
  unsigned bpl,y;

  bpl = (nx+7) / 8;
  dibbits += 2*wpl*(ny-1);

  if (fmt==WPAINT_1)
    /*
     * A partly documented format - see The PC Sourcebook
     * the format is made up of a simple bitmap
     */
    for (y=0; y<ny; y++)
      {
        if ((unsigned)fread(dibbits,1,bpl,f)!=bpl)  return IE_BAD_FILE_DATA;
        dibbits -= 2*wpl;
      }
  else
    for (y=0;  y<ny;  y++)
      {
        if (!msp_read_line(f,dibbits,bpl,linelen[y]))  return IE_BAD_FILE_DATA;
        dibbits -= 2*wpl;
      }
  return IE_OK;
}

/*  -> get_chunk                   ok */
/*  <- msp_read_lengths            ok */

static int PASCAL NEAR
msp_read_lengths(FILE *f,unsigned ny,unsigned *linelen)
{
  unsigned i;

  for (i=0; i<ny; i++)  linelen[i] = readUns16(f);
  return !feof(f);
}

/*  -> msp_read_lengths            ok */
/*  <- make_meta */

static int PASCAL NEAR
make_meta(FILE *f,unsigned nx,unsigned ny,
          BITMAPINFO *bi,HANDLE *hmf,int fmt,DWORD mode)
{
  HDC		hdc;
  unsigned	wpl,y1,y2,dy,maxdy,retcode;
  unsigned long temp;
  unsigned	*linelen;
  Uns8		*dibbits;

#if ___16_BIT___
  if (fmt==WPAINT_2 && ny>=32768u) return IE_TOO_BIG;
#endif

  temp = nx;
  temp += 31;
  temp /= 32;
  temp *= 2;
  wpl = (unsigned) temp;
  maxdy = 16384u/wpl;                           /* 32K chunks */
  if (maxdy==0) return IE_TOO_BIG;
  if (maxdy>1) maxdy--;
  if (maxdy>ny) maxdy = ny;

  if ( (dibbits=malloc(2*wpl*maxdy)) == NULL ) return IE_MEM_FULL;

  /*
   * make sure that you start at the right point in the file
   */
  fseek(f,MSPBITOFFSET,SEEK_SET);

  linelen = NULL;
  if (fmt==WPAINT_2)
    if ( (linelen=malloc(ny*sizeof(unsigned))) == NULL )
      {
        free(dibbits);
        return IE_MEM_FULL;
      }
    else if (!msp_read_lengths(f,ny,linelen))
      {
        free(dibbits);
        return IE_BAD_FILE_DATA;
      }

  if ( (hdc=CreateMetaFile(NULL)) == 0 )
    {
      if (linelen) free(linelen);
      free(dibbits);
      return IE_MEM_FULL;
    }
  SetWindowOrgEx(hdc,0,0,NULL);
  SetWindowExtEx(hdc,nx,ny,NULL);
  for (y1=0,y2=ny;  y1<y2;  )
    {
      dy = min(y2-y1,maxdy);
      bi->bmiHeader.biHeight = dy;
      bi->bmiHeader.biSizeImage = 2*wpl*dy;
      retcode = get_chunk(f,dibbits,wpl,nx,dy,linelen+y1,fmt);
      if (retcode!=IE_OK) break;
      if (!StretchDIBits(hdc,0,y1,nx,dy,0,0,nx,dy,(LPSTR)dibbits,bi,
                         DIB_RGB_COLORS,mode))
        {
          retcode = IE_MEM_FULL;
          break;
        }
      y1 += dy;
    }
  if (linelen) free(linelen);
  free(dibbits);
  *hmf = CloseMetaFile(hdc);
  if (*hmf && retcode!=IE_OK)
    {
      DeleteMetaFile(*hmf);
      *hmf = 0;
    }
  return retcode;
}

/*  -> make_meta */
/*  <- msp_read_header */

static int PASCAL NEAR
msp_read_header(FILE *f,struct wpnt_1 *h)
{
  int i;

  /*
   * read the header of the file and figure out what it is
   */
  for (i=0; i<4; i++) h->id[i] = (Uns8) getc(f);
  h->width	= readUns16(f);
  h->height	= readUns16(f);
  /*
   * skip the next fields: we don't use them
   *
   * h->x_asp		= readUns16(f);
   * h->y_asp		= readUns16(f);
   * h->x_asp_prn	= readUns16(f);
   * h->y_asp_prn	= readUns16(f);
   * h->width_prn	= readUns16(f);
   * h->high_prn	= readUns16(f);
   * h->chk_sum		= readUns32(f);
   * h->chk_head	= readUns16(f);
   */

  if (feof(f) || h->width==0 || h->height==0) return 0;
  /*
   * check the id bytes
   */
  return (!memcmp(h->id,"DanM",4))  ?  WPAINT_1 :
         (!memcmp(h->id,"LinS",4))  ?  WPAINT_2 : 0;
}

/*  -> msp_read_header */
/*  <- make_mono_palette */

static void PASCAL NEAR
make_mono_palette(RGBQUAD *p)
{
  static RGBQUAD mdef[2] =
    { { 0x00,	0x00,	0x00,	0 },
      { 0xff,	0xff,	0xff,	0 }  };

  memcpy(p,mdef,sizeof(mdef));
}

/*  -> make_mono_palette */
/*  <- msp_graph */

static int PASCAL NEAR
msp_graph(char *fname,HANDLE *hmf,int *nx,int *ny,DWORD mode)
{
  int			retcode,fmt;
  FILE			*f;
  BITMAPINFO		*bi;
  BITMAPINFOHEADER	*bih;
  struct wpnt_1		hdr;

  if ( (f=fopen(fname,"r")) == NULL ) return IE_NO_FILE;
  if ( (fmt=msp_read_header(f,&hdr)) == 0 )
    {
      fclose(f);
      return IE_BAD_FILE_DATA;
    }
  if ((bi=malloc(sizeof(BITMAPINFOHEADER)+2*sizeof(RGBQUAD)))==NULL)
    {
      fclose(f);
      return IE_MEM_FULL;
    }
  make_mono_palette(&(bi->bmiColors[0]));
  bih			= &(bi->bmiHeader);
  memset(bih,0,sizeof(BITMAPINFOHEADER));
  bih->biSize		= sizeof(BITMAPINFOHEADER);
  bih->biWidth		= hdr.width;
  bih->biHeight		= hdr.height;
  bih->biPlanes		= 1;
  bih->biBitCount	= 1;
  retcode = make_meta(f,hdr.width,hdr.height,bi,hmf,fmt,mode);
  free(bi);
  fclose(f);
  *nx = hdr.width;
  *ny = hdr.height;
  return retcode;
}

/*  -> msp_graph */
#define read_graphic(fname,hmf,x,y,m)	msp_graph(fname,hmf,x,y,m)
#include "common2.c"
