/* afm_parse.h */

char * AFM_key_words [] =
{
	"FontName",
	"ItalicAngle",
	"IsFixedPitch",
	"XHeight",
	"C",
	"KPX",
	"CC",
	"EncodingScheme",
	NULL
};

#define FontName (0)
#define ItalicAngle (1)
#define IsFixedPitch (2)
#define XHeight (3)
#define C (4)
#define KPX (5)
#define CC (6)
#define EncodingScheme (7)
#define not_an_AFM_keyword (-1)

char * config_key_words [] =
{
	"C",
	"D",
	"H",
	"O",
	"I",
	"Encoding",
	NULL
};

#define config_C (0)
#define config_D (1)
#define config_H (2)
#define config_O (3)
#define config_I (4)
#define config_Encoding (5)
#define not_a_config_keyword (-1)

char * vcf_key_words [] =
{
	"Encoding",
	"Boundary_char",
	"Left_boundary_ligatures",
	"Ligatures",
	NULL
};

#define vcf_Encoding (0)
#define vcf_Boundary_char (1)
#define vcf_Left_boundary_ligatures (2)
#define vcf_Ligatures (3)
#define not_a_vcf_keyword (-1)

int Boundary_char;

char * lig_strings [] =
{
	"",
	"=:",
	"|=:",
	"|=:>",
	"=:|",
	"=:|>",
	"|=:|",
	"|=:|>",
	"|=:|>>",
	NULL
};

#define NO_LIG_TYPE_SPECIFIED 0
#define REPLACE 1	
#define REPL_KEEP_LEFT 2
#define REPL_KEEP_LEFT_ADVANCE_FOCUS 3
#define REPL_KEEP_RIGHT 4
#define REPL_KEEP_RIGHT_ADVANCE_FOCUS 5
#define REPL_KEEP_LFT_KEEP_RGT 6
#define REPL_KEEP_LFT_KEEP_RGT_ADVANCE_FOCUS 7
#define REPL_KEEP_LFT_KEEP_RGT_ADV_FOCUS_ADV_FOCUS 8

bool has_ligs [MAX_CHARACTERS], first_ligtable_entry;

int AFM_command __P((char * s));
void append_liginfo __P((lig_tp * ail, lig_tp * cil));
void assign_chars __P((void));
int config_command __P((char * s));
void delete_TeX_configuration __P((void));
AFM_info_tp * new_char __P((void));
ignore_info_tp * new_ignore_info __P((void));
kern_tp * new_kern __P((void));
lig_tp * new_lig __P((void));
pcc_tp * new_pcc __P((void));
configuration_info_tp * new_conf_info __P((void));
void parse_AFM __P((void));
void parse_config __P((void));
void parse_char_info __P((void));
void parse_composite_char_info __P((void));
void parse_configuration_info __P((int base));
void parse_encoding_info __P((void));
void parse_ignore_info __P((void));
void parse_kern_info __P((void));
void parse_new_config __P((void));
void parse_old_config __P((void));
void process_kerns __P((AFM_info_tp * ai));
void process_ligatures __P((AFM_info_tp * ai));
void parse_vcf_Encoding __P((void));
void parse_vcf_Boundary_char __P((void));
void parse_vcf_Left_boundary_ligatures __P((void));
void parse_vcf_Ligatures __P((void));
