/* ps2mf.c */

#define VERSION "2.0 (beta)"

#include <stdio.h>
#ifndef AIX
#   include <stdlib.h>
#endif
#ifdef THINK_C
#   include <console.h>
#endif
#include <string.h>
#include "defines.h"
#include "myopen.h"
#include "mymalloc.h"
#include "ps2mf.h"
#include "ps2mfutl.h"
#include "getopt.h"
#if (defined (MSDOS) || defined (__ATARIST__))
#   include <float.h>
#endif

AFM_info_tp * AFM_chars;
configuration_info_tp * TeX_configuration;
ignore_info_tp * ignore_list;
char font_name [255], coding_scheme[255];
float italic_angle;
bool fixed_pitch, use_conf_file;
int x_height, font_space, font_quad;
bool x_height_is_defined;
char buffer [255], obuffer [255];
char * param;


void give_usage ()
{
	fprintf (stderr, "Usage: ps2mf <basename>\n");
	fprintf (stderr, "         [-C] \"to create a MF file with curls\"\n");
 	fprintf (stderr, "         [-p <someps>[.ps]] [-a <someafm>[.afm]]\n");
	fprintf (stderr, "         [-m <somemf>[.mf]] [-v <someconf>[.vcf]]\n");
	fprintf (stderr, "         [-c <someoldconf>[.cfg]]\n");
	exit (UNSUCCESSFUL);
}

FILE * ps_file, * afm_file, * mf_file, * conf_file, * vcf_file;

#ifdef __STDC__
void preamble (int argc, char ** argv)
#else
void preamble (argc, argv)
int argc;
char ** argv;
#endif
{
	int c, i, lastext;
	bool ps_file_defined, afm_file_defined, mf_file_defined,
		conf_file_defined, vcf_file_defined;
	char * ps_file_name, * afm_file_name, * mf_file_name, * conf_file_name,
	     * vcf_file_name, * base_file_name;

	ps_file_defined = FALSE;
	afm_file_defined = FALSE;
	mf_file_defined = FALSE;
	conf_file_defined = FALSE;
	vcf_file_defined = FALSE;
	we_are_writing_curls = FALSE;
	use_conf_file = FALSE;

#ifdef THINK_C
	argc = ccommand (& argv);
#endif
	while ((c = getopt (argc, argv, "Cp:m:a:c:v:")) != EOF)
	{
		switch (c)
		{
			case 'C':
			{
				we_are_writing_curls = TRUE;
			}
			break;
			case 'p':
			{
				ps_file_name = optarg;
				ps_file_defined = TRUE;
			}
			break;
			case 'm':
			{
				mf_file_name = optarg;
				mf_file_defined = TRUE;
			}
			break;
			case 'a':
			{
				afm_file_name = optarg;
				afm_file_defined = TRUE;
			}
			break;
			case 'c':
			{
				conf_file_name = optarg;
				conf_file_defined = TRUE;
				use_conf_file = TRUE;
			}
			break;
			case 'v':
			{
				vcf_file_name = optarg;
				vcf_file_defined = TRUE;
			}
			break;
			case '?':
			{
				give_usage ();
			}
			break;
		}
	}
	if (! argv [optind]) give_usage ();
	if (conf_file_defined && vcf_file_defined)
	{
		error ("there is no use in defining both an old and a new configuration file");
		error ("will use only the new file");
		use_conf_file = FALSE;
	}
	base_file_name = (char *) my_malloc (sizeof (char)
					     * strlen (argv [optind]) + 5);
	strcpy (base_file_name, argv [optind]);
	lastext = -1;
	for (i = 0; base_file_name [i]; i ++)
	{
		if (base_file_name [i] == '.') lastext = i;
		else
		{
			if (base_file_name [i] == '/') lastext = -1;
		}
	}
	if (lastext != -1) base_file_name [lastext] = '\0';
	ps_file = my_open (ps_file_defined ? ps_file_name : base_file_name,
			   ".ps", "r");
	afm_file = my_open (afm_file_defined ? afm_file_name : base_file_name,
			   ".afm", "r");
	mf_file = my_open (mf_file_defined ? mf_file_name : base_file_name,
			   ".mf", "w");
	setbuf (mf_file, NULL);
	if (conf_file_defined)
	{
		conf_file = my_open (conf_file_name, ".cfg", "r");
	}
	else
	{
		vcf_file = my_open (vcf_file_defined ? vcf_file_name
				    : base_file_name, ".vcf", "r");
	}
}

void postamble ()
{
	fclose (ps_file);
	fclose (afm_file);
	fclose (mf_file);
	fclose (conf_file);
}

#ifdef __STDC__
void main (int argc, char ** argv)
#else
void main (argc, argv)
int argc;
char ** argv;
#endif
{
	fprintf (stderr, "This is ps2mf, version %s.\n", VERSION);
	preamble (argc, argv);
	fprintf (stderr, "  Starting to read configuration-file\n");
	parse_config ();
	fprintf (stderr, "  Starting to read fontmetric-file\n");
	parse_AFM ();
	fprintf (stderr, "  Starting to read postscript-file\n");
	parse_PS ();
	postamble ();
	exit (SUCCESSFUL);
}
