---
myst:
  html_meta:
    keywords: LaTeX,installation,distribution,tester une installation,vérifier son installation,fichier d'exemple
---
# Comment tester mon installation de LaTeX ?

```{todo}
Vérifier que tout fonctionne bien avec Windows et macOS.
```

:::{warning}

Les marches à suivre pour Windows et macOS n'ont pas encore été testées. Il est
donc possible que cela ne fonctionne pas comme sur des roulettes...

:::

Vous venez d'installer une [distribution
TeX](/1_generalites/glossaire/distribution) sur votre ordinateur. Comment savoir
si tout fonctionne ?

La marche à suivre présentée ci-après consiste à
[compiler](/2_programmation/compilation/start.md) un document LaTeX. Elle ne
nécessite aucune connaissance particulière de LaTeX.

Si vous êtes déjà familier avec LaTeX, alors vous pouvez déjà essayer de
compiler un de vos documents (ou un document minimal, par exemple
[celui-ci](https://mirror.ctan.org/macros/latex/base/sample2e.tex)) avec votre
[éditeur de texte](/6_distributions/editeurs/start) préféré. Si cela échoue,
alors nous vous invitons à tester la méthode ci-après avant de demander de
l'aide car il sera plus facile d'identifier votre problème. En effet, si votre
test échoue mais que la méthode ci-après réussie, alors le problème peut venir,
par exemple, de votre document ou de la configuration de votre éditeur.

## Ouvrez un terminal

Ouvrez un [terminal](wpfr:Émulateur_de_terminal), pour y parvenir :

::::{tab-set}
:::{tab-item} Windows

1. Ouvrez le menu *Démarrer* ou le menu *Recherche*.
2. Saisissez « terminal » dans le champ de recherche.
3. Cliquez sur *Windows Terminal* pour l'ouvrir.

:::
:::{tab-item} macOS

1. Cliquez sur l'icône *Launchpad* dans le *Dock*.
2. Saisissez « terminal » dans le champ de recherche.
3. Cliquez sur *Terminal*.

:::
:::{tab-item} GNU/Linux

- Utilisez le raccourci clavier `Ctrl`+`Alt`+`T` (maintenez enfoncées les
  touches [`Ctrl`](wpfr:Contrôle_(touche)) et [`Alt`](wpfr:Alt_(touche)) puis
  tapez sur la touche `T`, ensuite c'est bon : vous pouvez tout relâcher).
- Sinon voir [cette
  page](https://doc.ubuntu-fr.org/terminal#comment_ouvrir_un_terminal) de Wiki
  ubuntu-fr.

:::
::::

### Aide pour le terminal

Le terminal permet d'exécuter des programmes dans un dossier (ou répertoire)
courant. Actuellement, ce dossier est sûrement votre dossier personnel. Le
dossier courant est généralement inscrit dans la suite de caractères à gauche de
la zone de saisie. Cette suite de caractères est similaire à :

::::{tab-set}
:::{tab-item} Windows

`C:\Users\alice>` où ce qui précède `>` est le dossier courant. Le dossier
`C:\Users\⟨votre_nom_d'utilisateur⟩` est votre dossier personnel.

:::
:::{tab-item} macOS

`mac-alice@alice ~ %` où :
- `mac-alice` est le nom de votre machine ;
- `alice` est votre nom d'utilisateur ;
- `~` est le dossier courant, c'est votre dossier personnel ; `~` est équivalent
  à `/home/⟨nom_de_l'utilisateur_courant⟩`.

:::
:::{tab-item} GNU/Linux

`pc-alice@alice:~$` où :
- `pc-alice` est le nom de votre machine ;
- `alice` est votre nom d'utilisateur ;
- `~` est le dossier courant, c'est votre dossier personnel ; `~` est équivalent
  à `/home/⟨nom_de_l'utilisateur_courant⟩`.

:::
::::

Pour connaître le dossier courant, vous pouvez aussi lancer la commande `pwd`
(les initiales de l'anglais *print working directory*) qui affiche le dossier
courant.
  
::::{hint} 

Pour lancer (ou exécuter) une commande, il faut :

1. Saisir (ou faire un copier-coller de) la commande dans la zone de saisie du
   terminal.
2. Appuyer sur la touche `Entrée` (`⏎`).

:::{tip}

Si le raccourci clavier `Ctrl`+`V` ne permet de *coller* dans le terminal, alors
essayez le raccourci `Ctrl`+`Maj`+`V` (maintenez enfoncées les touches
[`Ctrl`](wpfr:Contrôle_(touche)) et [`Maj`](wpfr:Touche_majuscule) puis tapez
sur la touche `V`, ensuite c'est bon : vous pouvez tout relâcher). De même,
`Ctrl`+`C`, pour *copier*, peut être remplacé par `Ctrl`+`Maj`+`C`.

:::
::::

## Composez un document de test

Lancez la commande :

```bash
pdflatex sample2e.tex
```

:::{hint}

Le document `sample2e.tex` est un fichier d'exemple faisant partie de toute
distribution TeX contenant LaTeX. Il est dans l'arborescence de votre
installation, et indexé par le logiciel chargé de localiser les fichiers
(`kpsewhere`).

En exécutant `pdflatex sample2e.tex`, vous testez :

- que l'exécutable `pdflatex` est accessible,
- que les fichiers de votre distribution sont bien indexés,
- que les fichiers des fontes, formats et extensions sont aux bons endroits,
  avec les bons droits...
  
:::

Vous devriez voir défiler quelques dizaines de lignes de texte ressemblant à
ça :

```{noedit}
This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) (preloaded format=pdflatex)
  [...]
Output written on sample2e.pdf (3 pages, 153673 bytes).
Transcript written on sample2e.log.
```

Si ce n'est pas le cas, alors c'est peut-être une des raisons ci-après.

### Accessibilité de l'exécutable `pdflatex`

Si la première ligne de texte est similaire à :

```{noedit}
This is pdfTeX, Version 3.141592653-2.6-1.40.26 (TeX Live 2024) (preloaded format=pdflatex)
```

alors l'exécutable `pdflatex` est accessible !

En revanche si vous avez :

::::{tab-set}
:::{tab-item} Windows

```{noedit}
'pdflatex' is not recognized as an internal or external command,
operable program or batch file.
```

:::
:::{tab-item} macOS ou GNU/Linux

```{noedit}
pdflatex: command not found
```

:::
::::

alors cela signifie que l'exécutable `pdflatex` est inaccessible ; il peut être
soit non installé, soit installé et non trouvé.

Dans ce cas vous pouvez [demander de l'aide](#aide-test-installation).

### Accessibilité du fichier `sample2e.tex`

Si `pdflatex` est accessible mais que la fin du texte affiché est :

```{noedit}
! I can't find file `sample2e.tex'.
<*> sample2e.tex
           
(Press Enter to retry, or Control-D to exit)
Please type another input file name: 
```

alors le fichier `sample2e.tex` n'est pas trouvé. Vous pouvez arrêter
l'interaction avec `pdflatex` en tapant `Ctrl`+`D` (maintenez la touche `Ctrl`
enfoncée puis appuyez sur la touche `D`) et [demander de
l'aide](#aide-test-installation).

### Autre erreur

Il est possible qu'une autre erreur se produise. Dans ce cas, vous pouvez
essayer de vérifier le document PDF à l'aide la rubrique suivante.

## Vérifiez le document PDF

Si le texte affiché dans le terminal après l'exécution de `pdflatex
sample2e.tex` contient une ligne similaire à :

```{noedit}
Output written on sample2e.pdf (3 pages, 153673 bytes).
```

alors vous aurez dans le dossier courant un fichier `sample2e.pdf`. Sinon vous
pouvez [demander de l'aide](#aide-test-installation).

Pour visualiser le fichier `sample2e.pdf` vous pouvez l'ouvrir depuis votre
[gestionnaire de fichiers](wpfr:Gestionnaire_de_fichiers), en vous rendant dans
le dossier courant de votre terminal au moment de l'exécution de la commande
`pdflatex sample2e.tex` ; ou depuis le terminal en lançant la commande :

::::{tab-set}
:::{tab-item} Windows

```bash
start sample2e.pdf
```

:::
:::{tab-item} macOS 

```bash
open sample2e.pdf
```

:::
:::{tab-item} GNU/Linux

```bash
xdg-open sample2e.pdf
```

:::
::::

Ce fichier PDF devrait ressembler à
[celui-ci](https://mirror.ctan.org/macros/latex/base/sample2e.pdf). Si ce n'est
pas le cas, c'est qu'il y a un problème : vous pouvez [demander de
l'aide](#aide-test-installation).

## (Optionnel) Supprimez les fichiers créés

Si le test a réussi, alors des fichiers ont été créés dans le dossier courant :
`sample2e.pdf`, `sample2e.log` et `sample2e.aux` (pour avoir plus de détails sur
eux consultez [cette page](/5_fichiers/formats/fichiers_utilises_par_latex)).
Vous pouvez les supprimer depuis votre gestionnaire de fichiers ou dans le
terminal en lançant par exemple la commande :

::::{tab-set}
:::{tab-item} Windows

```bash
del sample2e.pdf sample2e.log sample2e.aux
```

:::
:::{tab-item} macOS ou GNU/Linux

```bash
rm sample2e.pdf sample2e.log sample2e.aux
```

:::
::::

(aide-test-installation)=
## Demandez de l'aide si besoin

Avant de demander de l'aide **concernant l'installation de votre distribution
TeX**, essayez de réunir les informations suivantes :
- votre système d'exploitation, par exemple Windows, macOS ou GNU/Linux ;
- votre [distribution TeX](/1_generalites/glossaire/distribution), par exemple
  TeX Live, MacTeX ou MiKTeX, ainsi que la méthode d'installation que vous avez
  utilisée ;
- le texte affiché après l'exécution de `pdflatex sample2e.tex` ;
- le contenu du fichier `sample2e.log` s'il a été produit.

Les personnes qui vous aideront apprécieront que vous leur donniez ces
informations car elles en auront besoin pour essayer de vous trouver une
solution.

Ensuite, reportez-vous à la rubrique « Où demander de l'aide ? » de la page 
« [](/1_generalites/documentation/comment_obtenir_de_l_aide_en_ligne) ».

:::{seealso}

Si votre installation n'a pas fonctionnée, alors vous voulez peut-être
(re)consulter la rubrique « [](/6_distributions/installation/start) » ou la
question « [](/1_generalites/documentation/comment_obtenir_de_l_aide_en_ligne) ».

Sinon, si vous n'avez pas encore de logiciel pour écrire vos documents TeX,
alors la rubrique « [](/6_distributions/editeurs/start) » pourrait vous
intéresser.

:::

:::{sources}

- [Commandes Windows](https://learn.microsoft.com/fr-fr/windows-server/administration/windows-commands/windows-commands)
- [Commandes Unix](wpfr:Commandes_Unix)
- [Guide d'utilisation de Terminal (macOS)](https://support.apple.com/fr-fr/guide/terminal/) 
- [Wiki ubuntu-fr : terminal](https://doc.ubuntu-fr.org/terminal)
- [ArchWiki : `xdg-open`](https://wiki.archlinux.org/title/Xdg-utils#xdg-open)

:::
