/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserActionObject;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import java.io.File;
import java.io.IOException;

public class L2HAtStartToc
extends ControlSequence {
    public L2HAtStartToc() {
        this("@starttoc");
    }

    public L2HAtStartToc(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HAtStartToc(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        String string = this.popLabelString(teXParser, teXObjectList);
        teXObjectList.push(new HtmlTag(String.format("<!-- end of %s -->", string)));
        teXObjectList.push(new EndElement("div"));
        teXObjectList.push(l2HConverter.getControlSequence("endgroup"));
        File file = l2HConverter.getAuxFile(string);
        if (file.exists()) {
            teXObjectList.push(TeXParserActionObject.createInputAction(file));
        } else {
            teXParser.warningMessage("tex.error.file.not.found", file);
        }
        teXObjectList.push(l2HConverter.getControlSequence("@firstoftwo"));
        teXObjectList.push(new TeXCsRef("texparser@ifintoc"));
        teXObjectList.push(l2HConverter.getControlSequence("let"));
        teXObjectList.push(l2HConverter.getControlSequence("makeatletter"));
        teXObjectList.push(l2HConverter.getControlSequence("begingroup"));
        StartElement startElement = new StartElement("div");
        startElement.putAttribute("class", string);
        teXObjectList.push(startElement);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

