/*=====================================================================
 * FILE: ex_RL.h	DECLARATIONS NEEDED FOR vi.iv
 * ---------------------------------------------------------------------
 * EDIT HISTORY:
 *
 * 29/12/89		HAIM ROMAN, COMPUTER SCIENCE DEPT., TECHNION
 * (1) Added comments
 * 
 * 11/1989		HAIM ROMAN, COMPUTER SCIENCE DEPT., TECHNION
 * (1) added comments
 * 
 * ??/198?		URI HABASHA, COMPUTER SCIENCE DEPT., TECHNION
 * (probably the creator of this file)
 * =====================================================================
 */

#include "ex_tune.h"

/*=====================================================================
 * #define STATEMENTS
 *====================================================================
 */

#define		eightbit	0377

/* many of the RL ASCII codes represent characters that are also in the LR
 * codes (e.g., puctuation, upper-case Latin letters).  RL_mask is the 1st
 * RL code to represent a character NOT found in the LR alphabet).
 */
#define 	RL_mask		0340

/* These codes define direction.  DO NOT CHANGE their definitions!
 * There are places that assume that LR = 0.
 */
#define 	RL		1
#define		LR		0

/* the following are ASCII codes with special meaning to the editor
 * (see function "ascspec")
 */
#define		BQ		034
#define		SQ		035
#define		BSQ		021
#define		RQ		0201
#define		NQ		037
#define		TSL		0203

#define 	bool		short

#define		isRL		(INdirect == RL)
#define		isLR		(INdirect == LR)
#define		isRLtext	(value(RIGHTLEFT))
#define 	DEFID		(INdirect != DIdirect)
#define		isrlalpa(c) 	((isalpha( c & TRIM)) || ((c & (QUOTE | TRIM)) == 0340)) 
#define		RL_letter(c)	(((c & QUOTE) && (c != QUOTE)) ? RL :LR)
#define		isecondlang	(INdirect != Mdirect)

/* 1 = we are dealing with a shef (Standard Hebrew-English Format)
 * file.  That means that the file is in time order.  If this is 0, that
 * means the file is in visual order (e.g., vih files)
 */
#define		ishef		(value(SHEFORMAT))

#define		secletter(c)	(RL_letter(c) != Mdirect)

/*=================================================================
 * DATA DECLARATIONS
 *================================================================
 */
	/* the following XXXdirect variables can have values of LR
	 * or RL
	 */
short		INdirect;	/* insert direction */
short		DIdirect;	/* display direction: the direction
				 * the terminal is actually working in 
				 * now
				 */
short		Mdirect;	/* main (view) direction */

short		dontcare;
short		DOCdir;
int		cntchar;        /* count the number of char which added 					   in append mode . */
short		cntbak;		/* count the number of char wich backs 						   up by CTR(h) .It initilize to 0 any 						   time we enter vgetline procedure. */
int 		colRL;	 	/* display location for RL text */
int 		omark;		/* set if marksl option are differed
				   we need it for refrawing screen
				   pisicaly */
int 		hRL;
bool		prflag;		/* do the printing pysically or not */
bool		sheflag;	/* convert this time or not */
bool 		backflag;	/* move the cursor back or not in
				   rl text in terminal with not screen
				   reverse. set at vclreolRL procedure.
				*/
bool vmacpflag ;  /*
          	   * vmacpflag set if the character read from the 
		   * vmacp buff.
		   */
/* char *wrapsecp;	/*  COMMENTED OUT 11/89 BY HAIM ROMAN: NOT USED
		 * Point the last secondry string in the current line.
		 * Use when wrap-margin option set.
		 */

int wmore;	/* 
		 * Count the number of secondry character that must be
		 * moved to next line when wrap-margin occure
		 */

int mone;	 /*
	    	  * count the characters that enter in worg
		  * terminal state
		  */

		/*
		 * tobuf keep the curent line in time order(as it in
		 * the file). update any time a new line read from the
		 * file to linebuf.
		 */
char tobuf[LBSIZE];
bool		chLR;
bool convto;
bool firstR;
