/*=================================================================
 * FILE: ex_vgetline.c
 *================================================================
 * EDIT HISTORY:
 *
 * 198?		URI HABUSHA, COMPUTER SCIENCE DEPARTMENT, TECHNION
 * (1) changed this file for vi.iv.
 *
 * 11/1989	HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
 * (1) added comments
 * (2) added "extern bool isdu()" declaration
 *=================================================================
 * INCLUDE FILES & DATA DECLARATIONS
 *===============================================================
 */
#include "ex.h"
#include "ex_tty.h"
#include "ex_vis.h"
#include "ex_RL.h"


extern bool	vaifirst;
extern bool	gobbled;
extern char	*ogcursor;

bool archl = 0;
char keepchar = 0;

/*======================================================================
 * FUNCTIONS
 *=====================================================================
 * vgetline --
 *
 * Get a line into genbuf after gcursor.
 * Cnt limits the number of input characters
 * accepted and is used for handling the replace
 * single character command.  Aescaped is the location
 * where we stick a termination indicator (whether we
 * ended with an ESCAPE or a newline/return.
 *
 * We do erase-kill type processing here and also
 * are careful about the way we do this so that it is
 * repeatable.  (I.e. so that your kill doesn't happen,
 * when you repeat an insert if it was escaped with \ the
 * first time you did it.  commch is the command character
 * involved, including the prompt for readline.
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * cnt 
 * gcursor (in/out) -- points to where in "genbuf" one should insert
 *	the new line. (currently don't know the rules about how it is
 *	updated, but it is.  Maybe it points to where in "genbuf" the next
 *	line goes).
 * aescaped -- points where to stick the termination character.  I did
 *	not see any place where the pointer is changed, but obviously
 *	the location it points to is.
 * commch
 * append
 */

 /*
  * This procedure is an expantion of the original vgetline procedure.
  * In this procedure we deal with the two languages the main and the
  * secondry so it demmands a special tretment and a considerable 
  * change in vgetline procedure.
  */


char *
vgetline(cnt, gcursor, aescaped, commch, append)
	int cnt;
	register char *gcursor;
	bool *aescaped;
	char commch;
	bool append;
{
	register int c, ch;
	register char *cp;
	int x, y, iwhite, backsl=0;
	char *iglobp;
	char cstr[2];
	int (*OO)() = Outchar;

	/*
	 * Those variables were added for the expanded procedure.
	 *-------------------------------------------------------
	 * fp & ep - help pointer for shifting character in the 
	 *	    gcursor buffer.
	 * slp	   - points to the place in the buffer where the
	 *	    secondry language character should be added.
	 * duflag  - boolean varibale . set if we stay in RL-mode
	 * 	    and the character is digit or uppercase.
	 *	    I.e., true = we are in RL mode, but we put
	 *	    characters in LR order (the ":set rlnu" option).
	 * cntbak  - counts the number of columns occupied by the
	 *	    characters which were erased in the secondry 
	 *	    languge. Define in ex_RL.h because it's changed in
	 *	    ex_vput.c .
	 * cntcolin- counts the number of columns occupied by the
	 *	    text which is inserted.
	 * cntdu   - counts the number of columns occupied by the
	 *	    uppercase letters and digits in RL-mode & RLNU
	 *	    option.
	 * cntl    - counts the number of columns ocuppied by the
	 *	    text before the insert point.
	 * splitwbuff - buffer which holds the character which was
	 *	     insert before the last character in order time.
	 *	     Use only in echo area.
	 * isdu()  - function that returns true if we should set
	 *	     "duflag".  (explicit declaration added by Haim 
	 *	     Roman, 11/1989)
	 */
	register char *ep, *fp, *slp, *tp;
	register int cntcolin, helpbak, cntdu, cntl, i;
	int getch;
	bool duflag, SINdirect = INdirect;
	bool push;
	bool moveto = 1, bactab = 0;
	char keepch, splitwbuff[LBSIZE];
	char timeorder[LBSIZE], *tmop;
	extern bool isdu ();



	/*
	 * Clear the output state and counters
	 * for autoindent backwards motion (counts of ^D, etc.)
	 * Remember how much white space at beginning of line so
	 * as not to allow backspace over autoindent.
	 */
	*aescaped = 0;
	ogcursor =  slp = gcursor;
	*gcursor = 0;
	tmop = timeorder;
	*tmop = 0;
	flusho();
	CDCNT = 0;
	HADUP = 0;
	HADZERO = 0;
	gobbled = 0;
	iwhite = whitecnt(genbuf);
	iglobp = vglobp;
	cntchar = 0;
	cntdu = 0;
	helpbak = 0;
	cntcolin = 0;
	splitwbuff[0] = 0;
	if (commch != 'c')
		cntbak = 0;
	if (commch == 'p')
		INdirect = Mdirect;
	/*setshcurs();*/
	cntl = qcolumn(cursor - 1, genbuf);
	/*setshcurs();*/
	/*
	 * Carefully avoid using vinschar in the echo area.
	 */
	if (splitw)
		Outchar = vputchar;
	else {
		Outchar = vinschar;
		vprepins();
	}
	if (value(WRAPMARGIN) && isecondlang && !ishef)
		/*
		 * eliminating 'wrapsecp' is no problem because no one
		 * references it.	(Haim Roman, 17/11/89)
		 */
		/* wrapsecp = (void *) beginsec(&wmore); */
		(void) beginsec(&wmore);
	else
		wmore = 0;

	for (;;) {
		backsl = 0;
		if (gobblebl)
			gobblebl--;
		if (cnt != 0) {
			cnt--;
			if (cnt == 0)
				goto vadone;
		}
		/* 
		 * CHADIR a low level function wich cause the
		 * terminal to be in the right insert mode. RL or LR
		 * letters.
		 */
		chadir();		
		if (!keepchar && (!vglobp || !*vglobp) && (!vmacp || !*vmacp) && archl){
			archl = 0;
			getch = *svalue(CHLK);
		} else
			if (keepchar){
				getch = keepchar;
				keepchar = 0;
			} else
				getch = getkey();
		if (getch != ATTN) 
			c = getch & TRIM;
		else
			c = getch;
		if (vmacpflag)
			c = computc(getch, commch);
		ch = c;
		maphopcnt = 0;
		if (vglobp == 0 && Peekkey == 0 && commch != 'r')
			while ((ch = map(c, immacs)) != c) {
				getch = c = ch;
				if (!value(REMAP))
					break;
				if (++maphopcnt > 256)
					error("Infinite macro loop");
			}
		/*
		 * CTRL(r) && *svalue(CHLK)
		 *		Change insert letter fron RL letter
		 *		to LR and viaversa. CTRL(r)
		 *		works only in insert mode and stay 
		 *   		the cursor in the same point.
		 */
		if (c == *svalue(CHLK) || c == CTRL(r)){
			if (c == CTRL(r) && ishef){
				beep();
				continue;
			}
			if (cntdu){
				if (Mdirect)
					destcol += cntdu;
				else
					destcol -= cntdu;
				vgotoCL(destcol);
				cntdu = 0;
				continue;
			}
			if (doomed && commch != 'R') {
				if (isecondlang) {
					destcol -= (doomed - 1);
					vgotoCL(destcol);
				}
				if (!splitw)
					reducendl(vtube0+destcol, vtube0+destcol+doomed);
				doomed = 0;
				cntbak = 0;
			}
			*aescaped = c;
			goto vadone;
		}
		if (!iglobp) {

			/*
			 * Erase-kill type processing.
			 * Only happens if we were not reading
			 * from untyped input when we started.
			 * Map users erase to ^H, kill to -1 for switch.
			 */
#ifndef USG3TTY
			if (c == tty.sg_erase)
				c = CTRL(h);
			else if (c == tty.sg_kill)
				c = -1;
#else
			if (c == tty.c_cc[VERASE])
				c = CTRL(h);
			else if (c == tty.c_cc[VKILL])
				c = -1;
#endif
			
			switch (c) {

			/*
			 * ^?		Interrupt drops you back to visual
			 *		command mode with an unread interrupt
			 *		still in the input buffer.
			 *
			 * ^\		Quit does the same as interrupt.
			 *		If you are a ex command rather than
			 *		a vi command this will drop you
			 *		back to command mode for sure.
			 */
			case ATTN:
			case QUIT:
				ungetkey(c);
				goto vadone;

			/*
			 * ^H		Backs up a character in the input.
			 *
 			 * BUG:		Can't back around line boundaries.
			 *		This is hard because stuff has
			 *		already been saved for repeat.
			 */
			case CTRL(h):
bakchar:
				cp = gcursor - 1;
				if (cp < ogcursor) {
					if (splitw) {
						/*
						 * Backspacing over readecho
						 * prompt. Pretend delete but
						 * don't beep.
						 */
						*aescaped = c;
						ungetkey(c);
						goto vadone;
					}
					beep();
					continue;
				}
				/*
				 * This code was added for the vi.iv .
				 * It deals with backing up a character
				 * in secondry language.
				 */
				 *--tmop = 0;
				if (!splitw && (isecondlang || (isRL && cntdu))){
					x = compcol(cntl);
					/*
					 * deletes the character from
					 * the buffer.
					 */
					if (!isRLtext && cntdu)
						slp +=cntdu;
					reducbuff(slp, slp + 1,gcursor);
					if (!isRLtext && cntdu)
						slp -=cntdu;
					if (slp > gcursor)
						slp = gcursor;
					*gcursor = 0;
					/*
					 * computes the number of
					 * columns occupied by the
					 * delete character.
					 */
					y = x - compcol(cntl);
					if (y) {
						if (helpbak){
							y -= helpbak;
							helpbak = 0;
						}
					} else {
						y = 1;
						helpbak++;
					}
					if (cntdu > 0){
					   if (!isRLtext)
						destcol -=1;
					    reducendl(vtube0+destcol,vtube0+destcol+1);
					    cntdu--;
					    cntbak = y;
					    moveto = 0;
					} else {
						cntbak += y;
						doomed += y;
						cntcolin -=y;
					}
					cntchar--;
					duflag = 1;
				}
				goto vbackup;

			/*
			 * ^W		Back up a white/non-white word.
			 */
			case CTRL(w):
				wdkind = 1;
				/*
				 * Find the end point of the word
				 * in the buffer.
				 */
				for (cp = tmop; cp > timeorder && isspace(cp[-1] & TRIM);cp--)
						continue;
				for (c = wordch(cp - 1); cp > timeorder && wordof(c, cp - 1); cp--)
						continue;
				*cp = 0;
				if (!isecondlang){
					for (cp = gcursor; cp > ogcursor && isspace(cp[-1] & TRIM);cp--)
						continue;
					for (c = wordch(cp - 1); cp > ogcursor && wordof(c, cp - 1); cp--)
						continue;
				}
				else{
					/*
					 * This code was added for the 
					 * vi.iv . It deals with backing
					 * up a word in secondry languge
					 */
					if (!*slp){
						/*
						 * No character in the
						 * buffer.
						 */
						beep();
						continue;
					}
					/*
					 * Find the end point of the
					 * word. 
					 */
					for (cp = slp; cp < gcursor && isspace(*cp & TRIM); cp++ )
						continue;
					/*
					 * Find the beginnig point of 
					 * the word. 
					 */
					for (c = wordch(cp); cp < gcursor && wordof(c, cp); cp++)
						continue;
					/*
					 * All the character from 
					 * ogcursor to cp must be delete
					 * from the buffer .
					 */
backword:
					x = compcol(cntl);
					i = cp - ogcursor;
					/*
					 * computes the numbers of 
					 * columns occupied by the word.
					 */ 
					reducbuff(slp, slp+i, gcursor);
					y = x - compcol(cntl);
					cntchar -=i;
					if ((cntdu - i) > 0)
						cntdu -= i;
					else
						cntdu = 0;
					cntcolin -= y;
					cp = gcursor - i;
					destcol -= cntdu;
					if (destcol  < 0){
						destcol = WCOLS - destcol;
						destline--;
					}
					i = destcol + (destline - LINE(vcline)) * WCOLS;
					reducendl(vtube0+i, vtube0+i+y);
					moveto = 0;
					duflag = 1;
				}
				goto vbackup;

			/*
			 * users kill	Kill input on this line, back to
			 *		the autoindent.
			 */
			case -1:
				cp = ogcursor;
vbackup:
				if (((splitw || !isecondlang) && cp == gcursor)  || (ogcursor > cp)){
					beep();
					continue;
				}
				endim();
				*cp = 0;
				c = cindent();
				/*
				 * In echo area & RL-mode we delete
				 * the last insert character and
				 * print all the line again.
				 */
				if (Outchar == vputchar && splitw && isRL){
					if (cntdu)
						cntdu--;
					vgotoCL(destcol-cntcolin+cntdu);
					for(ep = --gcursor; ep>(slp+cntdu);)
						putchar(*--ep);
					vclreol();
					cntcolin -= abs(c - cindent());
					cntchar--;
					*gcursor = 0;
					continue;
				}
				if (slp > gcursor)
					slp = gcursor;
				/*
				 * Moves the cursor to its new position.
				 */ 
				if (moveto)
					if (splitw || slp == gcursor ||
bactab) {
						cntchar--;
						vgotoCL(qcolumn(cursor - 1, genbuf));
						bactab = 0;
					} else
						vgotoCL(cntl+cntbak-1);
				else
					moveto = 1;
				/*
				 * Update doome for main language.
				 * for secondry language we did it
				 * before.
				 */
				if (doomed >= 0 && !duflag)
					doomed += c - cindent();
				else
					duflag = 0;
				gcursor = cp;
				*gcursor = 0;
				vcsync();
				continue;

			/*
			 * \		Followed by erase or kill
			 *		maps to just the erase or kill.
			 */
			case '\\':
				x = destcol, y = destline;
				putchar('\\');
				vcsync();
				getch = getkey();
				if (getch != ATTN)
					c = getch & TRIM;
				else
					c = getch;
#ifndef USG3TTY
				if (c == tty.sg_erase || c == tty.sg_kill)
#else
				if (c == tty.c_cc[VERASE]
				    || c == tty.c_cc[VKILL])
#endif
				{
					if (isecondlang)
						vgoto(destline, destcol);
					else
						vgoto(y, x);
					if (doomed >= 0)
						doomed++;
					goto def;
				}
				ungetkey(getch), getch = '\\', c = '\\';
				backsl = 1;
				break;

			/*
			 * ^Q		Super quote following character
			 *		Only ^@ is verboten (trapped at
			 *		a lower level) and \n forces a line
			 *		split so doesn't really go in.
			 *
			 * ^V		Synonym for ^Q
			 */
			case CTRL(q):
			case CTRL(v):
				x = destcol, y = destline;
				putchar('^');
				vgoto(y, x);
				getch = getkey();
				if (getch != ATTN)
					c = getch & TRIM;
				else
					c = getch;
#ifdef TIOCSETC
				if (c == ATTN)
					c = nttyc.t_intrc;
#endif
				if (c != NL) {
					if (doomed >= 0)
						doomed++;
					goto def;
				}
				break;
			}
		}

		/*
		 * If we get a blank not in the echo area
		 * consider splitting the window in the wrapmargin.
		 */
		if (c != NL && !splitw) {
			if (c == ' ' && gobblebl) {
				gobbled = 1;
				continue;
			}
			if (value(WRAPMARGIN))
			/*
			 * if WARPMAGIN option is set and we are
			 * writing in secondry languge it need a special
			 * tretment because the line must break in the
			 * middle.
			 */
			   if (isecondlang &&
				( (i = compcol(cntl)) > OCOLUMNS - value(WRAPMARGIN) + wmore || 
				 backsl && outcol==0) &&
				commch != 'r'){
wraplable:
					 if (c == CR || c == NL)
						goto newline;
					if (c == ESCAPE)
						goto dontbreak;

					/*
	 				 *  Move the last word to next 
					 * line and keep going
	 				 */
					wdkind = 1;
					*tmop++ = computc(getch, commch);;
					if (backsl)
						*tmop++ = computc(getkey(), commch);
					*tmop = 0;
					for(tp = tmop; tp> timeorder && isspace(tp[-1] & TRIM); tp--)
						;
				if (i + (backsl?OCOLUMNS:0) - (tmop - tp) >= OCOLUMNS - value(WRAPMARGIN)){
					for(; tp > timeorder && !isspace(tp[-1] & TRIM); tp--)
						;
					if (tp <= timeorder){
						if (backsl)
							ungetkey(*--tmop);
						c = *--tmop;
						*tmop = 0;
						beep();
						goto dontbreak;
					}
					push = 1;
					macpush(tp, 0);
					tp--;
				}
				if (!push){
					if (backsl && !isspace(*--tmop & TRIM))
						macpush(tmop, 0);
					if (!isspace(*--tmop & TRIM))
						macpush(tmop, 0);
					*tmop = 0;
					i = 0;
				}
				macpush("\n",0);
				while(tp > timeorder && isspace(tp[-1] & TRIM))
					tp--;
				if (push){
					i = (tmop - 1- tp) - (backsl?1:0);
					push = 0;
				}
				if(!isecondlang){
					cp = gcursor - i;
					*tp = 0;
					goto vbackup;
				} else {
					cp = slp + i;
					*tp = 0;
					goto backword;
				}
		 } else
			   	if (!isecondlang && (outcol >= OCOLUMNS - value(WRAPMARGIN) ||
				 backsl && outcol==0) && commch != 'r') {
				/*
				 * At end of word and hit wrapmargin.
				 * Move the word to next line and keep going.
				 */
				i= outcol;
				goto wraplable;
			}
		dontbreak:;
		}

		/*
		 * Word abbreviation mode.
		 */
		cstr[0] = computc(c, commch);
		if (anyabbrs && !wordch(cstr))
			if (tmop > timeorder && wordch(tmop-1)){
				int wdtype, abno;

				cstr[1] = 0;
				wdkind = 1;
				tp = tmop - 1;
				for (wdtype = wordch(tp - 1);
				    tp > timeorder && wordof(wdtype, tp - 1); tp--)
					;
				*tmop = 0;
				for (abno=0; abbrevs[abno].mapto; abno++) {
					if (eq(tp, abbrevs[abno].cap)) {
						macpush(cstr, 0);
						macpush(abbrevs[abno].mapto);
						if(!isecondlang){
							cp = gcursor - (tmop - tp);
							*tp = 0;
							goto vbackup;
						} else {
							cp = slp + (tmop - tp);
							*tp = 0;
							goto backword;
						}
					}
				}
		}/* else
			if (isecondlang && slp < gcursor && wordch(slp)){
				int wdtype, abno;
				char esave[LBSIZE];

				cstr[1] = 0;
				wdkind = 1;
				cp = slp;
				for (wdtype = wordch(cp);
				    cp < gcursor && wordof(wdtype, cp);
						cp++)
					;
				keepch = *cp;
				*cp = 0;
				for (abno=0; abbrevs[abno].mapto; abno++) {
					if (eq(slp, abbrevs[abno].cap)) {
						macpush(cstr, 0);
						CP(esave,abbrevs[abno].mapto);
						revers(esave);
						macpush(esave);
						*cp = keepch;
						goto backword;
					}
				}
				*cp = keepch;
			}*/
newline:

			
		switch (c) {
		/*
		 * ^M		Except in repeat maps to \n.
		 */
		case CR:
			if (vglobp)
				goto def;
			c = '\n';
			/* presto chango ... */

		/*
		 * \n		Start new line.
		 */
		case NL:
			*aescaped = c;
			wmore = 0;
			goto vadone;

		/*
		 * escape	End insert unless repeat and more to repeat.
		 */
		case ESCAPE:
			if (lastvgk)
				goto def;
			goto vadone;


		/*
		 * ^D		Backtab.
		 * ^T		Software forward tab.
		 *
		 *		Unless in repeat where this means these
		 *		were superquoted in.
		 */
		case CTRL(d):
		case CTRL(t):
			if (vglobp)
				goto def;
			/* fall into ... */

		/*
		 * ^D|QUOTE	Is a backtab (in a repeated command).
		 */
		case CTRL(d) | QUOTE:
			*gcursor = 0;
			cp = vpastwh(genbuf);
			c = whitecnt(genbuf);
			if (ch == CTRL(t)) {
				/*
				 * ^t just generates new indent replacing
				 * current white space rounded up to soft
				 * tab stop increment.
				 */
				if (cp != gcursor)
					/*
					 * BUG:		Don't hack ^T except
					 *		right after initial
					 *		white space.
					 */
					continue;
				cp = genindent(iwhite = backtab(c + value(SHIFTWIDTH) + 1));
				ogcursor = cp;
				bactab = 1;
				slp = cp;
				goto vbackup;
			}
			/*
			 * ^D works only if we are at the (end of) the
			 * generated autoindent.  We count the ^D for repeat
			 * purposes.
			 */
			if (c == iwhite && c != 0)
				if (cp == gcursor) {
					iwhite = backtab(c);
					CDCNT++;
					ogcursor = cp = genindent(iwhite);
					slp = cp;
					bactab = 1;
					goto vbackup;
				} else if (&cp[1] == gcursor &&
				    ((*cp & TRIM) == '^' || (*cp & TRIM)== '0')) {
					/*
					 * ^^D moves to margin, then back
					 * to current indent on next line.
					 *
					 * 0^D moves to margin and then
					 * stays there.
					 */
					HADZERO = *cp == '0';
					ogcursor = cp = genbuf;
					HADUP = 1 - HADZERO;
					CDCNT = 1;
					endim();
					back1();
					vputchar(' ');
					slp = cp;
					if (cntdu)
						cntdu = 0;
					if (isRL) {
					    destcol = value(NUMBER) ? 8 : 0;
					    reducendl(vtube0+destcol,vtube0+destcol+iwhite);
					    moveto = 0;
					    duflag = 1;
					} else
					    bactab = 1;
					goto vbackup;
				}
			if (vglobp && vglobp - iglobp >= 2 &&
			    (vglobp[-2] == '^' || vglobp[-2] == '0')
			    && gcursor == ogcursor + 1)
				goto bakchar;
			continue;

		default:
			/*
			 * Possibly discard controlk inputs.
			 */
			if (!vglobp && junk(c)) {
				beep();
				continue;
			}
def:
			/*
			 * if we permet insert uppercase letter or
			 * number in RL-mode from left to right set
			 * duflag if the character is digit or
			 * uppercase.
			 */
			duflag = isdu(c, cntdu, commch);
			c = computc(getch, commch);
			if (duflag && doomed){
				if (!isRLtext){
					destcol -= doomed-1;
					if (destcol  < 0){
						destcol = WCOLS - destcol;
						destline--;
					}
					vgoto(destline, destcol);
				}
				reducendl(vtube0+destcol, vtube0+destcol+doomed);
				doomed = 0;
				cntbak = 0;
			}
			/*
			 * In the echo erea we use vputchar procedure
			 * which not shifting the letters in the line
			 * so we do it by puting the characters in 
			 * buffer and after printing the new char we
			 * printing all the others from the buffer.
			 */
			if (splitw && isRL){
				if (duflag)
					cp = slp + cntdu;
				else {
					cp = slp;
					cntdu = 0;
				}
				for(fp=splitwbuff, ep=gcursor; ep > cp;)
					*fp++ = *--ep;
				*fp = 0;
				cp =slp;
				vgotoCL(destcol-cntcolin+cntdu);
				x = destcol;
			} else
				x = compcol(cntl);
			if (!backsl) {
				/*
				 * IN the secondry languge we must chack
				 * if we fill the line because the 
				 * cursor stay in the middle of the line
				 * and push the text. 
				 */
				if (isRL) {
					/*
				 	 * In RL-mode we move the cursor
					 * to the position were the new
					 * uppercase letter or digit 
					 * must be added.
				 	 */
					if (!duflag && cntdu && !splitw)
						if (Mdirect == LR)
							destcol -= cntdu;
						else
							destcol += cntdu;
					/*
					 * put in the screen the RL 
					 * letter.
					 */
					putchar( c );
					if (splitwbuff){
						if (Outchar == vputchar)
							cntcolin += destcol - x;
						/*
						 * if use vputchar print
						 * the lettre insert 
						 * before.
						 */
						if (*splitwbuff){
							for (ep=splitwbuff; *ep; ep++)
								putchar(*ep);
							splitwbuff[0] = 0;
						}
					}
					/*
				 	 * In RL-mode we return the
					 * cursor to the position were
					 * it be before insert the
					 * new uppercase letter or digit
				 	 */
					if (duflag && !splitw){
						if (Mdirect == LR)
							destcol += 1;
						else
							destcol -= 1;
						fgoto();
					}
				}else
					/*
					 * put in the screen the LR 
					 * letter.
					 */
					if (commch != 'p')
						putchar(c);
			}
			flush();
			if (gcursor > &genbuf[LBSIZE - 2])
				error("Line too long");
			if (cntdu && !duflag)
				cntdu = 0;
			/*
			 * if we stay in secondry language insert mode ,
			 * or in RL-text and insert uppercase letter or
			 * digit we put the new character in the 
			 * position which slp point it, so we must shift
			 * all the charcters which after this position
			 * in the buffer.
			 */
			if (!splitw && (isecondlang ||
					( Mdirect == RL && duflag))){
				if (duflag && isRL)
					if (!isRLtext)
						slp += cntdu;
					else
						if (!cntdu)
							slp = gcursor;
				/*
				 * The shifting.
				 */
				ep = gcursor++;
				fp = ep--;
				while (ep >= slp)
						*fp-- = *ep--;
			}
			/*
			 * put the character in the buffer.
			 */
			if (splitw || (!isecondlang &&
					(!duflag || Mdirect == LR))){
					*gcursor++ = c;
					if (!splitw)
						slp = gcursor;
			} else
					*slp = c;
			*tmop++ = c;
			*tmop = 0;
			*gcursor = 0;
			if (helpbak)
				if ((c & TRIM) == '\t') 
					helpbak = 0;
				else
					helpbak--;
			if (isRL && duflag){
				duflag = 0;
				if (!isRLtext && !splitw)
					slp -= cntdu;
				cntdu++;
			}
			cntchar++;
			if (Outchar != vputchar)
				cntcolin += compcol(cntl) - x;
			vcsync();
			c &= TRIM;
			if (value(SHOWMATCH) && !iglobp)
				if ((Mdirect == LR &&(c == ')'|| c == '}')) 
					|| (Mdirect == RL && (c == '(' || c == '{')))
					lsmatch(gcursor);
			continue;
		}
	}
vadone:
	*gcursor = 0;
	if (isecondlang && ishef && append)
		changseclan(ogcursor,Mdirect);
	if (Outchar != termchar)
		Outchar = OO;
	endim();	/* end insert mode */
	if (*aescaped != CTRL(r) && *aescaped != *svalue(CHLK))
		INdirect = SINdirect;
	else {
		INdirect = !SINdirect;
		chadir();
	}
	return (gcursor);
}

/*---------------------------------------------------------------
 * compcol -- compute the column
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 * Computes the column that the next character inserted will be placed
 * at (or maybe it computes the column that the last character was
 * placed at.  I'm not sure [Haim Roman 11/1989]).
 *
 * The main work this function does is to take the direction & tabs into
 * account.
 *
 * NOTE -- if you look at the code, it seems to worry about direction
 * only if the last character was a tab.  I don't know if this is a
 * mistake or not [Haim Roman 11/1989]
 *
 * VALUE RETURNED BY FUNCTION:
 * ---------------------------
 * the column computed
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * col (in) -- the number of the column that the last character is on.
 *
 * EXTERNAL VARIABLES:  
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 * ogcursor (in) -- points to the last character.
 * Mdirect (in) -- current direction
 * value(TABSTOP) -- how many columns apart the tab stops are
 *
 *-------------------------------------------------------------------
 */
int
compcol(col)
	register int col;
{
	register char *hp = ogcursor;
	int d;

	for(; *hp; hp++)
		if ((*hp & TRIM) =='\t') {
			d = *hp;
			if (RL_letter(d) != Mdirect)
				col += value(TABSTOP);
			else
				col += value(TABSTOP) - (col % value(TABSTOP));
		}
		else
			col++;
	return(col);
}

reducbuff(fp, ep, sp)
	register char *fp, *ep, *sp; 
{
	while (fp < sp)
		*fp++ = *ep++;
}

reducendl(fp, ep)
	register char *fp, *ep; 
{
	register int i = ep-fp;
	register int scol, slin;
		 int (*splod)();
	register char *tp = fp; 

	scol = destcol , slin = destline;
	while (*ep)
		vputchar(*ep++);
	if (Mdirect)
		vclreolRL();
	else
		vclreol();
	if (destline < (i = LINE(vcline)+DEPTH(vcline)-1)){
		splod =Plod;
		Plod = plod;
		for(; i > destline; i--){
			vgoto(i,0);
			vclreol();
		}
		Plod = splod;
	}
	vgoto(slin, scol);
}

clearbit(cp)
	register char *cp;
{
	for (; *cp; cp++)
		*cp &= TRIM;
}


computc(c, comch)
	int c;
	char comch;
{


	if (comch == 'r')
		return(c);
	if (vmacpflag){
		vmacpflag = 0;
		if (RL_letter(c) != INdirect && isprint(c & TRIM)){
			keepchar = c;
			archl = !archl;
			return(*svalue(CHLK));
		}
		return (ascspec(c));
	}
	if (isRL)
		return(c | QUOTE);
	else
		return(ascspec(c));
}
/*---------------------------------------------------------------
 * isdu -- switch to LR direction while in RL insert mode
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 * This function determines if it is time to implement the option set
 * by the "rlnumberuppercase" ("rlnu" for short) variable: to display
 * digits & upper-case letters in LR direction even though we are in RL
 * insert mode.
 *
 * VALUE RETURNED BY FUNCTION:
 * ---------------------------
 * true = we are in RL mode, but the character should be displayed in
 * LR direction.
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * c (in) -- the character in question.
 * nofirst (in) -- if this is non-0, that means there have already
 * 	been digits or upper-case letters in the current word.  This
 *	is used to implement the feature that once we enter this RL
 *	mode, we continue in it (even if lower-case letters are typed)
 *	until a space or tab is entered.
 * commch (in) -- which visual command we are in (e.g., 'a' for
 *	append, 'p' for put, etc.).
 *
 * EXTERNAL VARIABLES:  (might be #define definitions)
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 * value(RLNU) (in) -- true if the "rlnu" variable was set by the user.
 * isRL (in) -- true if in RL mode (i.e., RL insert mode ????)
 *-------------------------------------------------------------------
 */
bool
isdu(c, nofirst, commch)
	register int c;
	bool nofirst;
	char commch;
{
	bool duflag = 0;	/* local variable, not the external "duflag" */

	/*
	 * if (the user set the 'rlnu' variable) AND
	 *    (we are in RL mode [i.e., RL insert mode???]) AND
	 *    (the command is not a "put")
	 */
	if (value(RLNU) && isRL && commch != 'p'){
		/*
		 * if the character is a digit or upper-case letter,
		 * insert in LR direction.
		 */
		duflag = isdigit(c) || isupper(c);
		/*
		 * Once the user starts typing a digit or upper-case
		 * letter, he stays in LR direction until a space or tab
		 * is typed.
		 */
		if (nofirst && !duflag)
			duflag = (c != ' ' && c != '	');
	}
	return(duflag);
}
