#include <strings.h>

/* Suffix used to identify concrete operators. */
#define CONC_SUFFIX     "_CONC"

/* Maximum number of children of a node in an operator tree. */
#define MAX_CHILDREN    25

/* Maximum number of COST variables in a descriptor.  Usually only one. */
#define MAX_COSTS	5

/* Maximum number of calls to helper functions in the Prairie input. */
#define MAX_HELPER_CALLS 200

/* Maximum number of helper functions defined. */
#define MAX_HELPERS	100

/* Maximum number of layers allowed. */
#define MAX_LAYERS	10

/* Maximum number of operators and algorithms in Prairie. */
#define MAX_OPS		50

/* Number of passes made over the Prairie input file. */
#define NUM_PASSES	3

/* Maximum number of property fields in a descriptor. */
#define MAX_PROPS	50

/* Maximum number of rules (both T-rules and I-rules) in Prairie. */
#define	MAX_RULES	200

/* Maximum string length.  Used by the preprocessor for various purposes. */
#define MAX_STR_LEN	500

/* Name of the special no-op algorithm. */
#define NULL_ALG        "Null"

/* Maximum length of a string matched by the preprocessor. */
#define TOK_STR_LEN	2000

/* The Prairie input file. */
#define PRAIRIE_INPUT	"prairie.input"

/* Working copy of PRAIRIE_INPUT. */
#define PRAIRIE_WORKING	"_prairie.input"

/* The model definition file for the Volcano optimizer generator. */
#define PRAIRIE_OUTPUT	"prairie.trules"

/* The model definition file for the Volcano implementation rules. */
#define PRAIRIE_IRULES	"prairie.irules"

/* The model definition file for the Volcano transformation rules. */
#define PRAIRIE_TRULES	"prairie.trules"

/* The file for prototype declarations of Prairie helper functions. */
#define PROTOTYPE_FILE	"prototypes.h"

/* The file for the OPERATOR and ALGORITHM type definitions. */
#define OPERATOR_FILE	"OPERATOR.h"
#define ALGORITHM_FILE	"ALGORITHM.h"

/* The header file for Volcano. */
#define DBIH		"dbi.h"

/* The file for actions of rules for Volcano. */
#define DBIC		"dbi.c"

#define	allocate(T)	(T *) malloc (sizeof(T))

typedef enum { OPR, ALG, ENF_OPR, ENF } OP_TYPE ;
typedef enum { OPR_NODE, ALG_NODE, STR_NODE, REL_NODE } NODE_TYPE ;

/* PROP_TYPE is the type of a property in a descriptor; it can be a
   logical property, operator argument, cost, physical property, or
   a C++ method. */
typedef enum { LOG_PROP, OP_ARG, COST, PHY_PROP, METHOD } PROP_TYPE ;

typedef struct ARITY {
	int		streams ;
	int		files ;
} ARITY ;

typedef struct OP_TABLE {
	char		name [MAX_STR_LEN] ;
	OP_TYPE		op_type ;
	ARITY		arity ;
	int		redundant ;
} OP_TABLE ;

typedef struct OPR_MAP {
	char	from [MAX_STR_LEN] ;
	char	to [MAX_STR_LEN] ;
/*
	char	test [1000] ;
*/
} OPR_MAP ;

typedef struct DESC_MAP {
	char	from [MAX_STR_LEN] ;
	char	to [MAX_STR_LEN] ;
} DESC_MAP ;

typedef struct PROP {
	char		declarator [MAX_STR_LEN] ;
	char		prefix [MAX_STR_LEN] ;
	char		name [MAX_STR_LEN] ;
	char		postfix [MAX_STR_LEN] ;
	PROP_TYPE	type ;
} PROP ;

typedef struct TREE_TYPE {
	NODE_TYPE		node_type ;
	char			name [MAX_STR_LEN] ;  /* opr, alg or str */
	char			desc [MAX_STR_LEN] ;  /* name of descriptor */
	struct TREE_TYPE	*child [MAX_CHILDREN] ;
} TREE_TYPE ;

typedef struct LIST_TREES {
	TREE_TYPE		*trees [MAX_CHILDREN] ;
	int			num_trees ;
} LIST_TREES ;

typedef struct RULE_LAYER_INFO {
	int		rule_num ;
	int		layer_num ;
} RULE_LAYER_INFO ;	

typedef struct LAYERS {
	char		name [MAX_STR_LEN] ;
	int		layer_num ;
	int		next_layer ;
	int		defined ;
} LAYERS ;
