(load "elisp-fmt")

(put 'nil 'latexinfo-format 'latexinfo-format-nil)
(defun latexinfo-format-nil ()
  (latexinfo-parse-noarg)
  (insert "nil"))

(put 'T  'latexinfo-format 'latexinfo-format-true)
(put 'TRUE 'latexinfo-format 'latexinfo-format-true)
(put 'true 'latexinfo-format 'latexinfo-format-true)
(defun latexinfo-format-true ()
  (latexinfo-parse-noarg)
  (insert "true"))

(put 'FALSE 'latexinfo-format 'latexinfo-format-false)
(put 'F 'latexinfo-format 'latexinfo-format-false)
(put 'false 'latexinfo-format 'latexinfo-format-false)
(defun latexinfo-format-false ()
  (latexinfo-parse-noarg)
  (insert "false"))

(put 'empty 'latexinfo-format 'latexinfo-format-empty)
(defun latexinfo-format-empty ()
  (latexinfo-parse-noarg)
  (insert "()"))

(put '&key 'latexinfo-format 'latexinfo-format-&key)
(defun latexinfo-format-&key ()
  (latexinfo-parse-noarg)
  (insert  "&key"))

(put '&optional 'latexinfo-format 'latexinfo-format-optional)
(defun latexinfo-format-optional ()
  (latexinfo-parse-noarg)
  (insert  "&optional"))

(put '&rest 'latexinfo-format 'latexinfo-format-&rest)
(defun latexinfo-format-&rest ()
  (latexinfo-parse-noarg)
  (insert  "&rest"))

(put 'defconst  'latexinfo-defun-indexing-property 'latexinfo-index-defun)
(put 'defconstx  'latexinfo-defun-indexing-property 'latexinfo-index-defun)

(put 'defconst 'latexinfo-deffn-formatting-property
     'latexinfo-format-specialized-defun)
(put 'defconstx 'latexinfo-deffn-formatting-property
     'latexinfo-format-specialized-defun)

(put 'defconst 'latexinfo-format 'latexinfo-format-defun)
(put 'defconstx 'latexinfo-format 'latexinfo-format-defunx)
(put 'enddefconst 'latexinfo-format 'latexinfo-end-defun)
(put 'defconst 'latexinfo-defun-type '('defun-type "Constant"))
(put 'defconstx 'latexinfo-defun-type '('defun-type "Constant"))
(put 'defconst 'latexinfo-defun-index 'latexinfo-vindex)
(put 'defconstx 'latexinfo-defun-index 'latexinfo-vindex)


(defun latexinfo-format-deffn (parsed-args)
  ;; Generalized function-like, variable-like, or generic data-type entity:
  ;; \deffn category name args...
  ;;     In Info, `Category: name ARGS'
  ;; \deftp category name attributes...
  ;; `category name attributes...'       Note: \deftp args in lower case.
  (let ((category (car parsed-args))
        (name (car (cdr parsed-args)))
        (args (cdr (cdr parsed-args))))
    (insert " -- " category ": " name)
    (while args
      (insert " "
	      (car args))		; dont upcase arguments - mike
      (setq args (cdr args)))))

(defun latexinfo-format-specialized-defun (parsed-args)
  ;; Specialized function-like or variable-like entity:
  ;; \defun name args           In Info, `Function: Name ARGS'
  ;; \defmac name args          In Info, `Macro: Name ARGS'
  ;; \defvar name               In Info, `Variable: Name'
  ;; Use cdr of command-type to determine category:
  (let ((category (car (cdr command-type)))
        (name (car parsed-args))
        (args (cdr parsed-args)))
    (insert " -- " category ": " name)
    (while args
      (insert " "
	      (car args)
	      "\n")
      (setq args (cdr args)))))

(put 'mopt 'latexinfo-format 'latexinfo-format-mopt)
(defun latexinfo-format-mopt ()
  (insert "[" (latexinfo-parse-arg-discard) "]")
  (goto-char latexinfo-command-start))

(put 'mchoice 'latexinfo-format 'latexinfo-format-mchoice)
(defun latexinfo-format-mchoice ()
  (insert "[[" (latexinfo-parse-arg-discard) "]]")
  (goto-char latexinfo-command-start))

(put 'mstar 'latexinfo-format 'latexinfo-format-mstar)
(defun latexinfo-format-mstar ()
  (insert "{" (latexinfo-parse-arg-discard) "}*")
  (goto-char latexinfo-command-start))

(put 'mplus 'latexinfo-format 'latexinfo-format-mplus)
(defun latexinfo-format-mplus ()
  (insert "{" (latexinfo-parse-arg-discard) "}+")
  (goto-char latexinfo-command-start))

(put 'mgroup 'latexinfo-format 'latexinfo-format-mgroup)
(defun latexinfo-format-mgroup ()
  (insert "{" (latexinfo-parse-arg-discard) "}")
  (goto-char latexinfo-command-start))

(put 'mor 'latexinfo-format 'latexinfo-format-mor)
(defun latexinfo-format-mor ()
  (latexinfo-parse-noarg)
  (insert "|"))

(put 'mind 'latexinfo-format 'latexinfo-format-mind)
(defun latexinfo-format-mind ()
  (insert "v " (latexinfo-parse-arg-discard) )
  (goto-char latexinfo-command-start))

;; Number of arguments
(put 'deffn 'latexinfo-numargs 3)
(put 'deffnx 'latexinfo-numargs 3)
(put 'defun 'latexinfo-numargs 2)
(put 'defunx 'latexinfo-numargs 2)
(put 'defmac 'latexinfo-numargs 2)
(put 'defmacx 'latexinfo-numargs 2)
(put 'defspec 'latexinfo-numargs 2)
(put 'defspecx 'latexinfo-numargs 2)
(put 'defvr 'latexinfo-numargs 2)
(put 'defvrx 'latexinfo-numargs 2)
(put 'defvar 'latexinfo-numargs 1)
(put 'defvarx 'latexinfo-numargs 1)
(put 'defconst 'latexinfo-numargs 1)
(put 'defconstx 'latexinfo-numargs 1)

(provide 'clisp-fmt)
