/* Output from p2c, the Pascal-to-C translator */
/* From input file "WP2LATEX.PAS" */

static char rcsid[] = "$Header: wp2latex.c,v 2.3 90/09/05 09:23:12 glenn Exp $";


#ifdef HAVE_P2C
#include <p2c/p2c.h>
#else
#include "p2c.h"
#endif


/*           Version 1.0
             Date 27-1-1990
*/


Static Char wpd_fn[256], strip_fn[256], tabel_fn[256], latex_fn[256];

Static FILE *wpd, *tabel;
Static FILE *strip, *latex;

Static unsigned short num_of_lines_stripfile;

Static Char open_com[0x11][256], close_com[0x11][256];

/* Static Anyptr Exitsave; */
Static Char wpd_NAME[_FNSIZE];
Static Char tabel_NAME[_FNSIZE];
Static Char strip_NAME[_FNSIZE];
Static Char latex_NAME[_FNSIZE];

Static Void RunError(); /* simulate Turbo 5 builtin */

Static Void Rd_word(f, w)
FILE **f;
unsigned short *w;
{
  /* Deze procedure leest een woord uit de opgegeven binaire file. */
  uchar b;

  fread(&b, sizeof(uchar), 1, *f);
  *w = b;
  fread(&b, sizeof(uchar), 1, *f);
  *w += b * 256;
}


Static Void Wr_word(f, w)
FILE **f;
unsigned short w;
{
  /* Deze procedure schrijft een woord in de opgegeven binaire file. */
  uchar b;

  b = w & 255;
  fwrite(&b, sizeof(uchar), 1, *f);
  b = w / 256;
  fwrite(&b, sizeof(uchar), 1, *f);
}


Static Void Jump_in_file(f, dis)
FILE **f;
long dis;
{
  /* Deze procedure springt in een binaire file het aantal opgegeven bytes. */
  long cur_pos;

  cur_pos = ftell(*f) / sizeof(uchar);
  fseek(*f, (cur_pos + dis) * sizeof(uchar), 0);
}



Static Void Wpd_check()
{
  /* Kontroleert of de opgegeven WP-document wel daadwerkelijk een   */
  /* WP5.0-document is.                                              */
  unsigned short id1, id2, std1, std2, filetype, dmp1, dmp2, dmp3;
  long Startdoc;

  Rd_word(&wpd, &id1);
  Rd_word(&wpd, &id2);
  Rd_word(&wpd, &std1);
  Rd_word(&wpd, &std2);
  Rd_word(&wpd, &filetype);
  Rd_word(&wpd, &dmp1);
  Rd_word(&wpd, &dmp2);
  Rd_word(&wpd, &dmp3);

  Startdoc = std2 * 65536L + std1;

  if (id1 == 0x57ff && id2 == 0x4350 && filetype == 0xa01)
	/*and (dmp1=$0) and (dmp2=$0) and (dmp3=$0)*/
	  fseek(wpd, Startdoc * sizeof(uchar), 0);
  else {
    RunError(0x201);   /* Het is geen WP5.0-document*/
  }

  /* Het is een WP5.0-document*/
}




Static Void Filenames()
{
  /* Deze procedure handelt het opgeven van de filenamen af. */
  Char name[256], invoer[256], wpdef[256], latdef[256], filename[256];
  short l, p;

  if (P_argc < 2)
    *wpdef = '\0';
  else
    strcpy(wpdef, P_argv[1]);

  printf("\n\nWordPerfect-filename [%s] : ", wpdef);
  gets(invoer);
  if (*invoer == '\0')
    strcpy(wpd_fn, wpdef);
  else
    strcpy(wpd_fn, invoer);

  if (*wpd_fn == '\0') {   /* No filename entered */
    RunError(0x200);
  }

  strcpy(name, wpd_fn);
  l = strlen(name);
  p = strpos2(name, ".", 1);
  if (p == 0)
    p = l + 1;
  sprintf(filename, "%.*s", p - 1, name);

  sprintf(strip_fn, "%s.str", filename);
  sprintf(tabel_fn, "%s.tbl", filename);
  sprintf(latdef, "%s.tex", filename);

  printf("LaTeX-filename [%s] : ", latdef);
  gets(invoer);
  putchar('\n');
  if (*invoer == '\0')
    strcpy(latex_fn, latdef);
  else
    strcpy(latex_fn, invoer);

  strcpy(wpd_NAME, wpd_fn);
  strcpy(strip_NAME, strip_fn);
  strcpy(tabel_NAME, tabel_fn);
  strcpy(latex_NAME, latex_fn);

}


Static Void Init_commando()
{
  strcpy(open_com[0], "{\\LARGE ");
  strcpy(open_com[0x1], "{\\Large ");
  strcpy(open_com[0x2], "{\\large ");
  strcpy(open_com[0x3], "{\\small ");
  strcpy(open_com[0x4], "{\\footnotesize ");
  strcpy(open_com[0x5], "$^{\\rm ");
  strcpy(open_com[0x6], "$_{\\rm ");
  *open_com[0x7] = '\0';
  strcpy(open_com[0x8], "{\\it ");
  *open_com[0x9] = '\0';
  *open_com[0xa] = '\0';
  strcpy(open_com[0xb], "\\underline{\\Underline{");
  strcpy(open_com[0xc], "{\\bf ");
  *open_com[0xd] = '\0';
  strcpy(open_com[0xe], "\\Underline{");
  strcpy(open_com[0xf], "{\\sc ");

  strcpy(close_com[0], "}");
  strcpy(close_com[0x1], "}");
  strcpy(close_com[0x2], "}");
  strcpy(close_com[0x3], "}");
  strcpy(close_com[0x4], "}");
  strcpy(close_com[0x5], "}$");
  strcpy(close_com[0x6], "}$");
  *close_com[0x7] = '\0';
  strcpy(close_com[0x8], "\\/}");
  *close_com[0x9] = '\0';
  *close_com[0xa] = '\0';
  strcpy(close_com[0xb], "}}");
  strcpy(close_com[0xc], "}");
  *close_com[0xd] = '\0';
  strcpy(close_com[0xe], "}");
  strcpy(close_com[0xf], "}");
}


/* Local variables for Convert_first_strike: */
struct LOC_Convert_first_strike {
  uchar by;
  unsigned short regelnum;

  Char lat[0x60][26];
  short char_set[0xff];
  short char_code[0xff];
  Char ext_lat[0xff][26];


  short leegptr[2], openptr[2];
  uchar attr_rij[2][17];
  boolean open_attr_rij[2];
  short depth;

  Char envir, line_term;

  boolean char_on_line, nomore_valid_tabs, indenting, indent_end, ind_text1,
	  ind_text2;

  unsigned short ind_leftmargin, ind_rightmargin;

  short num_of_tabs, latex_tabpos;
  unsigned short tabpos[40];
  boolean right_tab, align_tab, center_tab;

  short WP_sidemargin;
} ;




Local Void WP_Default(LINK)
struct LOC_Convert_first_strike *LINK;
{
  short j;

  LINK->WP_sidemargin = 1200;

  LINK->tabpos[0] = 0x2c5;   /* 1e WP-tab is kantlijn --> */
  for (j = 2; j <= 10; j++)   /* Volgende tabs 1,5  cm     */
    LINK->tabpos[j - 1] = LINK->tabpos[j - 2] + 0x2c5;
  for (j = 10; j <= 39; j++)   /* ($02c5 wpu) verder        */
    LINK->tabpos[j] = 0xffffL;

  LINK->num_of_tabs = 10;
}


Local Void Table_Init(LINK)
struct LOC_Convert_first_strike *LINK;
{
  strcpy(LINK->lat[0], " ");   /*Space*/
  strcpy(LINK->lat[0x1], "!");   /*!*/
  strcpy(LINK->lat[0x2], "\"");   /*"*/
  strcpy(LINK->lat[0x3], "\\#");   /*#*/
  strcpy(LINK->lat[0x4], "\\$");   /*dollar*/
  strcpy(LINK->lat[0x5], "\\%");   /*%*/
  strcpy(LINK->lat[0x6], "\\&");   /*&*/
  strcpy(LINK->lat[0x7], "'");   /*'*/
  strcpy(LINK->lat[0x8], "(");   /*(*/
  strcpy(LINK->lat[0x9], ")");   /*)*/
  strcpy(LINK->lat[0xa], "*");   /***/
  strcpy(LINK->lat[0xb], "+");   /*+*/
  strcpy(LINK->lat[0xc], ",");   /*,*/
  strcpy(LINK->lat[0xd], "-");   /*-*/
  strcpy(LINK->lat[0xe], ".");   /*.*/
  strcpy(LINK->lat[0xf], "/");   /*/*/
  strcpy(LINK->lat[0x10], "0");   /*0*/
  strcpy(LINK->lat[0x11], "1");   /*1*/
  strcpy(LINK->lat[0x12], "2");   /*2*/
  strcpy(LINK->lat[0x13], "3");   /*3*/
  strcpy(LINK->lat[0x14], "4");   /*4*/
  strcpy(LINK->lat[0x15], "5");   /*5*/
  strcpy(LINK->lat[0x16], "6");   /*6*/
  strcpy(LINK->lat[0x17], "7");   /*7*/
  strcpy(LINK->lat[0x18], "8");   /*8*/
  strcpy(LINK->lat[0x19], "9");   /*9*/
  strcpy(LINK->lat[0x1a], ":");   /*:*/
  strcpy(LINK->lat[0x1b], ";");   /*;*/
  strcpy(LINK->lat[0x1c], "$<$");   /*<*/
  strcpy(LINK->lat[0x1d], "=");   /*=*/
  strcpy(LINK->lat[0x1e], "$>$");   /*>*/
  strcpy(LINK->lat[0x1f], "?");   /*?*/
  strcpy(LINK->lat[0x20], "@");   /*@*/
  strcpy(LINK->lat[0x21], "A");   /*A*/
  strcpy(LINK->lat[0x22], "B");   /*B*/
  strcpy(LINK->lat[0x23], "C");   /*C*/
  strcpy(LINK->lat[0x24], "D");   /*D*/
  strcpy(LINK->lat[0x25], "E");   /*E*/
  strcpy(LINK->lat[0x26], "F");   /*F*/
  strcpy(LINK->lat[0x27], "G");   /*G*/
  strcpy(LINK->lat[0x28], "H");   /*H*/
  strcpy(LINK->lat[0x29], "I");   /*I*/
  strcpy(LINK->lat[0x2a], "J");   /*J*/
  strcpy(LINK->lat[0x2b], "K");   /*K*/
  strcpy(LINK->lat[0x2c], "L");   /*L*/
  strcpy(LINK->lat[0x2d], "M");   /*M*/
  strcpy(LINK->lat[0x2e], "N");   /*N*/
  strcpy(LINK->lat[0x2f], "O");   /*O*/
  strcpy(LINK->lat[0x30], "P");   /*P*/
  strcpy(LINK->lat[0x31], "Q");   /*Q*/
  strcpy(LINK->lat[0x32], "R");   /*R*/
  strcpy(LINK->lat[0x33], "S");   /*S*/
  strcpy(LINK->lat[0x34], "T");   /*T*/
  strcpy(LINK->lat[0x35], "U");   /*U*/
  strcpy(LINK->lat[0x36], "V");   /*V*/
  strcpy(LINK->lat[0x37], "W");   /*W*/
  strcpy(LINK->lat[0x38], "X");   /*X*/
  strcpy(LINK->lat[0x39], "Y");   /*Y*/
  strcpy(LINK->lat[0x3a], "Z");   /*Z*/
  strcpy(LINK->lat[0x3b], "[");   /*[*/
  strcpy(LINK->lat[0x3c], "$\\tt\\backslash$");   /*\*/
  strcpy(LINK->lat[0x3d], "]");   /*]*/
  strcpy(LINK->lat[0x3e], "\\^{");   /*^*/
  strcpy(LINK->lat[0x3f], "\\_");   /*_*/
  strcpy(LINK->lat[0x40], "`");   /*`*/
  strcpy(LINK->lat[0x41], "a");   /*a*/
  strcpy(LINK->lat[0x42], "b");   /*b*/
  strcpy(LINK->lat[0x43], "c");   /*c*/
  strcpy(LINK->lat[0x44], "d");   /*d*/
  strcpy(LINK->lat[0x45], "e");   /*e*/
  strcpy(LINK->lat[0x46], "f");   /*f*/
  strcpy(LINK->lat[0x47], "g");   /*g*/
  strcpy(LINK->lat[0x48], "h");   /*h*/
  strcpy(LINK->lat[0x49], "i");   /*i*/
  strcpy(LINK->lat[0x4a], "j");   /*j*/
  strcpy(LINK->lat[0x4b], "k");   /*k*/
  strcpy(LINK->lat[0x4c], "l");   /*l*/
  strcpy(LINK->lat[0x4d], "m");   /*m*/
  strcpy(LINK->lat[0x4e], "n");   /*n*/
  strcpy(LINK->lat[0x4f], "o");   /*o*/
  strcpy(LINK->lat[0x50], "p");   /*p*/
  strcpy(LINK->lat[0x51], "q");   /*q*/
  strcpy(LINK->lat[0x52], "r");   /*r*/
  strcpy(LINK->lat[0x53], "s");   /*s*/
  strcpy(LINK->lat[0x54], "t");   /*t*/
  strcpy(LINK->lat[0x55], "u");   /*u*/
  strcpy(LINK->lat[0x56], "v");   /*v*/
  strcpy(LINK->lat[0x57], "w");   /*w*/
  strcpy(LINK->lat[0x58], "x");   /*x*/
  strcpy(LINK->lat[0x59], "y");   /*y*/
  strcpy(LINK->lat[0x5a], "z");   /*z*/
  strcpy(LINK->lat[0x5b], "\\{");   /*{*/
  strcpy(LINK->lat[0x5c], "$|$");   /*|*/
  strcpy(LINK->lat[0x5d], "\\}");   /* */
  strcpy(LINK->lat[0x5e], "\\tidle{");   /*~*/
  strcpy(LINK->lat[0x5f], " ");   /*Doesn't exsist*/
}


Local Void Ext_chr_init(LINK)
struct LOC_Convert_first_strike *LINK;
{
  LINK->char_set[0] = 0x1;
  LINK->char_code[0] = 0x26;
  strcpy(LINK->ext_lat[0], "\\c{C}");
  LINK->char_set[0x1] = 0x1;
  LINK->char_code[0x1] = 0x47;
  strcpy(LINK->ext_lat[0x1], "\\\"{u}");
  LINK->char_set[0x2] = 0x1;
  LINK->char_code[0x2] = 0x29;
  strcpy(LINK->ext_lat[0x2], "\\'{e}");
  LINK->char_set[0x3] = 0x1;
  LINK->char_code[0x3] = 0x1d;
  strcpy(LINK->ext_lat[0x3], "\\^{a}");
  LINK->char_set[0x4] = 0x1;
  LINK->char_code[0x4] = 0x1f;
  strcpy(LINK->ext_lat[0x4], "\\\"{a}");
  LINK->char_set[0x5] = 0x1;
  LINK->char_code[0x5] = 0x21;
  strcpy(LINK->ext_lat[0x5], "\\`{a}");
  LINK->char_set[0x6] = 0x1;
  LINK->char_code[0x6] = 0x23;
  strcpy(LINK->ext_lat[0x6], "\\aa ");
  LINK->char_set[0x7] = 0x1;
  LINK->char_code[0x7] = 0x27;
  strcpy(LINK->ext_lat[0x7], "\\c{c}");
  LINK->char_set[0x8] = 0x1;
  LINK->char_code[0x8] = 0x2b;
  strcpy(LINK->ext_lat[0x8], "\\^{e}");
  LINK->char_set[0x9] = 0x1;
  LINK->char_code[0x9] = 0x2d;
  strcpy(LINK->ext_lat[0x9], "\\\"{e}");
  LINK->char_set[0xa] = 0x1;
  LINK->char_code[0xa] = 0x2f;
  strcpy(LINK->ext_lat[0xa], "\\`{e}");
  LINK->char_set[0xb] = 0x1;
  LINK->char_code[0xb] = 0x35;
  strcpy(LINK->ext_lat[0xb], "\\\"{\\i}");
  LINK->char_set[0xc] = 0x1;
  LINK->char_code[0xc] = 0x33;
  strcpy(LINK->ext_lat[0xc], "\\^{\\i}");
  LINK->char_set[0xd] = 0x1;
  LINK->char_code[0xd] = 0x37;
  strcpy(LINK->ext_lat[0xd], "\\`{\\i}");
  LINK->char_set[0xe] = 0x1;
  LINK->char_code[0xe] = 0x1e;
  strcpy(LINK->ext_lat[0xe], "\\\"{A}");
  LINK->char_set[0xf] = 0x1;
  LINK->char_code[0xf] = 0x22;
  strcpy(LINK->ext_lat[0xf], "\\AA ");
  LINK->char_set[0x10] = 0x1;
  LINK->char_code[0x10] = 0x28;
  strcpy(LINK->ext_lat[0x10], "\\'{E}");
  LINK->char_set[0x11] = 0x1;
  LINK->char_code[0x11] = 0x25;
  strcpy(LINK->ext_lat[0x11], "\\ae ");
  LINK->char_set[0x12] = 0x1;
  LINK->char_code[0x12] = 0x24;
  strcpy(LINK->ext_lat[0x12], "\\AE ");
  LINK->char_set[0x13] = 0x1;
  LINK->char_code[0x13] = 0x3d;
  strcpy(LINK->ext_lat[0x13], "\\^{o}");
  LINK->char_set[0x14] = 0x1;
  LINK->char_code[0x14] = 0x3f;
  strcpy(LINK->ext_lat[0x14], "\\\"{o}");
  LINK->char_set[0x15] = 0x1;
  LINK->char_code[0x15] = 0x41;
  strcpy(LINK->ext_lat[0x15], "\\`{o}");
  LINK->char_set[0x16] = 0x1;
  LINK->char_code[0x16] = 0x45;
  strcpy(LINK->ext_lat[0x16], "\\^{u}");
  LINK->char_set[0x17] = 0x1;
  LINK->char_code[0x17] = 0x49;
  strcpy(LINK->ext_lat[0x17], "\\`{u}");
  LINK->char_set[0x18] = 0x1;
  LINK->char_code[0x18] = 0x8b;
  strcpy(LINK->ext_lat[0x18], "\\\"{y}");
  LINK->char_set[0x19] = 0x1;
  LINK->char_code[0x19] = 0x3e;
  strcpy(LINK->ext_lat[0x19], "\\\"{O}");
  LINK->char_set[0x1a] = 0x1;
  LINK->char_code[0x1a] = 0x46;
  strcpy(LINK->ext_lat[0x1a], "\\\"{U}");
  LINK->char_set[0x1b] = 0x4;
  LINK->char_code[0x1b] = 0x13;
  strcpy(LINK->ext_lat[0x1b], "\\ ");
  LINK->char_set[0x1c] = 0x4;
  LINK->char_code[0x1c] = 0xb;
  strcpy(LINK->ext_lat[0x1c], "\\pounds ");
  LINK->char_set[0x1d] = 0x4;
  LINK->char_code[0x1d] = 0xc;
  strcpy(LINK->ext_lat[0x1d], "\\ ");
  LINK->char_set[0x1e] = 0x4;
  LINK->char_code[0x1e] = 0xd;
  strcpy(LINK->ext_lat[0x1e], "\\ ");
  LINK->char_set[0x1f] = 0x4;
  LINK->char_code[0x1f] = 0xe;
  strcpy(LINK->ext_lat[0x1f], "{\\it f}\\/");
  LINK->char_set[0x20] = 0x1;
  LINK->char_code[0x20] = 0x1b;
  strcpy(LINK->ext_lat[0x20], "\\'{a}");
  LINK->char_set[0x21] = 0x1;
  LINK->char_code[0x21] = 0x31;
  strcpy(LINK->ext_lat[0x21], "\\'{\\i}");
  LINK->char_set[0x22] = 0x1;
  LINK->char_code[0x22] = 0x3b;
  strcpy(LINK->ext_lat[0x22], "\\'{o}");
  LINK->char_set[0x23] = 0x1;
  LINK->char_code[0x23] = 0x43;
  strcpy(LINK->ext_lat[0x23], "\\'{u}");
  LINK->char_set[0x24] = 0x1;
  LINK->char_code[0x24] = 0x39;
  strcpy(LINK->ext_lat[0x24], "\\~{n}");
  LINK->char_set[0x25] = 0x1;
  LINK->char_code[0x25] = 0x38;
  strcpy(LINK->ext_lat[0x25], "\\~{N}");
  LINK->char_set[0x26] = 0x4;
  LINK->char_code[0x26] = 0xf;
  strcpy(LINK->ext_lat[0x26], "\\astrike ");
  LINK->char_set[0x27] = 0x4;
  LINK->char_code[0x27] = 0x10;
  strcpy(LINK->ext_lat[0x27], "\\ostrike ");
  LINK->char_set[0x28] = 0x4;
  LINK->char_code[0x28] = 0x8;
  strcpy(LINK->ext_lat[0x28], "?`");
  LINK->char_set[0x29] = 0x5;
  LINK->char_code[0x29] = 0x10;
  strcpy(LINK->ext_lat[0x29], "~");
  LINK->char_set[0x2a] = 0x6;
  LINK->char_code[0x2a] = 0x14;
  strcpy(LINK->ext_lat[0x2a], "~");
  LINK->char_set[0x2b] = 0x4;
  LINK->char_code[0x2b] = 0x11;
  strcpy(LINK->ext_lat[0x2b], "$\\frac{1}{2}$");
  LINK->char_set[0x2c] = 0x4;
  LINK->char_code[0x2c] = 0x12;
  strcpy(LINK->ext_lat[0x2c], "$\\frac{1}{4}$");
  LINK->char_set[0x2d] = 0x4;
  LINK->char_code[0x2d] = 0x7;
  strcpy(LINK->ext_lat[0x2d], "!`");
  LINK->char_set[0x2e] = 0x4;
  LINK->char_code[0x2e] = 0x9;
  strcpy(LINK->ext_lat[0x2e], "$\\ll$");
  LINK->char_set[0x2f] = 0x4;
  LINK->char_code[0x2f] = 0xa;
  strcpy(LINK->ext_lat[0x2f], "$\\gg$");
  LINK->char_set[0x60] = 0x8;
  LINK->char_code[0x60] = 0x1;
  strcpy(LINK->ext_lat[0x60], "$\\alpha$");
  /*
  These are wrong
  LINK->char_set[0x61] = 0x1;
  LINK->char_code[0x61] = 0x17;
  They originally were used to detect beta
  */
  LINK->char_set[0x61] = 0x08;
  LINK->char_code[0x61] = 0x03;
  strcpy(LINK->ext_lat[0x61], "$\\beta$");
  LINK->char_set[0x62] = 0x8;
  LINK->char_code[0x62] = 0x6;
  strcpy(LINK->ext_lat[0x62], "$\\Gamma$");
  LINK->char_set[0x63] = 0x8;
  LINK->char_code[0x63] = 0x21;
  strcpy(LINK->ext_lat[0x63], "$\\pi$");
  LINK->char_set[0x64] = 0x8;
  LINK->char_code[0x64] = 0x24;
  strcpy(LINK->ext_lat[0x64], "$\\Sigma$");
  LINK->char_set[0x65] = 0x8;
  LINK->char_code[0x65] = 0x25;
  strcpy(LINK->ext_lat[0x65], "$\\sigma$");
  LINK->char_set[0x66] = 0x8;
  LINK->char_code[0x66] = 0x19;
  strcpy(LINK->ext_lat[0x66], "$\\mu$");
  LINK->char_set[0x67] = 0x8;
  LINK->char_code[0x67] = 0x29;
  strcpy(LINK->ext_lat[0x67], "$\\tau$");
  LINK->char_set[0x68] = 0x8;
  LINK->char_code[0x68] = 0x2c;
  strcpy(LINK->ext_lat[0x68], "$\\Phi$");
  LINK->char_set[0x69] = 0x8;
  LINK->char_code[0x69] = 0x10;
  strcpy(LINK->ext_lat[0x69], "$\\theta$");
  LINK->char_set[0x6a] = 0x8;
  LINK->char_code[0x6a] = 0x32;
  strcpy(LINK->ext_lat[0x6a], "$\\Omega$");
  LINK->char_set[0x6b] = 0x8;
  LINK->char_code[0x6b] = 0x9;
  strcpy(LINK->ext_lat[0x6b], "$\\delta$");
  LINK->char_set[0x6c] = 0x6;
  LINK->char_code[0x6c] = 0x13;
  strcpy(LINK->ext_lat[0x6c], "$\\infty$");
  LINK->char_set[0x6d] = 0x8;
  LINK->char_code[0x6d] = 0x2d;
  strcpy(LINK->ext_lat[0x6d], "$\\emptyset$");
  LINK->char_set[0x6e] = 0x8;
  LINK->char_code[0x6e] = 0xb;
  strcpy(LINK->ext_lat[0x6e], "$\\epsilon$");
  LINK->char_set[0x6f] = 0x6;
  LINK->char_code[0x6f] = 0x10;
  strcpy(LINK->ext_lat[0x6f], "$\\cap$");
  LINK->char_set[0x70] = 0x6;
  LINK->char_code[0x70] = 0xe;
  strcpy(LINK->ext_lat[0x70], "$\\equiv$");
  LINK->char_set[0x71] = 0x6;
  LINK->char_code[0x71] = 0x1;
  strcpy(LINK->ext_lat[0x71], "$\\pm$");
  LINK->char_set[0x72] = 0x6;
  LINK->char_code[0x72] = 0x3;
  strcpy(LINK->ext_lat[0x72], "$\\geq$");
  LINK->char_set[0x73] = 0x6;
  LINK->char_code[0x73] = 0x2;
  strcpy(LINK->ext_lat[0x73], "$\\leq$");
  LINK->char_set[0x74] = 0x7;
  LINK->char_code[0x74] = 0;
  strcpy(LINK->ext_lat[0x74], "~");
  LINK->char_set[0x75] = 0x7;
  LINK->char_code[0x75] = 0x1;
  strcpy(LINK->ext_lat[0x75], "~");
  LINK->char_set[0x76] = 0x6;
  LINK->char_code[0x76] = 0x8;
  strcpy(LINK->ext_lat[0x76], "$\\div$");
  LINK->char_set[0x77] = 0x6;
  LINK->char_code[0x77] = 0xd;
  strcpy(LINK->ext_lat[0x77], "$\\approx$");
  LINK->char_set[0x78] = 0x6;
  LINK->char_code[0x78] = 0x24;
  strcpy(LINK->ext_lat[0x78], "\\degrees ");
  LINK->char_set[0x79] = 0x6;
  LINK->char_code[0x79] = 0x1f;
  strcpy(LINK->ext_lat[0x79], "~");
  LINK->char_set[0x7a] = 0x6;
  LINK->char_code[0x7a] = 0x20;
  strcpy(LINK->ext_lat[0x7a], "~");
  LINK->char_set[0x7b] = 0x7;
  LINK->char_code[0x7b] = 0x4;
  strcpy(LINK->ext_lat[0x7b], "$\\surd$");
  LINK->char_set[0x7c] = 0x4;
  LINK->char_code[0x7c] = 0x15;
  strcpy(LINK->ext_lat[0x7c], "$^{n}$");
  LINK->char_set[0x7d] = 0x4;
  LINK->char_code[0x7d] = 0x14;
  strcpy(LINK->ext_lat[0x7d], "$^{2}$");
  LINK->char_set[0x7e] = 0x4;
  LINK->char_code[0x7e] = 0x2;
  strcpy(LINK->ext_lat[0x7e], "~");
/*
** Note: Adding characters is easy. The maximum available is
** now 256 not 128 (Pascal version).
** e.g. The Greek character set is char_set 0x8,
** \Alpha has char_code 0x0, \alpha has char_code 0x1 ...
** \Omega has char_code 0x32 and \omega has char_code 0x33
** I suspect that there are two versions of some letters
** I've only added the ones I've needed for translating.
** Hence the apparent randomness.
*/
  LINK->char_set[0x7f] = 0x8;
  LINK->char_code[0x7f] = 0x15;
  strcpy(LINK->ext_lat[0x7f], "$\\kappa$");
  LINK->char_set[0x80] = 0x8;
  LINK->char_code[0x80] = 0x8;
  strcpy(LINK->ext_lat[0x80], "$\\Delta$");
  LINK->char_set[0x81] = 0x8;
  LINK->char_code[0x81] = 0xf;
  strcpy(LINK->ext_lat[0x81], "$\\eta$");
  LINK->char_set[0x82] = 0x8;
  LINK->char_code[0x82] = 0x27;
  strcpy(LINK->ext_lat[0x82], "$\\zeta$");
  LINK->char_set[0x83] = 0x06;
  LINK->char_code[0x83] = 0x0a;
  strcpy(LINK->ext_lat[0x83], "$<$");
  LINK->char_set[0x84] = 0x06;
  LINK->char_code[0x84] = 0x09;
  strcpy(LINK->ext_lat[0x84], "$|$");
  LINK->char_set[0x85] = 0x8;
  LINK->char_code[0x85] = 0x7;
  strcpy(LINK->ext_lat[0x85], "$\\gamma$");
  LINK->char_set[0x86] = 0x8;
  LINK->char_code[0x86] = 0x2b;
  strcpy(LINK->ext_lat[0x86], "$\\phi$");
  LINK->char_set[0x87] = 0x6;
  LINK->char_code[0x87] = 0x27;
  strcpy(LINK->ext_lat[0x87], "$\\times$");
  LINK->char_set[0x88] = 0x6;
  LINK->char_code[0x88] = 0x28;
  strcpy(LINK->ext_lat[0x88], "$\\int$");
  LINK->char_set[0x89] = 0x8;
  LINK->char_code[0x89] = 0x31;
  strcpy(LINK->ext_lat[0x89], "$\\psi$");
  LINK->char_set[0x8a] = 0x6;
  LINK->char_code[0x8a] = 0xb;
  strcpy(LINK->ext_lat[0x8a], "$>$");
  LINK->char_set[0x8b] = 0x8;
  LINK->char_code[0x8b] = 0x2f;
  strcpy(LINK->ext_lat[0x8b], "$\\chi$");
  LINK->char_set[0x8c] = 0x6;
  LINK->char_code[0x8c] = 0x17;
  strcpy(LINK->ext_lat[0x8c], "$\\uparrow$");
  LINK->char_set[0x8d] = 0x6;
  LINK->char_code[0x8d] = 0x15;
  strcpy(LINK->ext_lat[0x8d], "$\\rightarrow$");
  LINK->char_set[0x8e] = 0x8;
  LINK->char_code[0x8e] = 0x17;
  strcpy(LINK->ext_lat[0x8e], "$\\lambda$");
  LINK->char_set[0x8f] = 0x8;
  LINK->char_code[0x8f] = 0x33;
  strcpy(LINK->ext_lat[0x8f], "$\\omega$");
  LINK->char_set[0x90] = 0x6;
  LINK->char_code[0x90] = 0x2b;
  strcpy(LINK->ext_lat[0x90], "$\\nabla$");
}


Local Void Make_tabelentry_attr(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar num_of_attr;
  short j;

  num_of_attr = LINK->openptr[LINK->depth];
  fwrite(&num_of_attr, sizeof(uchar), 1, tabel);

  for (j = 1; j <= num_of_attr; j++)
    fwrite(&LINK->attr_rij[LINK->depth][j], sizeof(uchar), 1, tabel);

}



Local Void Make_tabelentry_tabset(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar b;
  short j, FORLIM;

  b = 'S';
  fwrite(&b, sizeof(uchar), 1, tabel);

  b = LINK->num_of_tabs;
  fwrite(&b, sizeof(uchar), 1, tabel);

  FORLIM = LINK->num_of_tabs;
  for (j = 0; j < FORLIM; j++)
    Wr_word(&tabel, LINK->tabpos[j]);
}


Local Void Make_tabelentry_rightjustification(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar b;

  b = 'U';
  fwrite(&b, sizeof(uchar), 1, tabel);

  if (LINK->by == 0x81)   /* regels NIET uitvullen */
    b = 1;   /* regels WEL uitvullen */
  else
    b = 0;
  fwrite(&b, sizeof(uchar), 1, tabel);
}




Local Void Make_tabelentry_envir_extra_end(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar b;


  switch (LINK->envir) {

  case 'C':
    b = 'C';
    fwrite(&b, sizeof(uchar), 1, tabel);
    break;

  case 'T':
    b = 'T';
    fwrite(&b, sizeof(uchar), 1, tabel);
    break;

  case 'I':
    b = 'I';
    fwrite(&b, sizeof(uchar), 1, tabel);
    Wr_word(&tabel, LINK->ind_leftmargin);
    Wr_word(&tabel, LINK->ind_rightmargin);

    if (LINK->ind_text2) {
      b = 1;
      fwrite(&b, sizeof(uchar), 1, tabel);
    } else {
      b = 0;
      fwrite(&b, sizeof(uchar), 1, tabel);
    }

    break;

  }/*Case*/

  b = LINK->line_term;
  fwrite(&b, sizeof(uchar), 1, tabel);

  b = 0xff;
  fwrite(&b, sizeof(uchar), 1, tabel);

}


Local Void Reset_attr_rij(d, LINK)
short d;
struct LOC_Convert_first_strike *LINK;
{
  short j;

  for (j = 0; j <= 16; j++)
    LINK->attr_rij[d][j] = 0;
  LINK->leegptr[d] = 1;
  LINK->openptr[d] = 0;
}



Local Void Open_all_attr(LINK)
struct LOC_Convert_first_strike *LINK;
{
  /* -- Open alle commando's door de Attributen-rij af te lopen -- */
  short j, FORLIM;

  FORLIM = LINK->leegptr[LINK->depth];
  for (j = LINK->openptr[LINK->depth] + 1; j < FORLIM; j++) {
    fputs(open_com[LINK->attr_rij[LINK->depth][j]], strip);
    LINK->openptr[LINK->depth]++;
  }

  LINK->open_attr_rij[LINK->depth] = false;
      /* Alle attributen staan weer goed */
}



Local Void Close_all_attr(LINK)
struct LOC_Convert_first_strike *LINK;
{
  /* -- Sluit alle commando's door de Attributen-rij af te lopen -- */
  short j;

  for (j = LINK->openptr[LINK->depth]; j >= 1; j--) {
    fputs(close_com[LINK->attr_rij[LINK->depth][j]], strip);
    LINK->openptr[LINK->depth]--;
  }
  LINK->open_attr_rij[LINK->depth] = true;
}



Local Void Attr_ON(LINK)
struct LOC_Convert_first_strike *LINK;
{
  /* Deze procedure plaatst een attribuut (lettertype) in de attribuut-rij */
  uchar b;

  fread(&b, sizeof(uchar), 1, wpd);   /* lees attribuut-code */

  LINK->attr_rij[LINK->depth][LINK->leegptr[LINK->depth]] = b;
      /* attribuut in attr-rij */
  LINK->leegptr[LINK->depth]++;   /* plaats 1 verder. */
  LINK->open_attr_rij[LINK->depth] = true;   /* openstaande attr-rij */

  fread(&b, sizeof(uchar), 1, wpd);   /* lees voorbij afsluitcode */
}



Local Void Attr_OFF(LINK)
struct LOC_Convert_first_strike *LINK;
{
  /* Deze procedure haalt een uit een attribuut (lettertype) uit de */
  /* attribuut-rij door middel van een stack principe omdat binnen  */
  /* LaTeX de later geopende kommando's eerst afgesloten te worden  */
  uchar b;
  boolean found;
  short j, codeptr, FORLIM;

  fread(&b, sizeof(uchar), 1, wpd);   /* lees attribuut-code */

  j = LINK->leegptr[LINK->depth];   /* zoek vanaf top attr-rij */
  found = false;   /* nog niet gevonden */

  while (j > 1 && !found) {   /* zoek attr-code in attr-rij */
    j--;
    found = (LINK->attr_rij[LINK->depth][j] == b);
  }

  if (j <= 0) {   /* Moet nooit kunnen voorkomen */
    RunError(0x100);
  }
  codeptr = j;   /* plaats van attr-code in rij */

  /* Sluit alle commando's t/m de desbetreffende code als deze nog niet */
  /* gesloten zijn.                                                     */

  if (codeptr <= LINK->openptr[LINK->depth]) {
    for (j = LINK->openptr[LINK->depth]; j >= codeptr; j--) {
      fputs(close_com[LINK->attr_rij[LINK->depth][j]], strip);
      LINK->openptr[LINK->depth]--;
    }
  }

  FORLIM = LINK->leegptr[LINK->depth];
  /* Haal de desbetreffende attribuut uit de rij en werk pointers bij */

  for (j = codeptr; j < FORLIM; j++)
    LINK->attr_rij[LINK->depth][j] = LINK->attr_rij[LINK->depth][j + 1];
  LINK->leegptr[LINK->depth]--;

  LINK->open_attr_rij[LINK->depth] = true;   /* openstaande attr-rij */

  fread(&b, sizeof(uchar), 1, wpd);   /* lees voorbij afsluitcode */
}



Local Void Center(LINK)
struct LOC_Convert_first_strike *LINK;
{
  /* Deze procedure zorgt voor center environment zolang er nog geen */
  /* andere environment is begonnen.                                 */
  if (LINK->envir == ' ')   /* environment = center */
    LINK->envir = 'C';

  Jump_in_file(&wpd, 7L);   /* rest van code overslaan */
}



Local Void End_Align(LINK)
struct LOC_Convert_first_strike *LINK;
{
  if (LINK->align_tab) {
    Close_all_attr(LINK);
    fprintf(strip, "\\'");
    LINK->align_tab = false;
    Open_all_attr(LINK);
  }

  if (LINK->right_tab) {
    Close_all_attr(LINK);
    fprintf(strip, "\\'");
    LINK->right_tab = false;
    Open_all_attr(LINK);
  }

  if (!LINK->center_tab)
    return;
  Close_all_attr(LINK);
  putc('}', strip);
  LINK->center_tab = false;
  Open_all_attr(LINK);
}



Local Void Tab(LINK)
struct LOC_Convert_first_strike *LINK;
{
  short j;
  unsigned short wpu;
  short tabnum, new_tabs, FORLIM;

  if (LINK->envir == 'I' || LINK->nomore_valid_tabs)
  {   /* Noggeen indent --> normaal tab */
    Jump_in_file(&wpd, 7L);
    return;
  }


  if (LINK->by == 0x48)
    LINK->right_tab = true;

  if (LINK->by == 0x40)
    LINK->align_tab = true;

  if (LINK->by == 0xc8)
    LINK->center_tab = true;

  Jump_in_file(&wpd, 2L);

  Rd_word(&wpd, &wpu);   /* Lees abs.-indent [wpu] */
  wpu -= LINK->WP_sidemargin;   /* Correctie ivm WP kantlijn */

  tabnum = 0;
  FORLIM = LINK->num_of_tabs;
  for (j = 1; j <= FORLIM; j++) {   /* Bepaal welke tabpos */
    if (wpu >= LINK->tabpos[j - 1])
      tabnum = j;
  }

  new_tabs = tabnum - LINK->latex_tabpos;

  if (new_tabs > 0) {
    Close_all_attr(LINK);

    for (j = 1; j <= new_tabs; j++)
      fprintf(strip, "\\>");

    if (LINK->center_tab)
      fprintf(strip, "\\ctab{");

    Open_all_attr(LINK);
  }

  LINK->latex_tabpos = tabnum;

  Jump_in_file(&wpd, 3L);

  LINK->envir = 'T';   /* Er zit een tab in deze regel */
}



Local Void Flush_right_tab(LINK)
struct LOC_Convert_first_strike *LINK;
{
  if (LINK->envir != 'I') {
    Close_all_attr(LINK);
    fprintf(strip, "\\`");
    Open_all_attr(LINK);

    LINK->nomore_valid_tabs = true;

    LINK->envir = 'T';
  }

  Jump_in_file(&wpd, 7L);
}



Local Void Indent(LINK)
struct LOC_Convert_first_strike *LINK;
{
  unsigned short dif, abs;
  uchar b;

  if (LINK->envir == 'T') {
	/*Al een tabcommando gezet dus er mag geen insp */
	  Jump_in_file(&wpd, 10L);
    return;
  }
  LINK->envir = 'I';
  LINK->indenting = true;

  if (LINK->ind_text2) {
    Jump_in_file(&wpd, 10L);
    return;
  }
  fread(&b, sizeof(uchar), 1, wpd);
  b &= 0x1;

  Rd_word(&wpd, &dif);
  Rd_word(&wpd, &abs);   /* Eigenlijk Old current column */
  Rd_word(&wpd, &abs);

  LINK->ind_leftmargin = abs - LINK->WP_sidemargin;

  if (b == 1)
    LINK->ind_rightmargin += dif;
  /*Margins bepaald lees voorby rest van functie-codes */
  Jump_in_file(&wpd, 3L);

  if (LINK->ind_text1)
    return;
  if (LINK->char_on_line) {
    putc('}', strip);
    LINK->ind_text1 = true;
  }
}


Local Void End_of_indent(LINK)
struct LOC_Convert_first_strike *LINK;
{
  LINK->indent_end = true;
  Jump_in_file(&wpd, 5L);
}



Local Void Tabset(LINK)
struct LOC_Convert_first_strike *LINK;
{
  short j;
  unsigned short w;

  Jump_in_file(&wpd, 102L);   /* Ga naar TAB-info */

  LINK->num_of_tabs = 0;

  for (j = 1; j <= 40; j++) {
    Rd_word(&wpd, &w);
    if (w > LINK->WP_sidemargin && w != 0xffffL) {
      LINK->num_of_tabs++;
      LINK->tabpos[LINK->num_of_tabs - 1] = w - LINK->WP_sidemargin;
    }
  }

  Jump_in_file(&wpd, 24L);

  Make_tabelentry_tabset(LINK);
}



Local Void Page_number_position(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar position_code;

  Jump_in_file(&wpd, 5L);   /*Skip length of code; always 10*/
  /* + old information */
  fread(&position_code, sizeof(uchar), 1, wpd);

  fprintf(strip, "\\pagenumpos");
  switch (position_code) {

  case 0x1:
    fprintf(strip, "{\\pntl}");
    break;

  case 0x2:
    fprintf(strip, "{\\pntc}");
    break;

  case 0x3:
    fprintf(strip, "{\\pntr}");
    break;

  case 0x5:
    fprintf(strip, "{\\pnbl}");
    break;

  case 0x6:
    fprintf(strip, "{\\pnbc}");
    break;

  case 0x7:
    fprintf(strip, "{\\pnbr}");
    break;

  default:
    fprintf(strip, "{\\pnno}");
    break;
  }

  Jump_in_file(&wpd, 6L);
}



Local Void Character(LINK)
struct LOC_Convert_first_strike *LINK;
{
  Char ch[256];

  short j;
  uchar chr_code, chr_set, b;
  boolean found;

#ifdef DEBUG
	fprintf(stderr, "Called Character with LINK->by = 0x%x\n",LINK->by);
#endif

  if (LINK->open_attr_rij[LINK->depth])
    Open_all_attr(LINK);

  switch (LINK->by) {

  case 0xc4:
#ifdef DEBUG
	fprintf(stderr, "Character got 0x%x\n", LINK->by);
#endif
	fprintf(stderr, "detected special attr\n");
	break;

  case 0xa9:   /* Special_char */
#ifdef DEBUG
	fprintf(stderr, "Character got 0x%x\n", LINK->by);
#endif
    if (LINK->by == 0xa9)
      strcpy(ch, "-");
    else
      strcpy(ch, "\\ ");
    break;

  case 0xc0:   /* Extended_char */
#ifdef DEBUG
	fprintf(stderr, "Character got 0x%x\n", LINK->by);
#endif
    j = 127;
    found = false;

    fread(&chr_code, sizeof(uchar), 1, wpd);
    fread(&chr_set, sizeof(uchar), 1, wpd);

    while (j < 511 && !found) {
      j++;
      if (chr_code == LINK->char_code[j - 0x80] &&
	  chr_set == LINK->char_set[j - 0x80])
	found = true;
    }

    if (found)
      strcpy(ch, LINK->ext_lat[j - 0x80]);
    else
      strcpy(ch, "\\ ");

    fread(&b, sizeof(uchar), 1, wpd);
    break;

  default:
    if (LINK->by >= 0x20 && LINK->by <= 0x7f) {
      /* Normal_char  */
      strcpy(ch, LINK->lat[LINK->by - 0x20]);
    }

    break;
  }

  fputs(ch, strip);

}



Local Void Return_Page(LINK)
struct LOC_Convert_first_strike *LINK;
{
  switch (LINK->by) {

  case 0x0a:
  case 0x8c:   /* Hard return */
    LINK->line_term = 'R';
    break;

  case 0x0d:   /* Soft return */
    LINK->line_term = 'r';
    break;

  case 0xc:   /* Hard page */
    LINK->line_term = 'P';
    break;

  case 0xb:   /* Soft page */
    LINK->line_term = 'p';
    break;
  }

  putc('\n', strip);

  Make_tabelentry_envir_extra_end(LINK);

  if (LINK->indent_end) {
    LINK->envir = ' ';
    LINK->indenting = false;
    LINK->ind_text1 = false;
    LINK->ind_text2 = false;
    LINK->ind_leftmargin = 0;
    LINK->ind_rightmargin = 0;

    LINK->indent_end = false;
  } else if (LINK->envir != 'I')
    LINK->envir = ' ';


  LINK->char_on_line = false;
  LINK->nomore_valid_tabs = false;

  LINK->regelnum++;

  Make_tabelentry_attr(LINK);

  LINK->latex_tabpos = 0;
}


Local Void Nop80(LINK)
struct LOC_Convert_first_strike *LINK;
{
  /* Om dat het een 1-byte funktie is hoeft er niks overgeslagen */
  /* te worden.                                                  */
}



Local Void NopC0(LINK)
struct LOC_Convert_first_strike *LINK;
{
#ifdef DEBUG
	fprintf(stderr, "NopC0 called with LINK->by = 0x%x\n", LINK->by);
#endif
  if (LINK->by == 0xc0)
    Jump_in_file(&wpd, 3L);
  if (LINK->by == 0xc1)
    Jump_in_file(&wpd, 8L);
  if (LINK->by == 0xc2)
    Jump_in_file(&wpd, 10L);
  if (LINK->by == 0xc3)
    Jump_in_file(&wpd, 2L);
  if (LINK->by == 0xc4)
    Jump_in_file(&wpd, 2L);
  if (LINK->by == 0xc5)
    Jump_in_file(&wpd, 4L);
  if (LINK->by == 0xc6)
    Jump_in_file(&wpd, 5L);
  if (LINK->by == 0xc7)
    Jump_in_file(&wpd, 6L);
}



Local Void NopD0(already_read_subfunc_code, LINK)
boolean already_read_subfunc_code;
struct LOC_Convert_first_strike *LINK;
{
  uchar b;
  unsigned short w;

  if (!already_read_subfunc_code)   /* Lees subfunctioncode */
    fread(&b, sizeof(uchar), 1, wpd);

  Rd_word(&wpd, &w);   /* Lees lengte 'die nog volgt ' */
  fseek(wpd, (ftell(wpd) / sizeof(uchar) + w) * sizeof(uchar), 0);
}



Local Void Overstrike(LINK)
struct LOC_Convert_first_strike *LINK;
{
  boolean first_char_os;

  unsigned short char_width_os, len_of_code;
  long end_of_code;

#ifdef DEBUG
	fprintf(stderr, "Called Overstrike\n");
#endif

  Rd_word(&wpd, &len_of_code);   /* Lees lengte */
  end_of_code = ftell(wpd) / sizeof(uchar) + len_of_code - 4;

  Rd_word(&wpd, &char_width_os);

  first_char_os = true;

  while (ftell(wpd) / sizeof(uchar) < end_of_code) {
    fread(&LINK->by, sizeof(uchar), 1, wpd);


    if (LINK->by >= 0x20 && LINK->by <= 0x7f || LINK->by == 0xa9 ||
	LINK->by == 0xc0 || LINK->by == 0xc4) {
#ifdef DEBUG
	fprintf(stderr, "Overstrike got 0x%x\n", LINK->by);
#endif
      if (first_char_os) {
	Character(LINK);
	first_char_os = false;
      } else {
	fprintf(strip, "\\llap{");
	Character(LINK);
	putc('}', strip);
      }
      continue;
    }

    if (LINK->by <= 0xbf)
      Nop80(LINK);
    else if (LINK->by >= 0xc0 && LINK->by <= 0xcf)
      NopC0(LINK);
    else if (LINK->by >= 0xd0 && LINK->by <= 0xfe)
      NopD0(false, LINK);
  }

  Jump_in_file(&wpd, 4L);

}



Local Void Footnote(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar flags, num_of_pages;

  unsigned short fn_num, len_of_code;
  long end_of_code;

  Rd_word(&wpd, &len_of_code);   /* Lees lengte */
  end_of_code = ftell(wpd) / sizeof(uchar) + len_of_code - 4;

  fread(&flags, sizeof(uchar), 1, wpd);

  Rd_word(&wpd, &fn_num);

  /* Skip all the shit */

  fread(&num_of_pages, sizeof(uchar), 1, wpd);
  Jump_in_file(&wpd, (num_of_pages + 1L) * 2 + 9);

  Close_all_attr(LINK);

  LINK->depth = 1;
  Reset_attr_rij(LINK->depth, LINK);

  fprintf(strip, "\\footnote[%u]{", fn_num);

  while (ftell(wpd) / sizeof(uchar) < end_of_code) {
    fread(&LINK->by, sizeof(uchar), 1, wpd);

    switch (LINK->by) {

    case 0xa:
    case 0xc:
      fprintf(strip, "\\\\ ");
      break;

    case 0xb:
    case 0xd:
      putc(' ', strip);
      break;

    case 0xc3:
      Attr_ON(LINK);
      break;

    case 0xc4:
      Attr_OFF(LINK);
      break;

    default:
#ifdef DEBUG
	fprintf(stderr, "defaulting\n");
#endif
      if (LINK->by >= 0x20 && LINK->by <= 0x7f || LINK->by == 0xa9 ||
	  LINK->by == 0xc0 || LINK->by == 0xc4)
	Character(LINK);
      else if (LINK->by <= 0xbf)
	Nop80(LINK);
      else if (LINK->by >= 0xc0 && LINK->by <= 0xcf)
	NopC0(LINK);
      else if (LINK->by >= 0xd0 && LINK->by <= 0xfe)
	NopD0(false, LINK);

      break;
    }

  }

  Close_all_attr(LINK);   /* Echt nodig ? */
  putc('}', strip);

  Jump_in_file(&wpd, 4L);

  LINK->depth = 0;
  Open_all_attr(LINK);

}



Local Void Header_Footer(LINK)
struct LOC_Convert_first_strike *LINK;
{
  uchar subfunc, occurance;
  unsigned short len_of_code;
  long end_of_code;

  boolean hf_left, hf_center, hf_right;

  short j;

  fread(&subfunc, sizeof(uchar), 1, wpd);
  Rd_word(&wpd, &len_of_code);

  if (len_of_code <= 22) {
    Jump_in_file(&wpd, (long)len_of_code);
    return;
  }


  end_of_code = ftell(wpd) / sizeof(uchar) + len_of_code - 4;

  Jump_in_file(&wpd, 7L);

  fread(&occurance, sizeof(uchar), 1, wpd);

  Jump_in_file(&wpd, 10L);

  Close_all_attr(LINK);
  LINK->depth = 1;

  /* Geen schone attr._lei; Kopieer attributen uit Niveau 0;  Fout in WP 5.0 ? */

  for (j = 0; j <= 15; j++)
    LINK->attr_rij[1][j] = LINK->attr_rij[0][j];

  LINK->leegptr[1] = LINK->leegptr[0];
  LINK->openptr[1] = LINK->openptr[0];

  switch (subfunc) {

  case 0:
  case 1:
    fprintf(strip, "\\headtext");
    break;

  case 2:
  case 3:
    fprintf(strip, "\\foottext");
    break;
  }

  switch (occurance) {

  case 0:
    fprintf(strip, "{\\neverpages}{");
    break;

  case 1:
    fprintf(strip, "{\\allpages}{");
    break;

  case 2:
    fprintf(strip, "{\\oddpages}{");
    break;

  case 3:
    fprintf(strip, "{\\evenpages}{");
    break;
  }

  Open_all_attr(LINK);
  hf_left = true;   /* Beginnen met de linkerkant */
  hf_center = false;
  hf_right = false;

  while (ftell(wpd) / sizeof(uchar) < end_of_code) {
    fread(&LINK->by, sizeof(uchar), 1, wpd);

    switch (LINK->by) {

    case 0xc1:
      fread(&LINK->by, sizeof(uchar), 1, wpd);
      LINK->by &= 0xe0;
      Jump_in_file(&wpd, 7L);

      if (LINK->by == 0xe0) {
	if (hf_left) {
	  Close_all_attr(LINK);
	  fprintf(strip, "}{");
	  Open_all_attr(LINK);

	  hf_left = false;
	  hf_center = true;
	}
      }

      if (LINK->by == 0x60) {
	if (hf_left) {
	  Close_all_attr(LINK);
	  fprintf(strip, "}{}{");
	  Open_all_attr(LINK);

	  hf_left = false;
	  hf_right = true;
	}

	if (hf_center) {
	  Close_all_attr(LINK);
	  fprintf(strip, "}{");
	  Open_all_attr(LINK);

	  hf_center = false;
	  hf_right = true;
	}
      }
      break;

    case 0xc3:
      Attr_ON(LINK);
      break;

#ifndef DEBUG
    case 0xc4:
      Attr_OFF(LINK);
      break;
#endif

    default:
      if (LINK->by >= 0x20 && LINK->by <= 0x7f || LINK->by == 0xa9 ||
	  LINK->by == 0xc0 || LINK->by == 0xc4)
	Character(LINK);
      else if (LINK->by <= 0xbf)
	Nop80(LINK);
      else if (LINK->by >= 0xc0 && LINK->by <= 0xcf)
	NopC0(LINK);
      else if (LINK->by >= 0xd0 && LINK->by <= 0xfe)
	NopD0(false, LINK);


      break;
    }
  }

  Close_all_attr(LINK);   /* Echt nodig ? */

  Jump_in_file(&wpd, 4L);

  if (hf_left)
    fprintf(strip, "}{}{}");
  if (hf_center)
    fprintf(strip, "}{}");
  if (hf_right)
    putc('}', strip);

  LINK->depth = 0;
  Open_all_attr(LINK);



}


/*---SLAG1----*/

Static Void Convert_first_strike()
{
  /* Dit is de komplete procedure van de eerste slag met zijn eigen proc.'s. */
  struct LOC_Convert_first_strike V;

  short convperc;

  long srtdocpos, fsize;


  Table_Init(&V);
  Ext_chr_init(&V);

  Reset_attr_rij(0, &V);
  Reset_attr_rij(1, &V);
  V.depth = 0;

  WP_Default(&V);

  V.latex_tabpos = 0;
  V.right_tab = false;
  V.align_tab = false;
  V.center_tab = false;

  V.indenting = false;
  V.indent_end = false;
  V.ind_text1 = false;
  V.ind_text2 = false;
  V.ind_leftmargin = 0;
  V.ind_rightmargin = 0;

  V.envir = ' ';

  V.nomore_valid_tabs = false;

  printf("First strike :\n");
#ifndef sun
  printf("Converting-percentage :     ");
#endif

  srtdocpos = ftell(wpd) / sizeof(uchar);
  fsize = P_maxpos(wpd) / sizeof(uchar) + 1;

  V.regelnum = 0;

  Make_tabelentry_attr(&V);   /* attribuut instelling */

  Make_tabelentry_tabset(&V);   /* Geef de defaulttabinstelling door */
  /* aan de 2e slag */

  while (ftell(wpd) / sizeof(uchar) < fsize-2) {
#ifndef sun
    convperc = (long)floor((double)(ftell(wpd) / sizeof(uchar) - srtdocpos) /
			   (fsize - srtdocpos) * 100 + 0.5);
    printf("\b\b\b\b%3d%%", convperc);
#endif

    fread(&V.by, sizeof(uchar), 1, wpd);

    switch (V.by) {

    case 0xa:
    case 0xd:
    case 0xb:
    case 0xc:
    case 0x8c:
      Return_Page(&V);
      break;

    case 0xc1:
      fread(&V.by, sizeof(uchar), 1, wpd);
      V.by &= 0xe8;

      switch (V.by) {

      case 0:
      case 0xc8:
      case 0x48:
      case 0x40:
	Tab(&V);
	break;

      case 0x60:
	Flush_right_tab(&V);
	break;

      case 0xe0:
	Center(&V);
	break;

      default:
	Jump_in_file(&wpd, 7L);
	break;
      }
      break;

    case 0x81:
    case 0x82:
      Make_tabelentry_rightjustification(&V);
      break;

    case 0x83:
      End_Align(&V);
      break;

    case 0xc3:
      Attr_ON(&V);
      break;

    case 0xc4:
      Attr_OFF(&V);
      break;

    case 0xc2:
      Indent(&V);
      break;

    case 0xc6:
      End_of_indent(&V);
      break;

    case 0xc5:
    case 0xc7:
      NopC0(&V);
      break;

    case 0xd0:
      fread(&V.by, sizeof(uchar), 1, wpd);
      switch (V.by) {

      case 0x4:
	Tabset(&V);
	break;

      case 0x8:
	Page_number_position(&V);
	break;

      default:
	NopD0(true, &V);
	break;
      }
      break;

    case 0xd5:
      Header_Footer(&V);
      break;

    case 0xd6:
      fread(&V.by, sizeof(uchar), 1, wpd);
      switch (V.by) {

      case 0:
	Footnote(&V);
	break;

      default:
	NopD0(true, &V);
	break;
      }
      break;

    case 0xd8:
      fread(&V.by, sizeof(uchar), 1, wpd);
      switch (V.by) {

      case 0x2:
	Overstrike(&V);
	break;

      default:
	NopD0(true, &V);
	break;
      }
      break;

    default:
      if (V.by >= 0x20 && V.by <= 0x7f || V.by == 0xa9 
	|| V.by == 0xc0 || V.by == 0xc4) {
	V.char_on_line = true;   /*Er (al) is een karakter op deze regel */
	if (V.indenting) {   /*Als er is ingeprongen er na een stuk */
	  if (V.ind_text1)   /*tekst is weer ingesprongen (ind_text1) */
	    V.ind_text2 = true;
	}
	/*dan hoort dit char bij het ind_txt-blok */

	Character(&V);
      } else if (V.by <= 0x1f || V.by >= 0x80 && V.by <= 0xbf)
	Nop80(&V);
      else if (V.by >= 0xd0 && V.by <= 0xff)
	NopD0(false, &V);

      break;
    }
  }

  putchar('\n');
  Make_tabelentry_envir_extra_end(&V);

  num_of_lines_stripfile = V.regelnum;




}


/* Local variables for Convert_second_strike: */
struct LOC_Convert_second_strike {
  boolean just_envir_closed;

  short num_of_tabs;
  unsigned short tabpos[40];

  short tabent_num_of_tabs[3];
  unsigned short tabent_tabpos[3][40];

  unsigned short ind_leftmargin[3], ind_rightmargin[3];
  uchar ind_label[3];

  short pre, cur, next;

  Char envir[3], line_term[3];
  boolean new_tabset[3];
  boolean new_rightjust;
  boolean new_tabent_rightjust[3], tabent_rightjust[3];

  short num_of_attr[3];
  uchar attr_BOL[3][0x11];
  boolean attr_closed;
} ;



Local Void Read_tabelentry(n, LINK)
short n;
struct LOC_Convert_second_strike *LINK;
{
  unsigned short w;
  uchar b;
  short j, FORLIM;

  /* Begin met een schone lei die dan door deze procedure verder wordt */
  /* opgevuld. */

  LINK->envir[n] = ' ';
  LINK->new_tabset[n] = false;
  LINK->new_tabent_rightjust[n] = false;

  LINK->num_of_attr[n] = 0;
  for (j = 1; j <= 16; j++)
    LINK->attr_BOL[n][j] = 0;

  if (ftell(tabel) / sizeof(uchar) > P_maxpos(tabel) / sizeof(uchar))
    return;


  /* Er is geen volgende tabelentry dus ook geen volgende regel */
  /* De tabelentry is 'schoon'.                                 */
  /* Zodat het document 'schoon' wordt afgesloten.              */

  fread(&b, sizeof(uchar), 1, tabel);
  LINK->num_of_attr[n] = b;
  FORLIM = LINK->num_of_attr[n];
  for (j = 1; j <= FORLIM; j++)
    fread(&LINK->attr_BOL[n][j], sizeof(uchar), 1, tabel);

  b = 0;
  while ((b != 0xff) && !feof(tabel)) {
    fread(&b, sizeof(uchar), 1, tabel);

    switch (b) {   /*Case*/

    case 'C':
      LINK->envir[n] = 'C';
      break;

    case 'T':
      LINK->envir[n] = 'T';
      break;

    case 'I':
      LINK->envir[n] = 'I';
      Rd_word(&tabel, &LINK->ind_leftmargin[n]);
      Rd_word(&tabel, &LINK->ind_rightmargin[n]);
      fread(&LINK->ind_label[n], sizeof(uchar), 1, tabel);
      break;

    case 'S':
      LINK->new_tabset[n] = true;
      fread(&b, sizeof(uchar), 1, tabel);
      LINK->tabent_num_of_tabs[n] = b;

      FORLIM = LINK->tabent_num_of_tabs[n];
      for (j = 0; j < FORLIM; j++) {
	Rd_word(&tabel, &w);
	LINK->tabent_tabpos[n][j] = w;
      }
      break;

    case 'U':
      LINK->new_tabent_rightjust[n] = true;
      fread(&b, sizeof(uchar), 1, tabel);
      if (b == 0)
	LINK->tabent_rightjust[n] = false;
      else
	LINK->tabent_rightjust[n] = true;
      break;

    case 'R':
    case 'r':
    case 'P':
    case 'p':
      LINK->line_term[n] = b;
      break;

    }
  }
}



Local Void Open_all_attr_BOL(LINK)
struct LOC_Convert_second_strike *LINK;
{
  /* -- Open alle commando's door de Attributen-rij af te lopen -- */
  short j, FORLIM;

  FORLIM = LINK->num_of_attr[LINK->cur];
  for (j = 0x1; j <= FORLIM; j++)
    fputs(open_com[LINK->attr_BOL[LINK->cur][j]], latex);

  LINK->attr_closed = false;
}


Local Void Close_all_attr_BOL(LINK)
struct LOC_Convert_second_strike *LINK;
{
  /* -- Sluit alle commando's door de Attributen-rij af te lopen -- */
  short j;

  for (j = LINK->num_of_attr[LINK->cur]; j >= 0x1; j--)
    fputs(close_com[LINK->attr_BOL[LINK->cur][j]], latex);

  LINK->attr_closed = true;
}



Local Void Open_all_attr_EOL(LINK)
struct LOC_Convert_second_strike *LINK;
{
  /* -- Open alle commando's door de Attributen-rij af te lopen -- */
  short j, FORLIM;

  FORLIM = LINK->num_of_attr[LINK->next];
  for (j = 0x1; j <= FORLIM; j++)
    fputs(open_com[LINK->attr_BOL[LINK->next][j]], latex);

  LINK->attr_closed = false;
}



Local Void Close_all_attr_EOL(LINK)
struct LOC_Convert_second_strike *LINK;
{
  /* -- Sluit alle commando's door de Attributen-rij af te lopen -- */
  short j;

  for (j = LINK->num_of_attr[LINK->next]; j >= 0x1; j--)
    fputs(close_com[LINK->attr_BOL[LINK->next][j]], latex);

  LINK->attr_closed = true;
}



Local Void Latex_head(LINK)
struct LOC_Convert_second_strike *LINK;
{
  /* -- Maak het de standard-heading voor een latex-file aan -- */
  fprintf(latex, "\\documentstyle[11pt,wp2latex]{report}\n");
  fprintf(latex, "\\begin{document}\n");
}



Local Void Latex_foot(LINK)
struct LOC_Convert_second_strike *LINK;
{
  /* -- Sluit de latex-file op de juiste wijze af -- */
  fprintf(latex, "\\end{document}\n");
}



Local Void Latex_tabset(LINK)
struct LOC_Convert_second_strike *LINK;
{
  short atpr, j;
  double l, ol;
  short FORLIM;

  atpr = 0;   /* Huiding aantal tabs per regel */
  ol = 0.0;
  FORLIM = LINK->num_of_tabs;
  for (j = 0; j < FORLIM; j++) {
    l = LINK->tabpos[j] / 1200.0 * 2.54;
    fprintf(latex, "\\hspace{%3.2fcm}\\=", l - ol);
    atpr++;
    if (atpr >= 4) {
      fprintf(latex, "%%\n");
      atpr = 0;
    }
    ol = l;
  }
  fprintf(latex, "\\kill\n");
}



Local boolean Change_envir_BOL(LINK)
struct LOC_Convert_second_strike *LINK;
{
  boolean hulp;

  hulp = false;

  hulp = (LINK->envir[LINK->cur] == 'C' && LINK->envir[LINK->pre] != 'C' ||
	  hulp);
  hulp = (LINK->envir[LINK->cur] == 'T' && LINK->envir[LINK->pre] != 'T' ||
	  hulp);
  hulp = (LINK->envir[LINK->cur] == 'I' && LINK->envir[LINK->pre] != 'I' ||
	  hulp);

  return hulp;
}



Local boolean Change_envir_EOL(LINK)
struct LOC_Convert_second_strike *LINK;
{
  boolean hulp;

  hulp = false;

  hulp = (((LINK->envir[LINK->next] == 'C') ^ (LINK->envir[LINK->cur] == 'C')) ||
	  hulp);
  hulp = (((LINK->envir[LINK->next] == 'T') ^ (LINK->envir[LINK->cur] == 'T')) ||
	  hulp);
  hulp = (((LINK->envir[LINK->next] == 'I') ^ (LINK->envir[LINK->cur] == 'I')) ||
	  hulp);

  return hulp;
}




Local Void Open_environment(LINK)
struct LOC_Convert_second_strike *LINK;
{
  if (!Change_envir_BOL(LINK)) {   /* andere environment ? */
    if (LINK->new_tabset[LINK->cur] && LINK->envir[LINK->cur] == 'T')
      Latex_tabset(LINK);
    return;
  }


  if (!LINK->attr_closed)
    Close_all_attr_BOL(LINK);

  switch (LINK->envir[LINK->cur]) {

  case 'C':
    fprintf(latex, "\\begin{center}\n");
    break;

  case 'T':
    fprintf(latex, "\\begin{tabbing}\n");
    Latex_tabset(LINK);
    break;

  case 'I':
    fprintf(latex, "\\begin{indenting}");
    fprintf(latex, "{%3.2fcm}",
	    LINK->ind_leftmargin[LINK->cur] / 1200.0 * 2.54);
    fprintf(latex, "{%3.2fcm}",
	    LINK->ind_rightmargin[LINK->cur] / 1200.0 * 2.54);
    if (LINK->ind_label[LINK->cur] == 1) {
      fprintf(latex, "%%\n");
      putc('{', latex);
    } else
      fprintf(latex, "{}\n");
    break;
  }

}



Local Void Close_environment(LINK)
struct LOC_Convert_second_strike *LINK;
{
  switch (LINK->envir[LINK->cur]) {

  case 'C':
    fprintf(latex, "\\end{center}\n");
    break;

  case 'T':
    fprintf(latex, "\\end{tabbing}\n");
    break;

  case 'I':
    fprintf(latex, "\\end{indenting}\n");
    break;
  }

  LINK->just_envir_closed = true;

}



Local Void Update_global_information(LINK)
struct LOC_Convert_second_strike *LINK;
{
  short j, FORLIM;

  if (LINK->new_tabset[LINK->cur]) {
    LINK->num_of_tabs = LINK->tabent_num_of_tabs[LINK->cur];
    FORLIM = LINK->num_of_tabs;
    for (j = 0; j < FORLIM; j++)
      LINK->tabpos[j] = LINK->tabent_tabpos[LINK->cur][j];
  }

  if (LINK->new_tabent_rightjust[LINK->cur])
    LINK->new_rightjust = LINK->tabent_rightjust[LINK->cur];

}


Local Void Change_tabelentry(LINK)
struct LOC_Convert_second_strike *LINK;
{
  short help;

  help = LINK->pre;
  LINK->pre = LINK->cur;
  LINK->cur = LINK->next;
  LINK->next = help;
  Read_tabelentry(LINK->next, LINK);
}


/*---SLAG2---*/

Static Void Convert_second_strike()
{
  struct LOC_Convert_second_strike V;
  unsigned short regelnum;
  short convperc;

  boolean underline;

  short i;

  Char regel[256], hulp_regel[256];
  short len_reg;

  boolean rightjust;
  Char STR3[256];
  Char *TEMP;


  V.pre = 0;
  V.cur = 1;
  V.next = 2;

  V.envir[V.pre] = ' ';
  V.new_tabset[V.pre] = false;

  V.just_envir_closed = true;
  V.attr_closed = false;

  rightjust = true;
  V.new_rightjust = true;
  for (i = 0; i <= 2; i++) {
    V.new_tabent_rightjust[i] = false;
    V.tabent_rightjust[i] = false;
  }

  Read_tabelentry(V.cur, &V);
  Read_tabelentry(V.next, &V);

  regelnum = 1;

  printf("\nSecond strike :\n");
#ifndef sun
  printf("Converting-percentage :     ");
#endif



  Latex_head(&V);

  while (!P_eof(strip)) {
    Update_global_information(&V);

#ifndef sun
    convperc = (long)floor(regelnum * 100.0 / num_of_lines_stripfile + 0.5);
    if (convperc > 100)
      convperc = 100;
    printf("\b\b\b\b%3d%%", convperc);
#endif

    fgets(regel, 256, strip);
    TEMP = (char *)strchr(regel, '\n');
    if (TEMP != NULL)
      *TEMP = 0;

    /* Werk eventueel de regel bij d.m.v. een hulp regel. */

    strcpy(hulp_regel, regel);
    len_reg = strlen(hulp_regel);

    /* Meerdere spaties achter elkaar vervangen door harde spaties. */

    for (i = 1; i < len_reg; i++) {
      if (regel[i - 1] == ' ' && regel[i] == ' ')
	hulp_regel[i] = '~';
    }

    /* Zoek naar een illegaal argument en zet hier accolades voor. */

    if (len_reg >= 1 && hulp_regel[0] == '[' ||
	len_reg >= 2 && hulp_regel[0] == ' ' && hulp_regel[1] == '[')
      sprintf(hulp_regel, "{}%s", strcpy(STR3, hulp_regel));

    /* De regel is verwerkt. */

    strcpy(regel, hulp_regel);
    len_reg = strlen(regel);

    if (V.new_rightjust ^ rightjust) {
      rightjust = V.new_rightjust;
      if (rightjust)
	fprintf(latex, "\\justified\n");
      else
	fprintf(latex, "\\raggedright\n");
    }

    Open_environment(&V);

    if (len_reg > 0) {
      if (V.attr_closed)
	Open_all_attr_BOL(&V);

      fputs(regel, latex);

      V.just_envir_closed = false;
    }

    switch (V.line_term[V.cur]) {   /*Case*/

    case 'r':
    case 'p':
	  fputc('\n', latex);
      if (Change_envir_EOL(&V)) {
	     if (!V.attr_closed) {
	       Close_all_attr_EOL(&V);
		 }

	     Close_environment(&V);
      }
      break;

    case 'R':
      if (V.envir[V.cur] == 'I') {
	if (!V.attr_closed)
	  Close_all_attr_EOL(&V);

	putc('\n', latex);
	Close_environment(&V);
	V.envir[V.cur] = ' ';
      } else {
	underline = false;
	for (i = 0x1; i <= 0x10; i++)
	  underline = (underline || V.attr_BOL[V.next][i] == 0xb ||
		       V.attr_BOL[V.next][i] == 0xe);

	if (underline && !V.attr_closed)
	  Close_all_attr_EOL(&V);

	/* Elke Indent-environment moet na een harde Return*/
	/* Afgesloten worden.*/


	if (Change_envir_EOL(&V)) {
	  if (V.just_envir_closed)
	    fprintf(latex, "\\nwln\n");
	  else
	    putc('\n', latex);

	  if (!V.attr_closed)
	    Close_all_attr_EOL(&V);

	  Close_environment(&V);
	} else {
	  if (V.just_envir_closed)
	    fprintf(latex, "\\nwln\n");
	  else
	    fprintf(latex, "\\\\\n");
	}
      }

      break;


    case 'P':
      if (!V.attr_closed)
	Close_all_attr_EOL(&V);

      putc('\n', latex);
      Close_environment(&V);
      fprintf(latex, "\\newpage\n");
      V.envir[V.cur] = ' ';
      break;

    }



    Change_tabelentry(&V);

    regelnum++;
  }

  Latex_foot(&V);
  putchar('\n');
}

/*---HOOFDPROG---*/

main(argc, argv)
int argc;
Char *argv[];
{

  PASCAL_MAIN(argc, argv);
  latex = NULL;
  strip = NULL;
  tabel = NULL;
  wpd = NULL;

  Init_commando();

  /* ClrScr(); */
  putchar(0xc);
  printf("\n     Conversion program : From Wordperfect 5.1 to LaTeX  (wp2latex)\n\n");
  printf("  (c) TUE-Eindhoven ---- Written by R.C.Houtepen ---- Date : 24 Jan 1990\n");
  printf("      Translated into C by G. Geers ---- Date : 2 Aug 1990\n");

  Filenames();

  if (wpd != NULL)
    wpd = freopen(wpd_NAME, "r+b", wpd);
  else
    wpd = fopen(wpd_NAME, "r+b");
  if (wpd == NULL)
    _EscIO(FileNotFound);
  Wpd_check();

  if (strip != NULL)
    strip = freopen(strip_NAME, "w", strip);
  else
    strip = fopen(strip_NAME, "w");
  if (strip == NULL)
    _EscIO(FileNotFound);
  if (tabel != NULL)
    tabel = freopen(tabel_NAME, "w+b", tabel);
  else
    tabel = fopen(tabel_NAME, "w+b");
  if (tabel == NULL)
    _EscIO(FileNotFound);

  printf("Converting ...\n\n");

  Convert_first_strike();

  if (wpd != NULL)
    fclose(wpd);
  wpd = NULL;
  if (strip != NULL)
    fclose(strip);
  strip = NULL;
  if (tabel != NULL)
    fclose(tabel);
  tabel = NULL;

  if (strip != NULL)
    strip = freopen(strip_NAME, "r", strip);
  else
    strip = fopen(strip_NAME, "r");
  if (strip == NULL)
    _EscIO(FileNotFound);
  if (tabel != NULL)
    tabel = freopen(tabel_NAME, "r+b", tabel);
  else
    tabel = fopen(tabel_NAME, "r+b");
  if (tabel == NULL)
    _EscIO(FileNotFound);
  if (latex != NULL)
    latex = freopen(latex_NAME, "w", latex);
  else
    latex = fopen(latex_NAME, "w");
  if (latex == NULL)
    _EscIO(FileNotFound);

  Convert_second_strike();

  if (wpd != NULL)
    fclose(wpd);
  if (latex != NULL)
    fclose(latex);

/*
** Delete auxillary files
*/
#ifndef DEBUG
  if (strip != NULL)
    unlink(strip_fn);
  if (tabel != NULL)
    unlink(tabel_fn);
#endif

  printf("\nConversion completed.\n");
  exit(0);
}
/* End. */

/*
** Extras - hand coded 
*/

Static Void
RunError(errcode)
int errcode;
{
	switch (errcode) {
		case 0x201:
			fprintf(stderr, "Not a WordPerfect 5.1 document !\n");
			break;
		case 0x200:
			fprintf(stderr, "No filename entered !\n");
			break;
		case 0x100:
			fprintf(stderr, "Program error.\n");
			break;
		case 0x03:
			fprintf(stderr, "Path not found.\n");
			break;
		case 0x02:
			fprintf(stderr, "File not found.\n");
			break;
	}
	exit(errcode);
}
