/*
 * Originally by Vadim Maslov: vadik@cs.umd.edu
 * Minor patches by Simon Hawkin: cema@cs.umd.edu
 *
*/

#include <stdio.h>

/*
 * Cyrillic KOI-8 to AMS TeX cyrillic translator.
 * Acts as a filter.
 *
 * After you apply this to the source KOI-8 file, you will need to LaTeX it.
 * The following files are used: cyrillic.sty, cyracc.def, fullpage.sty.
 *
 * Recommended options (cema): -l -B -y
 */

char *ltot[] = {
    " j2",       " a",  " b",      "_c",   "_d",    "_e", " f",  " g",
    " h",        "_i",  " \\u\\i ","_k",   "_l",    " m", "_n",  " o",
    "_p",        " j1", " r",      "_s",   "_t",    " u", " zh", " v",
    " \\cprime ","_y",  "_z",      " x",   " \\`e", " w", " q",  " \\cdprime ",

    " J2",       " A",  " B",      "_C",   "_D",    "_E", " F",  " G",
    " H",        "_I",  " \\u I",  "_K",   "_L",    " M", "_N",  " O",
    "_P",        " J1", " R",      "_S",   "_T",    " U", " Zh", " V",
    " \\Cprime ","_Y",  "_Z",      " X",   " \\`E", " W", " Q",  " \\Cdprime "
};


void PrintLetter(s) char *s; {
    fputs(s+1, stdout);
    if(*s!=' ')
	fputs("\\cydot ", stdout);
}

main (argc, argv)
    int argc; char *argv[];
{
    int c, cc, i;
    int cyr = 0;
    int fill = 0;
    int nohyphen = 0;
    int bs_newpage = 0;
    int leftjustify = 0; /* cema */
    int retain_leading_blanks = 0, retain_all_blanks = 0; /* cema */
    int skip_at_top = 0;
    int cprev = '\n';
    int is_in_leading_blanks = 1; /* cema */
    int num_hyphens = 0; /* cema */
    int smart_hyphens = 0; /* cema */
    int no_page_numbers = 0; /* cema */
    int font_12pt = 0; /* cema */

    /* parse args */
    for ( i = 1; i < argc; i ++ ) {
	char *p = argv [i];
	if ( *p == '-' ) {
	    switch (p [1]) {
	    case 'f':	             /* fill paragraphs */
		fill = 1;
		printf("\\sloppy\n");
		break;
	    case '-':	             /* delete hyphenation */
		nohyphen = 1;
		break;
	    case '\\':	     /* \ at line beginning -> formfeed */
		bs_newpage = 1;
		break;
	    case 'l': /* cema: left-justify ? */
		leftjustify = 1; /* cema */
		break; /* cema */
	    case 'b': /* cema: retain all blanks */
		retain_all_blanks = 1; /* cema */
		break; /* cema */
	    case 'B': /* cema: retain leading blanks */
		retain_leading_blanks = 1;
		break;
	    case 'y': /* cema: use smart hyphens */
		smart_hyphens = 1;
		break;
	    case 'e': /* cema: no page numbers */
		no_page_numbers = 1;
		break;
	    case 'S': /* cema: bigger font (12pt) */
		font_12pt = 1;
		break;
	    case 'h': /* cema */
	    case '?': /* cema */
		fprintf (stderr,
			 "\nUsage: %s [options] < file.koi8 > file.tex\n",
			 argv [0]
		    );
		fprintf (stderr,
		    "\nOptions:\n\t-h\tThis helpful message. Also -?\n"
		    );
		fprintf (stderr,
			 "\t-f\tFill paragraphs\n"
			 );
		fprintf (stderr,
			 "\t--\tDelete hyphenation\n"
			 );
		fprintf (
		    stderr,
		    "\t-\\\tLine started with '\\' causes form feed\n"
		    );
		fprintf (stderr,
			 "\t-l\tJustify to the left\n"
			 );
		fprintf (
		    stderr,
		    "\t-b\tRetain (almost) all blanks (*)\n"
		    );
		fprintf (stderr,
			 "\t-B\tRetain leading blanks (*)\n"
			 );
		fprintf (
		    stderr,
		    "\t-y\tSmart hyphenation.\n\t\t%s\n\t\t%s\n",
		    "Use - for a hyphen, -- for a dash, --- for a long dash.",
		    "More than 3 hyphens will be output as separate ones."
		    );
		fprintf (stderr,
			 "\t-e\tNo page numbers\n"
			 );
		fprintf (stderr,
			 "\t-S\tUse bigger fonts (12pt)\n"
			 );
		fprintf (stderr,
			 "\t-?\tThis helpful message. Also -h\n"
			 );
		fprintf (
		    stderr,
		    "Recommended options: -l -B -y\n"
		    );
		fprintf (
		    stderr,
		    "\n(*) If the text is not left-justified,\n"
		    );
		fprintf (
		    stderr,
		    "the 1st line of each paragraph is indented.\n"
		    );
		exit (0);
	    default:
		fprintf(stderr, "Wrong option: %s\n", p);
		exit(1);
	    }
	} else {
	    fprintf(stderr, "No file name allowed: %s\n", p);
	    exit(1);
	}
    }

    fprintf (stderr,
	     "*** List of all options is available as \"%s -h\"\n",
	     argv [0]
	);
    fprintf(stderr, "*** Current options:\n");
    fprintf(stderr, "*** Fill Paragraphs = %d\n", fill);
    fprintf(stderr, "*** Delete Hyphenation = %d\n", nohyphen);
    fprintf(stderr, "*** \\ at line beg. to FormFeed = %d\n", bs_newpage);
    fprintf(stderr, "*** Left justification = %d\n", leftjustify); /* cema */
    fprintf(stderr, "*** Retain leading blanks = %d\n", /* cema */
	    retain_leading_blanks /* cema */
	); /* cema */
    fprintf(stderr, "*** Retain all blanks = %d\n", retain_all_blanks); /* cema */
    fprintf(stderr, "*** Smart hyphens = %d\n", smart_hyphens); /* cema */
    fprintf(stderr, "*** No page numbers = %d\n", no_page_numbers); /* cema */
    printf("\\documentstyle[fullpage,cyrillic");
    if ( font_12pt ) /* cema */
	printf (",12pt");
    printf ("]{article}\n\\begin{document}\n");
    printf("\\setlength{\\parskip}{0.3em}\n");
    if ( no_page_numbers ) /* cema */
	printf ("\\pagestyle{empty}"); /* cema */
    if ( leftjustify) /* cema */
	printf ("\\begin{flushleft}\n"); /* cema */
    printf("\\bf\n");

    while ( (c = getchar ()) != EOF ) {

	if ( smart_hyphens && cprev == '-' && c != '-' ) { /* cema */
	    switch (num_hyphens) { /* cema */
	    case 3: /* cema */
		putchar ('-'); /* cema */
	    case 2: /* cema */
		putchar ('-'); /* cema */
	    case 1: /* cema */
		putchar ('-'); /* cema */
		break; >
<HR><H3>Transfer interrupted!</H3>
