/* dvi.h: All of the DVI commands

This file is part of the Omega project, which
is based on the web2c distribution of TeX.

Copyright (C) 2000 John Plaice and Yannis Haralambous

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* VF commands */

#define VF_ID		202 /* the second byte of a VF file */

/* DVI commands */

#define DVI_SET_CHAR_0    0 /* typeset character 0 and move right */
#define DVI_SET_CHAR_127 127 /* ... to 127 */
#define DVI_SET1        128 /* typeset a char (1 byte)  and move right */
#define DVI_SET2        129 /* typeset a char (2 bytes) and move right */
#define DVI_SET3        130 /* typeset a char (3 bytes) and move right */
#define DVI_SET4        131 /* typeset a char (4 bytes) and move right */
#define DVI_SET_RULE    132 /* typeset a rule and move right */
#define DVI_PUT1        133 /* typeset a char (1 byte)  and stay put */
#define DVI_PUT2        134 /* typeset a char (2 bytes) and stay put */
#define DVI_PUT3        135 /* typeset a char (3 bytes) and stay put */
#define DVI_PUT4        136 /* typeset a char (4 bytes) and stay put */
#define DVI_PUT_RULE    137 /* typeset a rule and stay put */
#define DVI_NOP         138 /* no-op */
#define DVI_BOP         139 /* beginning of page */
#define DVI_EOP         140 /* end of page */
#define DVI_PUSH        141 /* save the current positions */
#define DVI_POP         142 /* restore previous positions */
#define DVI_RIGHT1      143 /* move right (1 byte)  */
#define DVI_RIGHT2      144 /* move right (2 bytes) */
#define DVI_RIGHT3      145 /* move right (3 bytes) */
#define DVI_RIGHT4      146 /* move right (4 bytes) */
#define DVI_W0          147 /* move right by |w| */
#define DVI_W1          148 /* move right and set |w| (1 byte)  */
#define DVI_W2          149 /* move right and set |w| (2 bytes) */
#define DVI_W3          150 /* move right and set |w| (3 bytes) */
#define DVI_W4          151 /* move right and set |w| (4 bytes) */
#define DVI_X0          152 /* move right by |x| */
#define DVI_X1          153 /* move right and set |x| (1 byte)  */
#define DVI_X2          154 /* move right and set |x| (2 bytes) */
#define DVI_X3          155 /* move right and set |x| (3 bytes) */
#define DVI_X4          156 /* move right and set |x| (4 bytes) */
#define DVI_DOWN1       157 /* move down (1 byte) */
#define DVI_DOWN2       158 /* move down (2 bytes) */
#define DVI_DOWN3       159 /* move down (3 bytes) */
#define DVI_DOWN4       160 /* move down (4 bytes) */
#define DVI_Y0          161 /* move down by |y| */
#define DVI_Y1          162 /* move down and set |y| (1 byte)  */
#define DVI_Y2          163 /* move down and set |y| (2 bytes) */
#define DVI_Y3          164 /* move down and set |y| (3 bytes) */
#define DVI_Y4          165 /* move down and set |y| (4 bytes) */
#define DVI_Z0          166 /* move down by |z| */
#define DVI_Z1          167 /* move down and set |z| (1 byte)  */
#define DVI_Z2          168 /* move down and set |z| (2 bytes) */
#define DVI_Z3          169 /* move down and set |z| (3 bytes) */
#define DVI_Z4          170 /* move down and set |z| (4 bytes) */
#define DVI_FNT_NUM_0   171 /* set current font to 0 */
#define DVI_FNT_NUM_63	234 /* ... to 234 */
#define DVI_FNT1        235 /* set current font (1 byte)  */
#define DVI_FNT2        236 /* set current font (2 bytes) */
#define DVI_FNT3        237 /* set current font (3 bytes) */
#define DVI_FNT4        238 /* set current font (4 bytes) */
#define DVI_XXX1        239 /* extension to DVI primitives (1 byte)  */
#define DVI_XXX2        240 /* extension to DVI primitives (2 bytes) */
#define DVI_XXX3        241 /* extension to DVI primitives (3 bytes) */
#define DVI_XXX4        242 /* extension to DVI primitives (4 bytes) */
#define DVI_FNT_DEF1    243 /* define the meaning of a font number */
#define DVI_FNT_DEF2    244 /* define the meaning of a font number */
#define DVI_FNT_DEF3    245 /* define the meaning of a font number */
#define DVI_FNT_DEF4    246 /* define the meaning of a font number */
#define DVI_PRE         247 /* preamble */
#define DVI_POST        248 /* postamble beginning */
#define DVI_POST_POST   249 /* postamble ending */

