/* Transpose 8x8 bit matrix
   gas version of the MS-DOS ghostscript routine memflip8x8 in iutilasm.asm,
   frobbed for 32-bit execution.  iutilasm.asm is

;    Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.
;
; This file is part of Ghostscript.
;
; Ghostscript is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
; to anyone for the consequences of using it or for whether it serves any
; particular purpose or works at all, unless he says so in writing.  Refer
; to the Ghostscript General Public License for full details.
;
; Everyone is granted permission to copy, modify and redistribute
; Ghostscript, but only under the conditions described in the Ghostscript
; General Public License.  A copy of this license is supposed to have been
; given to you along with Ghostscript so you can know your rights and
; responsibilities.  It should be in a file named COPYING.  Among other
; things, the copyright notice and this notice must be preserved on all
; copies.
*/

.text
.align 4
.globl _memflip8x8
.globl memflip8x8

_memflip8x8:
memflip8x8:
	pushl %esi
	pushl %edi
	pushl %ebx

#define arg_inp		16(%esp)
#define arg_line_size 	20(%esp)
#define arg_outp	24(%esp)
#define arg_dist	28(%esp)

	movl arg_inp,%esi
	movl arg_line_size,%edi

#define iload(reg) \
	addl %edi,%esi;\
	movb (%esi),reg

	movb (%esi),%ah
	iload (%al)
	iload (%ch)
	iload (%cl)
	iload (%bh)
	iload (%bl)
	iload (%dh)
	iload (%dl)

#define trans(reg1,reg2,shift,mask) \
	movw reg1,%si;\
	shrw shift,%si;\
	xorw reg2,%si;\
	andw mask,%si;\
	xorw %si,reg2;\
	shlw shift,%si;\
	xorw %si,reg1

	trans (%bx,%ax,$4,$0x0f0f)
	trans (%dx,%cx,$4,$0x0f0f)

	xchgb %al,%bh
	xchgb %cl,%dh

	trans (%cx,%ax,$2,$0x3333)
	trans (%dx,%bx,$2,$0x3333)

	trans (%bx,%ax,$1,$0x5555)
	trans (%dx,%cx,$1,$0x5555)
	
	movl arg_outp,%esi
	movl arg_dist,%edi

#define istore(reg) \
	addl %edi,%esi;\
	movb reg,(%esi)

	movb %ah,(%esi)
	istore (%bh)
	istore (%ch)
	istore (%dh)
	istore (%al)
	istore (%bl)
	istore (%cl)
	istore (%dl)

	popl %ebx
	popl %edi
	popl %esi
	ret
	