#include <forms.h>
#include "load_data.h"
#include "main_window.h"
#include "load_window.h"
#include "edit_window.h"
#include "preset_window.h"
#include "search_window.h"
#include "message_window.h"

extern list_data_selected();
extern list_data_all();

FD_main_window *main_window;
FD_load_window *load_window;
FD_edit_window *edit_window;
FD_preset_window *preset_window;
FD_search_window *search_window;
FD_message_window *message_window;

char field_name_list[][32]={FIELDNAMES};

BS_data_list data;

main(int argc,char *argv[])
{
  int File_Menu_Selec,irun;

  fl_initialize(&argc,argv,"Biborg",0,0);

  main_window = create_form_main_window();
  edit_window = create_form_edit_window();
  load_window = create_form_load_window();
  preset_window = create_form_preset_window();
  search_window = create_form_search_window();
  message_window = create_form_message_window();




  data=0;

  fl_clear_choice(main_window->sort_by);
  fl_clear_choice(main_window->list_column_choice);
  
  irun=0;
  while(irun++<MAXFIELDS &&
	strlen(&field_name_list[irun][0])!=0)
    {
      fl_addto_choice(main_window->sort_by,&field_name_list[irun][0]);
      fl_addto_choice(main_window->list_column_choice,&field_name_list[irun][0]);
    }
  fl_set_choice(main_window->list_column_choice,19);
  fl_deactivate_object(main_window->sort_by);
  fl_deactivate_object(main_window->list_column_choice);
  fl_deactivate_object(main_window->main_search);

  fl_show_form(main_window->main_window,FL_PLACE_MOUSE,FL_FULLBORDER,"BibOrg");
  fl_show_form(message_window->message_window,FL_PLACE_MOUSE,FL_FULLBORDER,"BibOrg messages");

  fl_do_forms() ;

}




