<!--

  Copyright (c) Graham.Williams@cmis.csiro.au

-->
<xsl:stylesheet version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="common.xsl"/>
<xsl:variable name="base-locale">.</xsl:variable>
<xsl:template match="catalogue">
  <xsl:comment>This file is automatically generated. Do not edit!</xsl:comment>
  <html>
  <xsl:call-template name="header"/>
  <body bgcolor="white">
    <xsl:call-template name="title"/>
    <xsl:call-template name="author"/>
    <xsl:call-template name="alphalist"/>
    <xsl:call-template name="copyright"/>
    <hr/>
    <xsl:apply-templates select="entry"/>
    <hr/>
  </body>
  </html>
</xsl:template>
<xsl:template match="entry">
  <xsl:if test="substring(@id,1,1)!=substring(preceding::entry[1]/@id,1,1)">
    <a name="{translate(substring(@id,1,1),
       'abcdefghijklmnopqrstuvwxyz', 
       'ABCDEFGHIJKLMNOPQRSTUVWXYZ')}"></a>
    <h3>
       <xsl:value-of select="translate(substring(@id,1,1),
		     'abcdefghijklmnopqrstuvwxyz', 
		     'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>:</h3>
  </xsl:if>
  <a name="{@id}" href="entries/{@id}.html">
    <big><xsl:value-of select="about/name"/></big>
  </a>
  <xsl:text>
</xsl:text>
</xsl:template>
</xsl:stylesheet>


