/* common.cpp							-*- C++ -*-
   Time-stamp: "97/08/03 02:32:16 mik"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdarg.h>
#include <stdio.h>

#include "common.h"

#if defined (DEBUG_OUTPUT)
FILE *debug_stream = 0;

void
dprintf (const char *fmt,
	 ...)

{
  if (debug_stream == 0)
    debug_stream = fopen ("dvi.debug", "w");
  va_list ap;
  va_start (ap, fmt);
  vfprintf (debug_stream, fmt, ap);
  va_end (ap);
  fflush (debug_stream);
}

void
dputchar (int ch)

{
  if (debug_stream == 0)
    debug_stream = fopen ("dvi.debug", "w");
  fputc (ch, debug_stream);
}
#endif

_ifwrdstream::_ifwrdstream (const char *_filename)
  
  : stream (fopen (_filename, "rb"))

{
  ;
}

_ifwrdstream::~_ifwrdstream ()

{
  if (stream)
    {
      fclose (stream);
      stream = 0;
    }
}
