{$IFDEF WINDOWS}
{$N-,V-,W-,G+,R-}
{$ELSE}
{$E-,N-,V-,R-}
{$ENDIF}

Unit bib8bit;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, wbibdisp, winprocs, WinTypes, Wobjects, Strings, win31,
{$ELSE}
  DOS, bibdisp, objects,
{$ENDIF}
  bibstrg, bibvars, bibfile, rc_strng, lfnunit;

const
  EncodingExt = '.fen';

type
  BitTransRec = record
    s: PString;
    c,N: char;
  end;

  PEncoding = ^TEncoding;
  TEncoding = object(TObject)
    Name,Comment: PString;
    constructor init(AName: string);
    destructor  done; virtual;
  end;

  TranslateType = array[1..255] of BitTransRec;
  TranslatePtr  = ^TranslateType;
  HighUpperType = array[1..2] of string;
  HighUpperPtr  = ^HighUpperType;
  ControlCharsType = set of char;

var
  Prog7Bit,Prog8Bit,File7Bit,File8Bit,Fwrite8bit,FWrite7bit: Boolean;
  codepage: integer;
  Translate,FReadTranslate,FWriteTranslate: TranslatePtr;
  HighUpper: HighUpperPtr;
  NTranslate,NFReadTranslate,NFWriteTranslate: integer;
  HighLows,CtrlStartChars,FReadCtrlStartChars,FWriteCtrlStartChars: ControlCharsType;
  DispEncoding,FReadEncoding,FWriteEncoding: integer;
  UseReadEncodingOnly: boolean;
  EncodingsList: TCollection;

function  GetCodePage: Word;
procedure HighBits(DispInd,FreadInd,FwriteInd: integer);
procedure Conv28bit(var Ss; var Blen: Word; author: boolean);
procedure Conv28bitFile(var Ss; var Blen: Word; author,IsRead: boolean);
procedure SConv28bit(var S: string; author: boolean);
procedure SConv28bitFile(var S: string; author,IsRead: boolean);
procedure Conv27bit(var Ss; var Blen: Word; author: boolean;
                    MaxBig: Word);
procedure Conv27BitFile(var Ss; var Blen: Word; author: boolean; MaxBig: Word;
                        IsRead: boolean);
procedure SConv27bit(var S: string; author: boolean);
procedure SConv27bitFile(var S: string; author,IsRead: boolean);
procedure Prog8ToFile8(var Ss; var Blen: word; author: boolean; MaxBig: Word);
procedure File8ToProg8(var Ss; var Blen: word; author: boolean; MaxBig: Word);
procedure DeSpecial(Var S: string);


Implementation

function EncodingComment(fname: string): string;
var
  f: text;
  tmp: string;
  Attr: word;
  i: integer;
  Dir,Name,Ext: PString;
begin
  tmp:='';
  if fname='<none>' then
  begin
   EncodingComment:=''; Exit;
  end;
  New(Dir); New(Name); New(Ext);
  StrRepl(fname,'<codepage>',num2str(GetCodepage),1,255,255);
  LFNFSplit(fname,Dir,Name,Ext);
  fname:=ProgramDir^+Name^+EncodingExt;
  LFNNew(f,true);
  LFNAssign(f,fname);
  if LFNGetFattr(f,Attr)=0 then   { file exists }
  begin
    if LFNreset(f,0)=0 then readln(f,tmp);
    LFNClose(f);
  end;
  if (tmp<>'') and (tmp[1]='@') then
  begin
    UnTabify(tmp);
    while (tmp<>'') and (tmp[1]<>' ') do delete(tmp,1,1);
    ChrDelL(tmp,' '); ChrDelR(tmp,' ');
  end else tmp:='';
  EncodingComment:=tmp;
  LFNDispose(f);
  Dispose(Ext); Dispose(Name); Dispose(Dir);
end;                     { EncodingComment }

constructor TEncoding.init(AName: string);
var
  tmp: string;
begin
  TObject.init;
  Name:=Nil; Comment:=Nil;
  StrLwr(AName);
  Name:=NewStr(AName);
  tmp:=EncodingComment(AName);
  if tmp<>'' then Comment:=NewStr(tmp);
end;

destructor TEncoding.Done;
begin
  DisposeStr(Name); DisposeStr(Comment);
  TObject.Done;
end;

procedure InitEncList;
var
  Name,Tname: PString;
  S: TLFNSearchRec;
  P: PChar;
begin
  New(Name); GetMem(TName,270); FillChar(TName^,270,0);
  EncodingsList.Init(10,10);
  LFNFindFirst(ProgramDir^+'*'+EncodingExt,faAnyFile,S);
  while DosError=0 do
  begin
    P:=@S.Name;
    TName^:=StrPas(P);
    LFNFSplit(TName^,Nil,Name,Nil);
    EncodingsList.Insert(New(PEncoding,init(Name^)));
    LFNFindNext(S);
  end;
  LFNFindClose(S);
  if LFNFileExist(ProgramDir^+num2str(GetCodePage)+EncodingExt) then
    EncodingsList.Insert(New(PEncoding,init('<codepage>')));
  EncodingsList.Insert(New(PEncoding,init('<none>')));
  FreeMem(TName,270); Dispose(Name);
end;

function GetCodePage: Word; assembler;
asm
  mov   ax, $6601
{$IFDEF WINDOWS}
  call  DOS3CALL
{$ELSE}
  int   $21
{$ENDIF}
  mov   ax, 0
  jc    @1
  mov   ax, bx
@1:
end;       { GetCodePage }

procedure WriteEncoding(fname: string; NTrans: integer);
var
  tmp: string;
  f: text;
  i,j: integer;
begin
  LFNNew(f,true);
  LFNAssign(f,fname);
  LFNrewrite(f,0);
  for i:=1 to NTrans do
  begin
    tmp:='\'+Translate^[i].S^; ChrDelR(tmp,' ');
    write(f,Translate^[i].C,','#9,lbrace+tmp+rbrace+','#9,
            Translate^[i].N);
    j:=Pos(Translate^[i].C,HighUpper^[1]);
    if j>0 then
        writeln(f,','#9,HighUpper^[2,j])
    else writeln(f);
  end;
  LFNClose(f); LFNDispose(f);
end;

procedure ClearTranslation(var Trans: TranslatePtr; var NTrans: integer;
                           var CtrlChars: ControlCharsType;
                           var HighUpper: HighUpperType;
                           var HighLows:  ControlCharsType);
var
  i: integer;
begin
  if Trans<>Nil then
  begin
    for i:=1 to NTrans do DisposeStr(Trans^[i].S);
    FreeMem(Trans,(NTrans+1)*sizeof(BitTransRec));
    Trans:=Nil;
  end;
  CtrlChars:=[];
  NTrans:=0;
  HighUpper[1]:=''; HighUpper[2]:='';
  HighLows:=[];
end;

procedure HighBitsRaw(fnameInd: integer;
                      var Translate: TranslatePtr; var NTranslate: integer;
                      var CtrlChars: ControlCharsType;
                      var HighUpper: HighUpperType; var HighLows: ControlCharsType);
var
  f: text;
  line,tmp: string;
  i: integer;

function ReadTheData(measure: boolean): integer;
var
  ch: char;
  AddSpace: boolean;
  i,l,j: integer;
begin
  l:=0;
  repeat
    readln(f,line); ChrDelL(line,' '); ChrDelR(line,' ');
    if (line<>'') and (Ord(line[1])>127) then
    begin
      ch:=line[1];
      i:=Pos(lbrace,line);
      if i>0 then
      begin
        Delete(line,1,i);
        i:=0; j:=0;
        while (i>=0) and (j<length(line)) do
        begin
          inc(j);
          if (j=1) or (line[j-1]<>'\') then
          begin
            if line[j]=lbrace then inc(i)
            else if line[j]=rbrace then dec(i);
          end;
        end;
        tmp:=Copy(line,1,j-1);
        ChrDelL(tmp,' '); ChrDelR(tmp,' ');
        if (tmp<>'') and (tmp[1]='\') then delete(tmp,1,1);
        ChrDelL(tmp,' ');
        Delete(line,1,j);
        while (line<>'') and (line[1] in [' ',#9,',','-',';']) do delete(line,1,1);
        if (line<>'') and (tmp<>'') then   { add it to the list }
        begin
          if measure then inc(l)
          else begin
            AddSpace:=false;
            if tmp[length(tmp)] in ['a'..'z','A'..'Z'] then
            begin
              AddSpace:=true;
              i:=length(tmp)-1;
              while AddSpace and (i>0) and (tmp[i]<>'\') do
              begin
                if not (tmp[i] in ['a'..'z','A'..'Z']) then AddSpace:=false;
                dec(i);
              end;
            end;
            if AddSpace then tmp:=tmp+' ';
            inc(l);
            with Translate^[l] do
            begin
              C:=ch; S:=NewStr(tmp); N:=line[1];
              CtrlChars:=CtrlChars+[S^[1]];
             { message(C+' = "'+S^+'" = '+N);}
            end;
            Delete(line,1,1);
            while (line<>'') and (ord(line[1])<128) do delete(line,1,1);
            if (line<>'') and (Pos(ch,HighUpper[1])=0) then
            begin
              HighUpper[1]:=HighUpper[1]+ch;
              HighUpper[2]:=HighUpper[2]+line[1];
              HighLows:=HighLows+[ch];
            end;
          end;
        end;
      end else if not measure then
      begin
        while (line<>'') and (ord(line[1])<128) do delete(line,1,1);
        if (line<>'') and (Pos(ch,HighUpper[1])=0) then
        begin
          HighUpper[1]:=HighUpper[1]+ch;
          HighUpper[2]:=HighUpper[2]+line[1];
          HighLows:=HighLows+[ch];
        end;
      end;
    end;
  until eof(f);
  ReadTheData:=l;
end;                     { ReadTheData }

begin
  if fnameind<0 then Exit;

  tmp:=PEncoding(EncodingsList.at(FnameInd))^.Name^;
  if tmp='<none>' then Exit;
  if tmp='<codepage>' then tmp:=num2str(GetCodePage);
  LFNNew(f,true);
  LFNAssign(f,ProgramDir^+tmp+EncodingExt);
  i:=LFNReset(f,0); 
  if I<>0 then
  begin
    ErrorMessageRC(Str_CantReadFile,ProgramDir^+tmp+EncodingExt);
    LFNDispose(f);
    Exit;
  end;
  CtrlChars:=[];
  NTranslate:=ReadTheData(true);
  if NTranslate>0 then
  begin
    GetMem(Translate,(NTranslate+1)*sizeof(BitTransRec));
    LFNreset(f,0);
    ReadTheData(false);
  end;
  LFNDispose(f);
end;                        { HighBitsRaw }

procedure HighBits(DispInd,FreadInd,FwriteInd: integer);
var
  HU: HighUpperType;
  HL: ControlCharsType;
begin
  if DispInd<0 then DispInd:=EncodingsList.Count-1;
  if FReadInd<0 then FReadInd:=DispInd;
  if FWriteInd<0 then FWriteInd:=FReadInd;
  if FReadTranslate=Translate then
  begin
    FReadTranslate:=Nil; NFReadTranslate:=0;
  end;
  if FWriteTranslate=Translate then
  begin
    FWriteTranslate:=Nil; NFWriteTranslate:=0;
  end;
  ClearTranslation(Translate,NTranslate,CtrlStartChars,HighUpper^,HighLows);
  if FReadTranslate=FWriteTranslate then
  begin
    FWriteTranslate:=Nil; NFWriteTranslate:=0;
  end;
  ClearTranslation(FReadTranslate,NFReadTranslate,FReadCtrlStartChars,
                   HU,HL);
  ClearTranslation(FWriteTranslate,NFWriteTranslate,FWriteCtrlStartChars,
                   HU,HL);

  HighBitsRaw(DispInd,Translate,NTranslate,CtrlStartChars,HighUpper^,HighLows);
  if FReadInd=DispInd then
  begin
    FReadTranslate:=Translate; NFReadTranslate:=NTranslate;
    FReadCtrlStartChars:=CtrlStartChars;
  end else
    HighBitsRaw(FReadInd,FReadTranslate,NFReadTranslate,
                FReadCtrlStartChars,HU,HL);

  if FWriteInd=DispInd then
  begin
    FWriteTranslate:=Translate; NFWriteTranslate:=NTranslate;
    FWriteCtrlStartChars:=CtrlStartChars;
  end else if FWriteInd=FReadInd then
  begin
    FWriteTranslate:=FReadTranslate; NFWriteTranslate:=NFReadTranslate;
    FWriteCtrlStartChars:=FReadCtrlStartChars;
  end else
    HighBitsRaw(FWriteInd,FWriteTranslate,NFWriteTranslate,
                FWriteCtrlStartChars,HU,HL);
end;


procedure Conv28bitRaw(var Ss; var Blen: Word; author: boolean;
                       Translate: TranslatePtr; NTranslate: integer;
                       CtrlStartChars: ControlCharsType);
var
  S: BigType ABSOLUTE Ss;
  i,j,k,lcut,nbr: longint;
  acc,ch: char;
  tmp,scomp: string;
  Control,EatNulls: Boolean;

procedure SkipBlanks(var tmp: string; var j: longint);
begin
  while (j<=Blen) and (S[j]=' ') do
  begin
    tmp:=tmp+S[j]; inc(j);
  end;
end;

procedure SkipBraces(var tmp: string; var j, nbr: longint);
begin
  if (j>Blen) or not (S[j] in [lbrace,rbrace]) or
    ((nbr<=0) and (S[j]=rbrace)) then Exit;
  repeat
    tmp:=tmp+S[j];
    if S[j]=lbrace then inc(nbr)
    else Dec(nbr);
    inc(j);
  until (j>Blen) or (not (S[j] in [lbrace,rbrace])) or
    ((nbr=0) and (S[j]=rbrace)) or (nbr<0);
end;

procedure SkipNullBraces(var tmp: string; var j: longint);
var
  tmp2: string;
  k,nbr: longint;
begin
  tmp2:=tmp; k:=j; nbr:=0;
  SkipBraces(tmp2,k,nbr);
  if nbr=0 then
  begin
    tmp:=tmp2; j:=k;
  end;
end;

begin                                     { Conv28bitRaw }
  if (Translate=Nil) or (Blen<3) then Exit;
  i:=1;
  repeat
    tmp:='';
    while (i+2<Blen) and
          ((S[i]<>'\') or
           (not (S[i+1] in CtrlStartChars)) or
           ((i>1) and (S[i-1]='\'))
          ) do
            Inc(i);
    if (i<Blen) and (S[i]='\') then
    begin
      control:=false;
      tmp:=S[i+1]; scomp:=tmp;
      j:=i+2;
      if (j<=Blen) and (S[j] in TexLett) then
      begin
        tmp:=tmp+S[j]; scomp:=scomp+S[j]; inc(j);
      end;
      nbr:=0;
      EatNulls:=true;
      if (length(scomp)=1) and (scomp[1] in ['o','O']) then EatNulls:=false
      else if (length(scomp)=2) and (scomp[1] in ['a','A','s','o','O']) then
      begin
        if (scomp='aa') or (scomp='AA') or (scomp='ae') or (scomp='AE') or
           (scomp='ss') or (scomp='oe') or (scomp='OE') then EatNulls:=false;
      end;
        
      if EatNulls then
      begin
        if (length(scomp)=1) or (tmp[1] in TexLett) then
        begin
          if (j<=Blen) and (S[j]=' ') then SkipBlanks(tmp,j)
          else SkipNullBraces(tmp,j);
          SkipBraces(tmp,j,nbr);
        end else if length(scomp)=1 then SkipBraces(tmp,j,nbr);
      end;
      if not EatNulls then
      begin
        if (j>Blen) or (not(S[j] in TexLett)) then
        begin
          Scomp:=scomp+' ';
          if (j<=Blen) and (S[j]=' ') then SkipBlanks(tmp,j)
          else SkipNullBraces(tmp,j);
        end else
        begin
          Scomp:=''; tmp:='';
        end;
      end else if (j<=Blen) and (length(scomp)=1) then
      begin
        if scomp[length(scomp)] in TexLett then Scomp:=scomp+' ';
        tmp:=tmp+S[j]; scomp:=scomp+S[j]; inc(j);
        if S[j-1]='\' then
        begin
          control:=true;
          while (j<=Blen) and (S[j] in TexLett) do
          begin
            tmp:=tmp+S[j]; scomp:=scomp+S[j]; inc(j);
          end;
          if (j<=Blen) and (S[j]=' ') then SkipBlanks(tmp,j)
          else SkipNullBraces(tmp,j);
          SkipBraces(tmp,j,nbr);
        end else if (j<=Blen) and (S[j]=rbrace) then SkipBraces(tmp,j,nbr);
        if nbr>0 then
        begin
          tmp:=''; scomp:='';
        end else if control then scomp:=scomp+' ';
      end;
      { message('Found "'+tmp+'", equivalent to "'+scomp+'".');}
      j:=1; ch:=#0;
      while (j<=NTranslate) and (ch=#0) do
      begin
        if scomp=translate^[j].S^ then ch:=translate^[j].c;
        inc(j);
      end;
      if ch<>#0 then
      begin
        { message('"'+tmp+'" to "'+ch+'".');}
        if (author) and (i>1) and (i+length(tmp)+1<=Blen) and 
           (S[i-1]=lbrace) and (S[i+length(tmp)+1]=rbrace) then
        begin
          i:=i-1;
          tmp:=lbrace+tmp+rbrace;
        end;
        S[i]:=ch;
        lcut:=length(tmp);
        for k:=i+1 to Blen-lcut do S[k]:=S[k+lcut];
        Blen:=Blen-lcut;
      end else i:=i+1;
    end;
  until (i=0) or (i+2>=Blen);
end;                                     { Conv28bitRaw }

procedure Conv28bit(var Ss; var Blen: Word; author: boolean);
begin
  Conv28bitRaw(Ss,Blen,author,Translate,NTranslate,CtrlStartChars);
end;

procedure Conv28bitFile(var Ss; var Blen: Word; author,IsRead: boolean);
var
  Trans: TranslatePtr;
  NTrans: integer;
  CtrlChars: ControlCharsType;
begin
  IsRead:=IsRead or UseReadEncodingOnly;
  if (FReadTranslate<>Nil) and
     (IsRead or (FWriteTranslate=Nil)) then
  begin
    Trans:=FReadTranslate; NTrans:=NFReadtranslate;
    CtrlChars:=FReadCtrlStartChars;
  end else if (FWriteTranslate<>Nil) and
    (not IsRead or (FReadTranslate=Nil)) then
  begin
    Trans:=FWriteTranslate; NTrans:=NFWriteTranslate;
    CtrlChars:=FWriteCtrlStartChars;
  end else
  begin
    Trans:=Translate; NTrans:=Ntranslate;
    CtrlChars:=CtrlStartChars;
  end;
  Conv28bitRaw(Ss,Blen,author,Trans,NTrans,CtrlChars);
end;                             { Conv28bitFile }

procedure SConv28bit(var S: string; author: boolean);
var
  Blen: Word;
begin
  Blen:=length(S);
  Conv28bit(S[1],Blen,author);
  S[0]:=Chr(Blen);
end;                                     { SConv28Bit }

procedure SConv28bitFile(var S: string; author,IsRead: boolean);
var
  Blen: Word;
begin
  Blen:=length(S);
  Conv28bitFile(S[1],Blen,author,IsRead);
  S[0]:=Chr(Blen);
end;                                     { SConv28BitFile }

procedure Conv27BitRaw(var Ss; var Blen: Word; author: boolean; MaxBig: Word;
                       Translate: TranslatePtr; NTranslate: integer;
                       CtrlStartChars: ControlCharsType);
var
  S: BigType ABSOLUTE Ss;
  i,j,k: longint;
  tmp: string;
  AMacro: boolean;
begin
  if (Translate=Nil) or (Blen<1) then Exit;
  i:=Blen;
  repeat
    while (i>=1) and (Ord(S[i])<128) do Dec(i);
    if (i>0) and (Ord(S[i])>=128) then
    begin
      j:=1;
      while (j<=Ntranslate) and (S[i]<>Translate^[j].c) do inc(j);
      if (j<=Ntranslate) and (S[i]=Translate^[j].c) then
      begin
        tmp:='\'+Translate^[j].S^;
        if author then
        begin
          if tmp[length(tmp)]=' ' then Delete(tmp,length(tmp),1);
          tmp:=lbrace+tmp+rbrace;
        end;
        if (tmp[length(tmp)]=' ') and (i+1<=Blen) and
          (not (S[i+1] in TexLett)) then
            Delete(tmp,length(tmp),1);
        if (i>=Blen) or (S[i+1]=' ') then      { Add trailing brace pair if needed }
        begin
          AMacro:=true;
          k:=length(tmp);
          while AMacro and (k>1) and (tmp[k]<>'\') do
          begin
            if not (tmp[k] in TeXLett) then AMacro:=false; 
            dec(k);
          end;
          if AMacro then tmp:=tmp+lbrace+rbrace;
        end;
        if (tmp<>'') and (Blen+length(tmp)-1<=MaxBig) then
        begin
          if length(tmp)>1 then
            for k:=Blen downto i+1 do S[k+length(tmp)-1]:=S[k];
          for k:=1 to length(tmp) do S[i+k-1]:=tmp[k];
          Blen:=Blen+length(tmp)-1;
        end else i:=0;
      end;
      Dec(i);
    end;
  until i<1;
end;                                     { Conv27BitRaw }

procedure Conv27Bit(var Ss; var Blen: Word; author: boolean; MaxBig: Word);
begin
  Conv27BitRaw(Ss,Blen,author,MaxBig,Translate,NTranslate,CtrlStartChars);
end;

procedure Conv27BitFile(var Ss; var Blen: Word; author: boolean; MaxBig: Word;
                        IsRead: boolean);
var
  Trans: TranslatePtr;
  NTrans: integer;
  CtrlChars: ControlCharsType;
begin
  IsRead:=IsRead or UseReadEncodingOnly;
  if (FReadTranslate<>Nil) and
     (IsRead or (FWriteTranslate=Nil)) then
  begin
    Trans:=FReadTranslate; NTrans:=NFReadTranslate;
    CtrlChars:=FReadCtrlStartChars;
  end else if (FWriteTranslate<>Nil) and
    (not IsRead or (FReadTranslate=Nil)) then
  begin
    Trans:=FWriteTranslate; NTrans:=NFWriteTranslate;
    CtrlChars:=FWriteCtrlStartChars;
  end else
  begin
    Trans:=Translate; NTrans:=Ntranslate;
    CtrlChars:=CtrlStartChars;
  end;
  Conv27BitRaw(Ss,Blen,author,MaxBig,Trans,NTrans,CtrlChars);
end;                                 { Conv27BitFile }

procedure SConv27bit(var S: string; author: boolean);
var
  Blen: Word;
begin
  Blen:=length(S);
  Conv27bit(S[1],Blen,author,255);
  S[0]:=Chr(Blen);
end;                                     { SConv27Bit }

procedure SConv27bitFile(var S: string; author,IsRead: boolean);
var
  Blen: Word;
begin
  Blen:=length(S);
  Conv27bitFile(S[1],Blen,author,255,IsRead);
  S[0]:=Chr(Blen);
end;                                     { SConv27BitFile }

procedure Prog8ToFile8(var Ss; var Blen: word; author: boolean; MaxBig: Word);
begin
  if (FWriteTranslate<>Translate) then
                    Conv27Bit(Ss,Blen,author,MaxBig);
  Conv28BitFile(Ss,Blen,author,false);
end;

procedure File8ToProg8(var Ss; var Blen: word; author: boolean; MaxBig: Word);
begin
  if (FReadTranslate<>FWriteTranslate) then
                    Conv27BitFile(Ss,Blen,author,MaxBig,true);
  Conv28Bit(Ss,Blen,author);
end;

procedure DeSpecial(Var S: string);
var
  i,j,k: Word;
  clear: Boolean;
  tmp: string;
begin
  i:=1;
  while (i<=length(S)) do
  begin
    if S[i]='\' then
    begin
      j:=i;
      tmp:='';
      if (j<length(S)) and (Pos(S[j+1],' ''`^"~=.')>0) then
      begin
        tmp:=S[j+1]; inc(j); k:=j;
      end else
      begin
        while (j<length(S)) and (S[j+1] in TexLett) do
        begin
          inc(j); tmp:=tmp+S[j];
        end;
        k:=j;
        while (k<length(S)) and (S[k+1]=' ') do inc(k);
      end;
      clear:=true;
      if (tmp<>'') and ((length(tmp)>1) or (Pos(tmp[1],'''`^"~=.uvHtcdb')=0)) then
        clear:=false;
      if clear then Delete(S,i,k-i+1)
      else begin
        Delete(S,j+1,k-j+1);
        Delete(S,i,1);
        i:=i+length(tmp);
      end;
    end else if S[i] in [#0..#20,#22..#31,{lbrace,rbrace,}'%',#255] then
    begin
      j:=i;
      while (j<length(S)) and (S[j+1] in [#0..#20,#22..#31,{lbrace,rbrace,}'%',#255])
            do inc(j);
      Delete(S,i,j-i+1);
    end else
    begin
      if S[i]=#9 then S[i]:=' '
      else begin
        j:=1; k:=0;
        while (j<NTranslate) and (k=0) do
        begin
          if S[i]=Translate^[j].c then k:=j;
          inc(j);
        end;
        if k>0 then S[i]:=Translate^[k].N;
      end;
      inc(i);
    end;
  end;
end;                                 {  DeSpecial }


begin
  Translate      :=Nil; NTranslate      :=0; CtrlStartChars      :=[];
  FReadTranslate :=Nil; NFReadTranslate :=0; FReadCtrlStartChars :=[];
  FWriteTranslate:=Nil; NFWriteTranslate:=0; FWriteCtrlStartChars:=[];
  HighUpper:=Nil;
  HighLows:=[];
  New(HighUpper);
  DispEncoding:=-1; FReadEncoding:=-1; FWriteEncoding:=-1;
  UseReadEncodingOnly:=true;
  InitEncList;
end.
