/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;

public abstract class COSNumber
extends COSBase {
    @Deprecated
    public static final COSInteger ZERO = COSInteger.ZERO;
    @Deprecated
    public static final COSInteger ONE = COSInteger.ONE;

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int intValue();

    public abstract long longValue();

    public static COSNumber get(String number) throws IOException {
        if (number.length() == 1) {
            char digit = number.charAt(0);
            if ('0' <= digit && digit <= '9') {
                return COSInteger.get(digit - 48);
            }
            if (digit == '-' || digit == '.') {
                return COSInteger.ZERO;
            }
            throw new IOException("Not a number: " + number);
        }
        if (number.indexOf(46) == -1 && number.toLowerCase().indexOf(101) == -1) {
            try {
                if (number.charAt(0) == '+') {
                    return COSInteger.get(Long.parseLong(number.substring(1)));
                }
                return COSInteger.get(Long.parseLong(number));
            }
            catch (NumberFormatException e) {
                throw new IOException("Value is not an integer: " + number, e);
            }
        }
        return new COSFloat(number);
    }
}

