/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.Command;
import nts.command.DirtySpaceToken;
import nts.command.SpaceToken;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.Log;

public class SpaceToken
extends Token {
    public static final CharCode CODE = Token.makeCharCode(' ');
    public static final SpaceToken TOKEN = new SpaceToken();
    private static Token.CharHandler handler;
    public static final String DESCRIPTION = "blank space";
    public static final Command MEANING;

    public CharCode nonActiveCharCode() {
        return CODE;
    }

    public int numValue() {
        return CODE.numValue();
    }

    public CharCode charCode() {
        return CODE;
    }

    public Token makeCharToken(CharCode code) {
        return DirtySpaceToken.MAKER.make(code);
    }

    public boolean matchSpace() {
        return true;
    }

    public boolean match(Token tok) {
        return tok instanceof SpaceToken;
    }

    public boolean sameCatAs(Token tok) {
        return tok instanceof SpaceToken || tok instanceof DirtySpaceToken;
    }

    public void addOn(Log log) {
        log.add(' ');
    }

    public String toString() {
        return "<Space>";
    }

    public static void setHandler(Token.CharHandler hnd) {
        handler = hnd;
        DirtySpaceToken.setHandler(hnd);
    }

    public Command meaning() {
        return MEANING;
    }

    static /* synthetic */ Token.CharHandler access$0() {
        return handler;
    }

    static {
        MEANING = new 1();
    }
}

