/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class PGls
extends AbstractGlsCommand {
    protected CaseChange caseChange;
    protected boolean isPlural;
    protected boolean isFirst;

    public PGls(GlossariesSty glossariesSty) {
        this("pgls", false, CaseChange.NO_CHANGE, false, glossariesSty);
    }

    public PGls(String string, boolean bl, CaseChange caseChange, GlossariesSty glossariesSty) {
        this(string, bl, caseChange, false, glossariesSty);
    }

    public PGls(String string, boolean bl, CaseChange caseChange, boolean bl2, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.caseChange = caseChange;
        this.isPlural = bl2;
        this.isFirst = bl;
    }

    @Override
    public Object clone() {
        return new PGls(this.getName(), this.isFirst(), this.getCaseChange(), this.isPlural(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        KeyValList keyValList = this.popOptKeyValList(teXObjectList, true);
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        boolean bl = glsLabel.isUnset();
        String string = "prefix";
        if (this.isFirst) {
            string = string + "first";
        }
        if (this.isPlural) {
            string = string + "plural";
        }
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        TeXObject teXObject = glsLabel.getField(string);
        String string2 = "gls";
        if (teXObject == null) {
            switch (this.caseChange) {
                case TO_UPPER: {
                    string2 = "GLS";
                    break;
                }
                case SENTENCE: {
                    string2 = "Gls";
                }
            }
        } else {
            TeXObject teXObject2 = (TeXObject)teXObject.clone();
            switch (this.caseChange) {
                case TO_UPPER: {
                    string2 = "GLS";
                    teXObject2 = TeXParserUtils.createStack(teXParser, new TeXCsRef("uppercase"), TeXParserUtils.createGroup(teXParser, teXObject2));
                    break;
                }
                case SENTENCE: {
                    teXObject2 = TeXParserUtils.createStack(teXParser, new TeXCsRef("makefirstuc"), TeXParserUtils.createGroup(teXParser, teXObject2));
                }
            }
            teXObjectList2.add(teXObject2, true);
            teXObjectList2.add(new TeXCsRef("glsprefixsep"));
        }
        teXObjectList2.add(new TeXCsRef(string2));
        if (keyValList != null) {
            teXObjectList2.add(teXParser.getListener().getOther(91));
            teXObjectList2.add(keyValList);
            teXObjectList2.add(teXParser.getListener().getOther(93));
        }
        teXObjectList2.add(TeXParserUtils.createGroup(teXParser, glsLabel));
        return teXObjectList2;
    }

    public CaseChange getCaseChange() {
        return this.caseChange;
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public boolean isFirst() {
        return this.isFirst;
    }
}

