%% mPICm06.m  (figure 6)
%% mathsPIC   boxed setArrowShape diagram
\documentclass[a4paper]{article}
\usepackage{pictexwd}
\begin{document}
%%-------------------
\beginpicture
paper{units(mm), xrange(0,100), yrange(0,70), axes(LBTR)}%, ticks(10,10)}
%% first do all the small arrows (from top down)
point(J11){5,30}
	 point(J12){20,30}
point(J9){5,25}
	 point(J10){20,25}
point(J7){5,20}
	 point(J8){20,20}
point(J5){5,15}
	 point(J6){20,15}
point(J3){5,10}
	 point(J4){20,10}
point(J1){5,5}
	 point(J2){20,5}
%%
arrowshape(6,30,60)
  drawArrows(J11J12)
arrowshape(4,30,60)
  drawArrows(J9J10)
arrowshape(2,30,60)
  drawArrows(J7J8)
arrowshape(6,30,40)
  drawArrows(J5J6)
arrowshape(4,30,40)
  drawArrows(J3J4)
arrowshape(2,30,40)
  drawArrows(J1J2)
%%
text(\texttt{Arrowshape(2,30,40)}){J2,shift(5,0)}[l]
text(\texttt{Arrowshape(4,30,40)}){J4,shift(5,0)}[l]
text(\texttt{Arrowshape(6,30,40)}){J6,shift(5,0)}[l]
text(\texttt{Arrowshape(2,30,60)}){J8,shift(5,0)}[l]
text(\texttt{Arrowshape(4,30,60)}){J10,shift(5,0)}[l]
text(\texttt{Arrowshape(6,30,60)}){J12,shift(5,0)}[l]
%%
%% now draw big arrow
point(D){30,40}
point(A){D,shift(62,0)}
arrowshape(20,50,75)
drawArrow(DA)
point(B1){82,44.75}
point(B2){82,35.25}
point(C1){72,55}
point(C2){72,25}
drawpoints(DAB1B2C1C2)
text($A$){A, shift(4,0)}
text($B_1$){B1, shift(3,3)}
text($B_2$){B2, shift(3,-3)}
text($C_1$){C1, shift(-4,3)}
text($C_2$){C2, shift(0,-4)}
text($D$){D, shift(-4,0)}
%%
point(T1){10,63}
point(T2){10,57}
point(T3){10,51}
text(\texttt{Arrowshape($L$,$B$,$C$)}){T1}[l]
text($B$ = \mbox{angle $B_1AB_2$ degrees}){T2}[l]
text($C$ = \mbox{angle $C_1AC_2$ degrees}){T3}[l]
%%
\betweenarrows  {$L$} from 74 55  to  92 55
\endpicture
%%-------------------
\end{document}


