// SPDX-License-Identifier: BSD-3-Clause
package org.islandoftex.albatross

import com.github.ajalt.mordant.rendering.TextStyle
import com.github.ajalt.mordant.terminal.TextColors

object Settings {
    const val fontNameColumnFullWidthPercentage = 100
    const val fontNameColumnWidthPercentage = 40
    const val fontStylesColumnWidthPercentage = 60
    const val noEntriesColumnWidthPercentage = 100
    const val notFoundColumnWidthPercentage = 100
    const val detailsKeyColumnWidthPercentage = 12
    const val detailsValueColumnWidthPercentage = 88
    const val detailsPathsColumnWidthPercentage = 100

    val cliTextStyle = TextColors.Companion.rgb("b6a0ff")
    val cliPathStyle = TextColors.Companion.rgb("a8a8a8")
    val cliTitleStyle = TextColors.Companion.rgb("dbbe5f") + TextStyle(bold = true)
    val cliHeaderStyle = TextColors.Companion.rgb("26a269") + TextStyle(bold = true)

    val borderColour = TextColors.Companion.rgb("00d1d0")
}
