%% rn-fig2.m (= tug2000.m)
%% used in TUG-2000 article with Apostolos.
%% mathsPIC
\documentclass[a4paper]{article}
\usepackage{pictexwd}
\begin{document}
\beginpicture
\setdashes
paper{units(mm),xrange(0,70),yrange(0,60),axes(LBT*R*),ticks(10,10)}
\setsolid
point(A){10,10}   %% anchor point
point(B){A, polar(50,50 deg)}
point(C){A,polar(50,0 deg)}
point(J){pointonline(AB,30)}
point(K){perpendicular(J,AC)}
drawRightangle(JKC,3)
drawLines(AB,AC,JK)
drawIncircle(AJK)
drawExcircle(AJK,JK)
\setplotsymbol({\large .})
\setdots
drawCircumcircle(AJK)
point(I){IncircleCenter(AJK)}[$\odot$]
point(E){ExcircleCenter(AJK,JK)}[$\odot$,1.2]
point(P1){perpendicular(E,AC)}
variable(r){EP1}  %% radius of excircle
variable(d){72}   %% angle of pentagon (deg)
variable(a1){-90}
variable(a2){a1, advance(d)}
variable(a3){a2, advance(d)}
variable(a4){a3, advance(d)}
variable(a5){a4, advance(d)}
point(P2){E, polar(r,a2)}
point(P3){E, polar(r,a3)}
point(P4){E, polar(r,a4)}
point(P5){E, polar(r,a5)}
drawPoints(ABCJKIEP1P2P3P4P5)
\setplotsymbol({\tiny .})
\setdashes
drawline(P1P2P3P4P5P1,EP1,EP2)
\setsolid
drawAnglearc{angle(P2EP1),radius(9),internal,clockwise}
\newcommand{\figtitle}{%
   \fbox{%
   \begin{minipage}{30mm}%
   \  Triangle, pentagon and three circles%
   \end{minipage}%
   \  }}%
text(\figtitle){20,52}
variable(s){5}
text($A$){A,polar(s,230 deg)}
text($B$){B,polar(s,50 deg)}
text($C$){C,polar(s,0 deg)}
text($J$){J,polar(s,90 deg)}
text($K$){K,polar(s,270 deg)}
text($E$){E,polar(s,a3 deg)}
text($72$){E,polar(5.5,-54 deg)}
text($I$){I,shift(3, 0)}
text($P_1$){P1,polar(s,a1)}
text($P_2$){P2,polar(s, a2)}
text($P_3$){P3,polar(s, a3)}
\endpicture
\end{document}


