---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              encodage des caractères, problème de codage, 
              problème de clavier
---

# Que signifie l'erreur : "Keyboard character used is undefined in input encoding ⟨enc⟩" ?

- **Message** : `Keyboard character used is undefined in input encoding ⟨enc⟩`
- **Origine** : extension <ctanpkg:inputenc>

Un nombre 8-bits rencontré dans le document ne correspond pas, avec l'encodage 
d'entrée `⟨enc⟩`, à un objet LICR (*LaTeX Internal Character Representation*).
Les sections 7.5.2 et 7.11.3 du *LaTeX Companion* décrivent ce point.

Il conviendrait donc de vérifier si votre fichier source est vraiment 
sauvegardé dans l'encodage indiqué.

Notez cependant que, depuis quelques années, l'utilisation de 
l'extension <ctanpkg:inputenc> n'est plus nécessaire, comme l'indique 
la question
"[](/2_programmation/encodage/pourquoi_m_embeter_avec_inputenc_et_fontenc)".


:::{sources}
- [FAQ erreurs - Lettre K](https://latex.developpez.com/faq/erreurs?page=K), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::